/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.ComponentLookupManager;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.manager.ComponentManager;
import org.codehaus.plexus.component.manager.UndefinedComponentManagerException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.lifecycle.UndefinedLifecycleHandlerException;

public class DefaultComponentLookupManager
implements ComponentLookupManager {
    private MutablePlexusContainer container;

    public Object lookup(String componentKey) throws ComponentLookupException {
        Object component = null;
        ComponentManager componentManager = this.container.getComponentManagerManager().findComponentManagerByComponentKey(componentKey);
        if (this.container.isReloadingEnabled() || componentManager == null) {
            ComponentDescriptor descriptor = this.container.getComponentRepository().getComponentDescriptor(componentKey);
            if (descriptor == null) {
                if (this.container.getParentContainer() != null) {
                    return this.container.getParentContainer().lookup(componentKey);
                }
                this.container.getLogger().debug("Nonexistent component: " + componentKey);
                String message = "Component descriptor cannot be found in the component repository: " + componentKey + ".";
                throw new ComponentLookupException(message);
            }
            componentManager = this.createComponentManager(descriptor);
        }
        try {
            component = componentManager.getComponent();
        }
        catch (ComponentInstantiationException e) {
            throw new ComponentLookupException("Unable to lookup component '" + componentKey + "', it could not be created", e);
        }
        catch (ComponentLifecycleException e) {
            throw new ComponentLookupException("Unable to lookup component '" + componentKey + "', it could not be started", e);
        }
        this.container.getComponentManagerManager().associateComponentWithComponentManager(component, componentManager);
        return component;
    }

    private ComponentManager createComponentManager(ComponentDescriptor descriptor) throws ComponentLookupException {
        ComponentManager componentManager;
        try {
            componentManager = this.container.getComponentManagerManager().createComponentManager(descriptor, this.container);
        }
        catch (UndefinedComponentManagerException e) {
            String message = "Cannot create component manager for " + descriptor.getComponentKey() + ", so we cannot provide a component instance.";
            throw new ComponentLookupException(message, e);
        }
        catch (UndefinedLifecycleHandlerException e) {
            String message = "Cannot create component manager for " + descriptor.getComponentKey() + ", so we cannot provide a component instance.";
            throw new ComponentLookupException(message, e);
        }
        return componentManager;
    }

    public Map lookupMap(String role) throws ComponentLookupException {
        HashMap<String, Object> components = new HashMap<String, Object>();
        Map componentDescriptors = this.container.getComponentDescriptorMap(role);
        if (componentDescriptors != null) {
            Iterator i = componentDescriptors.keySet().iterator();
            while (i.hasNext()) {
                String roleHint = (String)i.next();
                Object component = this.lookup(role, roleHint);
                components.put(roleHint, component);
            }
        }
        return components;
    }

    public List lookupList(String role) throws ComponentLookupException {
        ArrayList<Object> components = new ArrayList<Object>();
        List componentDescriptors = this.container.getComponentDescriptorList(role);
        if (componentDescriptors != null) {
            Iterator i = componentDescriptors.iterator();
            while (i.hasNext()) {
                ComponentDescriptor descriptor = (ComponentDescriptor)i.next();
                String roleHint = descriptor.getRoleHint();
                Object component = roleHint != null ? this.lookup(role, roleHint) : this.lookup(role);
                components.add(component);
            }
        }
        return components;
    }

    public Object lookup(String role, String roleHint) throws ComponentLookupException {
        return this.lookup(role + roleHint);
    }

    public void setContainer(MutablePlexusContainer container) {
        this.container = container;
    }
}

