/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.AbstractExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;
import net.sf.oval.internal.util.ReflectionUtils;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

public class ExpressionLanguageOGNLImpl
extends AbstractExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageOGNLImpl.class);
    private static final MemberAccess MEMBER_ACCESS = new MemberAccess(){

        public boolean isAccessible(Map context, Object target, Member member, String propertyName) {
            return true;
        }

        public void restore(Map context, Object target, Member member, String propertyName, Object oldAccessibleState) {
            if (!((Boolean)oldAccessibleState).booleanValue()) {
                AccessibleObject accessible = (AccessibleObject)((Object)member);
                ReflectionUtils.setAccessible(accessible, false);
            }
        }

        public Boolean setup(Map context, Object target, Member member, String propertyName) {
            AccessibleObject accessible = (AccessibleObject)((Object)member);
            boolean oldAccessibleState = accessible.isAccessible();
            if (!oldAccessibleState) {
                ReflectionUtils.setAccessible(accessible, true);
            }
            return oldAccessibleState;
        }
    };
    private final ObjectCache<String, Object> expressionCache = new ObjectCache<String, Object>(expression -> {
        try {
            return Ognl.parseExpression((String)expression);
        }
        catch (OgnlException ex) {
            throw new ExpressionEvaluationException("Parsing MVEL expression failed: " + expression, ex);
        }
    });

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating OGNL expression: {1}", expression);
        try {
            OgnlContext ctx = (OgnlContext)Ognl.createDefaultContext(null, (MemberAccess)MEMBER_ACCESS);
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                ctx.put((Object)entry.getKey(), entry.getValue());
            }
            Object expr = this.expressionCache.get(expression);
            return Ognl.getValue((Object)expr, (Map)ctx, (Object)ctx, null);
        }
        catch (OgnlException ex) {
            throw new ExpressionEvaluationException("Evaluating MVEL expression failed: " + expression, ex);
        }
    }
}

