/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExpressionVisitor;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.Type;

public class LoopExpression
extends Expression {
    private final Type type;
    private final String key;
    private final String var;
    private final Expression iterable;
    private final Expression iterator;
    private final Expression subexpression;
    private final Expression delimiter;

    public LoopExpression(Node fromNode, Type type, String key, String var, Expression iterable, Expression iterator, Expression subexpression, Expression delimiter) {
        super(fromNode, subexpression.getSchema());
        this.type = Preconditions.checkNotNull(type);
        this.key = key;
        this.var = Preconditions.checkNotNull(var);
        this.iterable = iterable;
        this.iterator = iterator;
        this.subexpression = Preconditions.checkNotNull(subexpression);
        this.delimiter = Preconditions.checkNotNull(delimiter);
    }

    public Type getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getVar() {
        return this.var;
    }

    public Expression getIterable() {
        return this.iterable;
    }

    public Expression getIterator() {
        return this.iterator;
    }

    public Expression getSubexpression() {
        return this.subexpression;
    }

    public Expression getDelimiter() {
        return this.delimiter;
    }

    public LoopExpression withSubexpressionAndDelimiter(Expression newSubexpression, Expression newDelimiter) {
        return Objects.equal(this.subexpression, newSubexpression) && Objects.equal(this.delimiter, newDelimiter) ? this : new LoopExpression(this, this.type, this.key, this.var, this.iterable, this.iterator, newSubexpression, newDelimiter);
    }

    @Override
    public <T> T acceptVisitor(ExpressionVisitor<T> visitor) {
        return visitor.visitLoopExpression(this);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof LoopExpression && this.equals((LoopExpression)that);
    }

    public boolean equals(LoopExpression that) {
        return this.equalsExpression(that) && Objects.equal(this.type, that.type) && Objects.equal(this.key, that.key) && Objects.equal(this.var, that.var) && Objects.equal(this.iterable, that.iterable) && Objects.equal(this.iterator, that.iterator) && Objects.equal(this.subexpression, that.subexpression) && Objects.equal(this.delimiter, that.delimiter);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.expressionHashCode(), this.type, this.key, this.var, this.iterable, this.iterator, this.subexpression, this.delimiter);
    }
}

