/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.TextProviderFactory;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.FieldValidator;
import com.opensymphony.xwork2.validator.ShortCircuitableValidator;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorConfig;
import com.opensymphony.xwork2.validator.ValidatorContext;
import com.opensymphony.xwork2.validator.ValidatorFactory;
import com.opensymphony.xwork2.validator.ValidatorFileParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultActionValidatorManager
implements ActionValidatorManager {
    private static final Logger LOG = LogManager.getLogger(DefaultActionValidatorManager.class);
    protected static final String VALIDATION_CONFIG_SUFFIX = "-validation.xml";
    private final Map<String, List<ValidatorConfig>> validatorCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, List<ValidatorConfig>> validatorFileCache = Collections.synchronizedMap(new HashMap());
    private ValidatorFactory validatorFactory;
    private ValidatorFileParser validatorFileParser;
    private FileManager fileManager;
    private boolean reloadingConfigs;
    private TextProviderFactory textProviderFactory;

    @Inject
    public void setValidatorFileParser(ValidatorFileParser parser) {
        this.validatorFileParser = parser;
    }

    @Inject
    public void setValidatorFactory(ValidatorFactory fac) {
        this.validatorFactory = fac;
    }

    @Inject
    public void setFileManagerFactory(FileManagerFactory fileManagerFactory) {
        this.fileManager = fileManagerFactory.getFileManager();
    }

    @Inject(value="struts.configuration.xml.reload", required=false)
    public void setReloadingConfigs(String reloadingConfigs) {
        this.reloadingConfigs = Boolean.parseBoolean(reloadingConfigs);
    }

    @Inject
    public void setTextProviderFactory(TextProviderFactory textProviderFactory) {
        this.textProviderFactory = textProviderFactory;
    }

    @Override
    public synchronized List<Validator> getValidators(Class clazz, String context) {
        return this.getValidators(clazz, context, null);
    }

    @Override
    public synchronized List<Validator> getValidators(Class clazz, String context, String method) {
        String validatorKey = DefaultActionValidatorManager.buildValidatorKey(clazz, context);
        if (this.validatorCache.containsKey(validatorKey)) {
            if (this.reloadingConfigs) {
                this.validatorCache.put(validatorKey, this.buildValidatorConfigs(clazz, context, true, null));
            }
        } else {
            this.validatorCache.put(validatorKey, this.buildValidatorConfigs(clazz, context, false, null));
        }
        ValueStack stack = ActionContext.getContext().getValueStack();
        List<ValidatorConfig> cfgs = this.validatorCache.get(validatorKey);
        ArrayList<Validator> validators = new ArrayList<Validator>(cfgs.size());
        for (ValidatorConfig cfg : cfgs) {
            if (method != null && !method.equals(cfg.getParams().get("methodName"))) continue;
            Validator validator = this.validatorFactory.getValidator(cfg);
            validator.setValidatorType(cfg.getType());
            validator.setValueStack(stack);
            validators.add(validator);
        }
        return validators;
    }

    @Override
    public void validate(Object object, String context) throws ValidationException {
        this.validate(object, context, (String)null);
    }

    @Override
    public void validate(Object object, String context, String method) throws ValidationException {
        DelegatingValidatorContext validatorContext = new DelegatingValidatorContext(object, this.textProviderFactory);
        this.validate(object, context, validatorContext, method);
    }

    @Override
    public void validate(Object object, String context, ValidatorContext validatorContext) throws ValidationException {
        this.validate(object, context, validatorContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(Object object, String context, ValidatorContext validatorContext, String method) throws ValidationException {
        List<Validator> validators = this.getValidators(object.getClass(), context, method);
        TreeSet<String> shortcircuitedFields = null;
        for (Validator validator : validators) {
            try {
                validator.setValidatorContext(validatorContext);
                LOG.debug("Running validator: {} for object {} and method {}", (Object)validator, object, (Object)method);
                FieldValidator fValidator = null;
                String fullFieldName = null;
                if (validator instanceof FieldValidator) {
                    fValidator = (FieldValidator)validator;
                    fullFieldName = fValidator.getValidatorContext().getFullFieldName(fValidator.getFieldName());
                    if (shortcircuitedFields != null && shortcircuitedFields.contains(fullFieldName)) {
                        LOG.debug("Short-circuited, skipping");
                        continue;
                    }
                }
                if (validator instanceof ShortCircuitableValidator && ((ShortCircuitableValidator)((Object)validator)).isShortCircuit()) {
                    Collection errCol;
                    Collection<String> actionErrors;
                    ArrayList<String> errs = null;
                    if (fValidator != null) {
                        Collection fieldErrors;
                        if (validatorContext.hasFieldErrors() && (fieldErrors = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) != null) {
                            errs = new ArrayList(fieldErrors);
                        }
                    } else if (validatorContext.hasActionErrors() && (actionErrors = validatorContext.getActionErrors()) != null) {
                        errs = new ArrayList<String>(actionErrors);
                    }
                    validator.validate(object);
                    if (fValidator != null) {
                        if (!validatorContext.hasFieldErrors() || (errCol = (Collection)validatorContext.getFieldErrors().get(fullFieldName)) == null || errCol.equals(errs)) continue;
                        LOG.debug("Short-circuiting on field validation");
                        if (shortcircuitedFields == null) {
                            shortcircuitedFields = new TreeSet<String>();
                        }
                        shortcircuitedFields.add(fullFieldName);
                        continue;
                    }
                    if (!validatorContext.hasActionErrors() || (errCol = validatorContext.getActionErrors()) == null || errCol.equals(errs)) continue;
                    LOG.debug("Short-circuiting");
                    break;
                }
                validator.validate(object);
            }
            finally {
                validator.setValidatorContext(null);
            }
        }
    }

    protected static String buildValidatorKey(Class clazz, String context) {
        StringBuilder sb = new StringBuilder(clazz.getName());
        sb.append("/");
        sb.append(context);
        return sb.toString();
    }

    private List<ValidatorConfig> buildAliasValidatorConfigs(Class aClass, String context, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + "-" + context + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    private List<ValidatorConfig> buildClassValidatorConfigs(Class aClass, boolean checkFile) {
        String fileName = aClass.getName().replace('.', '/') + VALIDATION_CONFIG_SUFFIX;
        return this.loadFile(fileName, aClass, checkFile);
    }

    private List<ValidatorConfig> buildValidatorConfigs(Class clazz, String context, boolean checkFile, Set<String> checked) {
        ArrayList<ValidatorConfig> validatorConfigs = new ArrayList<ValidatorConfig>();
        if (checked == null) {
            checked = new TreeSet<String>();
        } else if (checked.contains(clazz.getName())) {
            return validatorConfigs;
        }
        if (clazz.isInterface()) {
            for (Class<?> anInterface : clazz.getInterfaces()) {
                validatorConfigs.addAll(this.buildValidatorConfigs(anInterface, context, checkFile, checked));
            }
        } else if (!clazz.equals(Object.class)) {
            validatorConfigs.addAll(this.buildValidatorConfigs(clazz.getSuperclass(), context, checkFile, checked));
        }
        for (Class<?> anInterface1 : clazz.getInterfaces()) {
            if (checked.contains(anInterface1.getName())) continue;
            validatorConfigs.addAll(this.buildClassValidatorConfigs(anInterface1, checkFile));
            if (context != null) {
                validatorConfigs.addAll(this.buildAliasValidatorConfigs(anInterface1, context, checkFile));
            }
            checked.add(anInterface1.getName());
        }
        validatorConfigs.addAll(this.buildClassValidatorConfigs(clazz, checkFile));
        if (context != null) {
            validatorConfigs.addAll(this.buildAliasValidatorConfigs(clazz, context, checkFile));
        }
        checked.add(clazz.getName());
        return validatorConfigs;
    }

    private List<ValidatorConfig> loadFile(String fileName, Class clazz, boolean checkFile) {
        List<ValidatorConfig> retList = Collections.emptyList();
        URL fileUrl = ClassLoaderUtil.getResource(fileName, clazz);
        if (checkFile && this.fileManager.fileNeedsReloading(fileUrl) || !this.validatorFileCache.containsKey(fileName)) {
            try (InputStream is = this.fileManager.loadFile(fileUrl);){
                if (is != null) {
                    retList = new ArrayList<ValidatorConfig>(this.validatorFileParser.parseActionValidatorConfigs(this.validatorFactory, is, fileName));
                }
            }
            catch (IOException e) {
                LOG.error("Caught exception while loading file {}", (Object)fileName, (Object)e);
            }
            this.validatorFileCache.put(fileName, retList);
        } else {
            retList = this.validatorFileCache.get(fileName);
        }
        return retList;
    }
}

