/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.sf.oval.Validator;

public final class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static List<?> asList(Object array) {
        if (array instanceof Object[]) {
            Object[] arrayCasted = (Object[])array;
            List result = Validator.getCollectionFactory().createList(arrayCasted.length);
            Collections.addAll(result, arrayCasted);
            return result;
        }
        if (array instanceof byte[]) {
            byte[] arrayCasted = (byte[])array;
            List result = Validator.getCollectionFactory().createList(arrayCasted.length);
            byte[] byArray = arrayCasted;
            int n = arrayCasted.length;
            int n2 = 0;
            while (n2 < n) {
                byte i = byArray[n2];
                result.add(i);
                ++n2;
            }
            return result;
        }
        if (array instanceof char[]) {
            char[] arrayCasted = (char[])array;
            List result = Validator.getCollectionFactory().createList(arrayCasted.length);
            char[] cArray = arrayCasted;
            int n = arrayCasted.length;
            int n3 = 0;
            while (n3 < n) {
                char i = cArray[n3];
                result.add(Character.valueOf(i));
                ++n3;
            }
            return result;
        }
        if (array instanceof short[]) {
            short[] arrayCasted = (short[])array;
            List result = Validator.getCollectionFactory().createList(arrayCasted.length);
            short[] sArray = arrayCasted;
            int n = arrayCasted.length;
            int n4 = 0;
            while (n4 < n) {
                short i = sArray[n4];
                result.add(i);
                ++n4;
            }
            return result;
        }
        if (array instanceof int[]) {
            int[] arrayCasted = (int[])array;
            List result = Validator.getCollectionFactory().createList(arrayCasted.length);
            int[] nArray = arrayCasted;
            int n = arrayCasted.length;
            int n5 = 0;
            while (n5 < n) {
                int i = nArray[n5];
                result.add(i);
                ++n5;
            }
            return result;
        }
        if (array instanceof long[]) {
            long[] arrayCasted = (long[])array;
            List result = Validator.getCollectionFactory().createList(arrayCasted.length);
            long[] lArray = arrayCasted;
            int n = arrayCasted.length;
            int n6 = 0;
            while (n6 < n) {
                long i = lArray[n6];
                result.add(i);
                ++n6;
            }
            return result;
        }
        if (array instanceof double[]) {
            double[] arrayCasted = (double[])array;
            List result = Validator.getCollectionFactory().createList(arrayCasted.length);
            double[] dArray = arrayCasted;
            int n = arrayCasted.length;
            int n7 = 0;
            while (n7 < n) {
                double i = dArray[n7];
                result.add(i);
                ++n7;
            }
            return result;
        }
        if (array instanceof float[]) {
            float[] arrayCasted = (float[])array;
            List result = Validator.getCollectionFactory().createList(arrayCasted.length);
            float[] fArray = arrayCasted;
            int n = arrayCasted.length;
            int n8 = 0;
            while (n8 < n) {
                float i = fArray[n8];
                result.add(Float.valueOf(i));
                ++n8;
            }
            return result;
        }
        if (array instanceof boolean[]) {
            boolean[] arrayCasted = (boolean[])array;
            List result = Validator.getCollectionFactory().createList(arrayCasted.length);
            boolean[] blArray = arrayCasted;
            int n = arrayCasted.length;
            int n9 = 0;
            while (n9 < n) {
                boolean i = blArray[n9];
                result.add(i);
                ++n9;
            }
            return result;
        }
        throw new IllegalArgumentException("Argument [array] must be an array");
    }

    public static <T> List<T> asList(T[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Validator.getCollectionFactory().createList();
        }
        List list = Validator.getCollectionFactory().createList(array.length);
        Collections.addAll(list, array);
        return list;
    }

    public static <T> Set<T> asSet(T[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Validator.getCollectionFactory().createSet();
        }
        Set set = Validator.getCollectionFactory().createSet(array.length);
        Collections.addAll(set, array);
        return set;
    }

    public static <T> boolean containsEqual(T[] theArray, T theItem) {
        T[] TArray = theArray;
        int n = theArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == theItem) {
                return true;
            }
            if (t != null && t.equals(theItem)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean containsSame(T[] theArray, T theItem) {
        T[] TArray = theArray;
        int n = theArray.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == theItem) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void iterate(Object array, BiConsumer<Integer, Object> onElement) {
        if (array instanceof Object[]) {
            Object[] arrayCasted = (Object[])array;
            int i = 0;
            int l = arrayCasted.length;
            while (i < l) {
                onElement.accept(i, arrayCasted[i]);
                ++i;
            }
            return;
        }
        if (array instanceof byte[]) {
            byte[] arrayCasted = (byte[])array;
            int i = 0;
            int l = arrayCasted.length;
            while (i < l) {
                onElement.accept(i, arrayCasted[i]);
                ++i;
            }
            return;
        }
        if (array instanceof char[]) {
            char[] arrayCasted = (char[])array;
            int i = 0;
            int l = arrayCasted.length;
            while (i < l) {
                onElement.accept(i, Character.valueOf(arrayCasted[i]));
                ++i;
            }
            return;
        }
        if (array instanceof short[]) {
            short[] arrayCasted = (short[])array;
            int i = 0;
            int l = arrayCasted.length;
            while (i < l) {
                onElement.accept(i, arrayCasted[i]);
                ++i;
            }
            return;
        }
        if (array instanceof int[]) {
            int[] arrayCasted = (int[])array;
            int i = 0;
            int l = arrayCasted.length;
            while (i < l) {
                onElement.accept(i, arrayCasted[i]);
                ++i;
            }
            return;
        }
        if (array instanceof long[]) {
            long[] arrayCasted = (long[])array;
            int i = 0;
            int l = arrayCasted.length;
            while (i < l) {
                onElement.accept(i, arrayCasted[i]);
                ++i;
            }
            return;
        }
        if (array instanceof double[]) {
            double[] arrayCasted = (double[])array;
            int i = 0;
            int l = arrayCasted.length;
            while (i < l) {
                onElement.accept(i, arrayCasted[i]);
                ++i;
            }
            return;
        }
        if (array instanceof float[]) {
            float[] arrayCasted = (float[])array;
            int i = 0;
            int l = arrayCasted.length;
            while (i < l) {
                onElement.accept(i, Float.valueOf(arrayCasted[i]));
                ++i;
            }
            return;
        }
        if (array instanceof boolean[]) {
            boolean[] arrayCasted = (boolean[])array;
            int i = 0;
            int l = arrayCasted.length;
            while (i < l) {
                onElement.accept(i, arrayCasted[i]);
                ++i;
            }
            return;
        }
        throw new IllegalArgumentException("Argument [array] must be an array");
    }

    private ArrayUtils() {
    }
}

