/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.admin.actions;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.struts2.action.ServletContextAware;
import org.apache.struts2.osgi.BundleAccessor;
import org.apache.struts2.osgi.host.OsgiHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class BundlesAction
extends ActionSupport
implements ServletContextAware {
    private String id;
    private BundleAccessor bundleAccessor;
    private Configuration configuration;
    private OsgiHost osgiHost;

    public String index() {
        return "success";
    }

    public String view() {
        return "success";
    }

    public String start() throws BundleException {
        this.clearErrorsAndMessages();
        this.addActionMessage("Start - OSGi Host: " + this.osgiHost + ", ID: " + this.id);
        Bundle bundle = (Bundle)this.osgiHost.getBundles().get(this.id);
        try {
            bundle.start();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            this.addActionError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        return this.view();
    }

    public String stop() throws BundleException {
        this.clearErrorsAndMessages();
        this.addActionMessage("Stop - OSGi Host: " + this.osgiHost + ", ID: " + this.id);
        Bundle bundle = (Bundle)this.osgiHost.getBundles().get(this.id);
        try {
            bundle.stop();
        }
        catch (Exception e) {
            this.addActionError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        return this.view();
    }

    public String update() throws BundleException {
        this.clearErrorsAndMessages();
        this.addActionMessage("Update - OSGi Host: " + this.osgiHost + ", ID: " + this.id);
        Bundle bundle = (Bundle)this.osgiHost.getBundles().get(this.id);
        try {
            bundle.update();
        }
        catch (Exception e) {
            this.addActionError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
        }
        return this.view();
    }

    public boolean isStrutsEnabled(Bundle bundle) {
        return "true".equalsIgnoreCase((String)bundle.getHeaders().get("Struts2-Enabled"));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Bundle getBundle() {
        return (Bundle)this.osgiHost.getBundles().get(this.id);
    }

    public List<PackageConfig> getPackages() {
        ArrayList<PackageConfig> pkgs = new ArrayList<PackageConfig>();
        Bundle bundle = this.getBundle();
        if (bundle.getState() == 32) {
            this.bundleAccessor.getPackagesByBundle(bundle).stream().map(name -> this.configuration.getPackageConfig(name)).filter(packageConfig -> packageConfig != null).forEachOrdered(packageConfig -> pkgs.add((PackageConfig)packageConfig));
        }
        return pkgs;
    }

    public ArrayList<String> getHeaderKeys() {
        return Collections.list(this.getBundle().getHeaders().keys());
    }

    public Collection<Bundle> getBundles() {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>(this.osgiHost.getBundles().values());
        Collections.sort(bundles, (bundle1, bundle2) -> {
            boolean bundle1StrutsEnabled = this.isStrutsEnabled((Bundle)bundle1);
            boolean bundle2StrutsEnabled = this.isStrutsEnabled((Bundle)bundle2);
            if (bundle1StrutsEnabled && bundle2StrutsEnabled || !bundle1StrutsEnabled && !bundle2StrutsEnabled) {
                return bundle1.getSymbolicName().compareTo(bundle2.getSymbolicName());
            }
            return bundle1StrutsEnabled ? -1 : 1;
        });
        return bundles;
    }

    public String displayProperty(Object obj) {
        if (obj.getClass().isArray()) {
            return Arrays.asList((Object[])obj).toString();
        }
        return obj.toString();
    }

    public String getBundleState(Bundle bundle) {
        switch (bundle.getState()) {
            case 32: {
                return "Active";
            }
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninstalled";
            }
        }
        throw new IllegalStateException("Invalid state");
    }

    public boolean isAllowedAction(Bundle bundle, String val) {
        int state = -1;
        try {
            state = bundle.getState();
        }
        catch (Exception e) {
            this.addActionError("Unable to determine bundle state.  Exception: " + e.toString() + " (" + e.getMessage() + ")");
            return false;
        }
        if (val != null) {
            switch (val) {
                case "start": {
                    return state == 4;
                }
                case "stop": {
                    return state == 32;
                }
                case "update": {
                    return state == 32 || state == 2 || state == 4;
                }
            }
        }
        throw new IllegalArgumentException("Invalid state");
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Inject
    public void setBundleAccessor(BundleAccessor bundleAccessor) {
        this.bundleAccessor = bundleAccessor;
    }

    public void withServletContext(ServletContext servletContext) {
        this.osgiHost = (OsgiHost)servletContext.getAttribute("__struts_osgi_host");
    }
}

