/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jsp;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.ApplicationMap;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.dispatcher.RequestMap;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.util.AttributeMap;

public class TagUtils {
    private static final Logger LOG = LogManager.getLogger(TagUtils.class);

    public static ValueStack getStack(PageContext pageContext) {
        HttpServletRequest req = (HttpServletRequest)pageContext.getRequest();
        ValueStack stack = ServletActionContext.getValueStack(req);
        if (stack == null) {
            HttpServletResponse res = (HttpServletResponse)pageContext.getResponse();
            Dispatcher du = Dispatcher.getInstance();
            if (du == null) {
                throw new ConfigurationException("The Struts dispatcher cannot be found.  This is usually caused by using Struts tags without the associated filter. Struts tags are only usable when the request has passed through its servlet filter, which initializes the Struts dispatcher needed for this tag.");
            }
            stack = du.getContainer().getInstance(ValueStackFactory.class).createValueStack();
            HttpParameters params = HttpParameters.create(req.getParameterMap()).build();
            Map<String, Object> extraContext = du.createContextMap(new RequestMap(req), params, new SessionMap<String, Object>(req), new ApplicationMap(pageContext.getServletContext()), req, res);
            extraContext.put("com.opensymphony.xwork2.dispatcher.PageContext", pageContext);
            stack.getContext().putAll(extraContext);
            req.setAttribute("struts.valueStack", (Object)stack);
            ActionContext.of(stack.getContext()).bind();
        } else {
            Map<String, Object> context = stack.getContext();
            context.put("com.opensymphony.xwork2.dispatcher.PageContext", pageContext);
            AttributeMap attrMap = new AttributeMap(context);
            context.put("attr", attrMap);
        }
        return stack;
    }

    public static String buildNamespace(ActionMapper mapper, ValueStack stack, HttpServletRequest request) {
        ActionContext context = ActionContext.of(stack.getContext());
        ActionInvocation invocation = context.getActionInvocation();
        if (invocation == null) {
            LOG.warn("ActionInvocation is null, tag has been executed out of the Action and this can lead to a security vulnerability, please read http://struts.apache.org/security/#never-expose-jsp-files-directly !");
            ActionMapping mapping = mapper.getMapping(request, Dispatcher.getInstance().getConfigurationManager());
            if (mapping != null) {
                return mapping.getNamespace();
            }
            String path = RequestUtils.getServletPath(request);
            return path.substring(0, path.lastIndexOf(47));
        }
        return invocation.getProxy().getNamespace();
    }
}

