/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.OgnlNullHandlerWrapper;
import com.opensymphony.xwork2.ognl.OgnlValueStack;
import com.opensymphony.xwork2.ognl.accessor.CompoundRootAccessor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.ValueStackFactory;
import java.util.Set;
import ognl.MethodAccessor;
import ognl.NullHandler;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.commons.lang3.BooleanUtils;

public class OgnlValueStackFactory
implements ValueStackFactory {
    protected XWorkConverter xworkConverter;
    protected CompoundRootAccessor compoundRootAccessor;
    protected TextProvider textProvider;
    protected Container container;

    @Inject
    protected void setXWorkConverter(XWorkConverter converter) {
        this.xworkConverter = converter;
    }

    @Inject(value="system")
    protected void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @Override
    public ValueStack createValueStack() {
        OgnlValueStack stack = new OgnlValueStack(this.xworkConverter, this.compoundRootAccessor, this.textProvider, this.containerAllowsStaticFieldAccess());
        this.container.inject(stack);
        return stack.getActionContext().withContainer(this.container).withValueStack(stack).getValueStack();
    }

    @Override
    public ValueStack createValueStack(ValueStack stack) {
        OgnlValueStack result = new OgnlValueStack(stack, this.xworkConverter, this.compoundRootAccessor, this.containerAllowsStaticFieldAccess());
        this.container.inject(result);
        return result.getActionContext().withContainer(this.container).withValueStack(result).getValueStack();
    }

    @Inject
    protected void setContainer(Container container) throws ClassNotFoundException {
        Class<?> cls;
        Set<String> names = container.getInstanceNames(PropertyAccessor.class);
        for (String name : names) {
            cls = Class.forName(name);
            OgnlRuntime.setPropertyAccessor(cls, (PropertyAccessor)container.getInstance(PropertyAccessor.class, name));
            if (this.compoundRootAccessor != null || !CompoundRoot.class.isAssignableFrom(cls)) continue;
            this.compoundRootAccessor = (CompoundRootAccessor)container.getInstance(PropertyAccessor.class, name);
        }
        names = container.getInstanceNames(MethodAccessor.class);
        for (String name : names) {
            cls = Class.forName(name);
            OgnlRuntime.setMethodAccessor(cls, (MethodAccessor)container.getInstance(MethodAccessor.class, name));
        }
        names = container.getInstanceNames(com.opensymphony.xwork2.conversion.NullHandler.class);
        for (String name : names) {
            cls = Class.forName(name);
            OgnlRuntime.setNullHandler(cls, (NullHandler)new OgnlNullHandlerWrapper(container.getInstance(com.opensymphony.xwork2.conversion.NullHandler.class, name)));
        }
        if (this.compoundRootAccessor == null) {
            throw new IllegalStateException("Couldn't find the compound root accessor");
        }
        this.container = container;
    }

    protected boolean containerAllowsStaticFieldAccess() {
        return BooleanUtils.toBoolean((String)this.container.getInstance(String.class, "struts.ognl.allowStaticFieldAccess"));
    }
}

