/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.validate;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.ImmutableSet;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.com.google.common.collect.Sets;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.MissingAttributeError;
import com.google.gxp.compiler.alerts.common.RequiredAttributeHasCondError;
import com.google.gxp.compiler.alerts.common.UnknownAttributeError;
import com.google.gxp.compiler.base.AbbrExpression;
import com.google.gxp.compiler.base.AttrBundleParam;
import com.google.gxp.compiler.base.BoundCall;
import com.google.gxp.compiler.base.BoundImplementsDeclaration;
import com.google.gxp.compiler.base.BundleType;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.Implementable;
import com.google.gxp.compiler.base.ImplementsDeclaration;
import com.google.gxp.compiler.base.ImplementsVisitor;
import com.google.gxp.compiler.base.Interface;
import com.google.gxp.compiler.base.NativeImplementsDeclaration;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.OutputElement;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.UnboundCall;
import com.google.gxp.compiler.base.UnboundImplementsDeclaration;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.base.ValidatedCall;
import com.google.gxp.compiler.escape.EscapedTree;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.validate.ConflictingVarNameError;
import com.google.gxp.compiler.validate.DuplicateAttributeError;
import com.google.gxp.compiler.validate.DuplicateParameterNameError;
import com.google.gxp.compiler.validate.InterfaceParamHasConstructorError;
import com.google.gxp.compiler.validate.InterfaceParamHasDefaultValueError;
import com.google.gxp.compiler.validate.InvalidAttrBundleError;
import com.google.gxp.compiler.validate.MismatchedAttributeValidatorsError;
import com.google.gxp.compiler.validate.NumParamsMismatchError;
import com.google.gxp.compiler.validate.ParamConstructorMismatchError;
import com.google.gxp.compiler.validate.ParamDefaultMismatchError;
import com.google.gxp.compiler.validate.ParamNameMismatchError;
import com.google.gxp.compiler.validate.ParamTypeMismatchError;
import com.google.gxp.compiler.validate.SchemaMismatchError;
import com.google.gxp.compiler.validate.TemplateParamWithHasConstructorError;
import com.google.gxp.compiler.validate.TemplateParamWithHasDefaultError;
import com.google.gxp.compiler.validate.TooManyContentParametersError;
import com.google.gxp.compiler.validate.ValidatedTree;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Validator
implements Function<EscapedTree, ValidatedTree> {
    @Override
    public ValidatedTree apply(EscapedTree tree) {
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder(tree.getAlerts());
        Root root = tree.getRoot().acceptVisitor(new Visitor(alertSetBuilder));
        return new ValidatedTree(tree.getSourcePosition(), alertSetBuilder.buildAndClear(), root);
    }

    private static class Visitor
    extends ExhaustiveExpressionVisitor
    implements CallVisitor<Call>,
    ImplementsVisitor<Void> {
        private final AlertSink alertSink;
        private Template template = null;
        private final Deque<String> varNames = new ArrayDeque<String>();

        Visitor(AlertSink alertSink) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
        }

        private void checkForDuplicateParams(Iterable<Parameter> params) {
            HashSet<String> names = Sets.newHashSet();
            boolean foundContentConsumer = false;
            for (Parameter parameter : params) {
                for (String name : parameter.getNames()) {
                    if (names.contains(name)) {
                        this.alertSink.add(new DuplicateParameterNameError(parameter, name));
                        continue;
                    }
                    names.add(name);
                }
                if (!parameter.consumesContent()) continue;
                if (foundContentConsumer) {
                    this.alertSink.add(new TooManyContentParametersError(parameter));
                    continue;
                }
                foundContentConsumer = true;
            }
        }

        @Override
        public Interface visitInterface(Interface iface) {
            this.checkForDuplicateParams(iface.getParameters());
            for (Parameter param : iface.getParameters()) {
                if (param.getDefaultValue() != null) {
                    this.alertSink.add(new InterfaceParamHasDefaultValueError(param));
                }
                if (param.getConstructor() == null) continue;
                this.alertSink.add(new InterfaceParamHasConstructorError(param));
            }
            return super.visitInterface(iface);
        }

        @Override
        public Template visitTemplate(Template template) {
            this.template = template;
            Iterable<Parameter> params = Iterables.concat(template.getConstructor().getParameters(), template.getParameters());
            this.checkForDuplicateParams(params);
            for (Parameter param : params) {
                if (param.hasDefaultFlag()) {
                    this.alertSink.add(new TemplateParamWithHasDefaultError(param));
                }
                if (param.hasConstructorFlag()) {
                    this.alertSink.add(new TemplateParamWithHasConstructorError(param));
                }
                this.varNames.push(param.getPrimaryName());
            }
            for (ImplementsDeclaration id : template.getImplementsDeclarations()) {
                id.acceptImplementsVisitor(this);
            }
            return super.visitTemplate(template);
        }

        @Override
        public Expression visitAbbrExpression(AbbrExpression abbr) {
            if (this.varNames.contains(abbr.getName())) {
                this.alertSink.add(new ConflictingVarNameError(abbr));
            }
            this.varNames.push(abbr.getName());
            Expression ret = super.visitAbbrExpression(abbr);
            this.varNames.pop();
            return ret;
        }

        private void validateAttributeBundles(Node node, List<String> attributeBundles, Map<String, AttributeValidator> validatorMap, Set<String> allowedAttributes) {
            HashSet<String> foundAttributes = Sets.newHashSet();
            for (String string : attributeBundles) {
                Parameter parameter = this.template.getParameterByPrimary(string);
                if (parameter == null || !(parameter.getType() instanceof BundleType)) {
                    this.alertSink.add(new InvalidAttrBundleError(node, string));
                    continue;
                }
                for (Map.Entry<String, AttributeValidator> attr : ((BundleType)parameter.getType()).getAttrMap().entrySet()) {
                    AttributeValidator validator = validatorMap.get(attr.getKey());
                    if (validator == null) {
                        if (allowedAttributes.contains(attr.getKey())) {
                            this.alertSink.add(new DuplicateAttributeError(node, string, attr.getKey()));
                            continue;
                        }
                        this.alertSink.add(new UnknownAttributeError(node, attr.getKey()));
                        continue;
                    }
                    if (!validator.equals(attr.getValue())) {
                        this.alertSink.add(new MismatchedAttributeValidatorsError(node, attr.getKey(), parameter.getPrimaryName()));
                        continue;
                    }
                    foundAttributes.add(attr.getKey());
                }
            }
            for (Map.Entry entry : validatorMap.entrySet()) {
                if (!((AttributeValidator)entry.getValue()).isFlagSet(AttributeValidator.Flag.REQUIRED) || foundAttributes.contains(entry.getKey())) continue;
                this.alertSink.add(new MissingAttributeError(node, (String)entry.getKey()));
            }
        }

        @Override
        public Expression visitOutputElement(OutputElement element) {
            HashMap<String, AttributeValidator> validatorMap = Maps.newHashMap(element.getValidator().getAttributeValidatorMap());
            ImmutableSet<String> allowedAttributes = ImmutableSet.copyOf(validatorMap.keySet());
            for (Attribute attr : element.getAttributes()) {
                AttributeValidator validator = (AttributeValidator)validatorMap.remove(attr.getName());
                if (attr.getCondition() == null || !validator.isFlagSet(AttributeValidator.Flag.REQUIRED)) continue;
                this.alertSink.add(new RequiredAttributeHasCondError(element, attr));
            }
            if (this.template == null) {
                throw new AssertionError((Object)"found output element without a template");
            }
            this.validateAttributeBundles(element, element.getAttrBundles(), validatorMap, allowedAttributes);
            return super.visitOutputElement(element);
        }

        @Override
        public Expression visitCall(Call call) {
            return call.acceptCallVisitor(this);
        }

        @Override
        public Call visitValidatedCall(ValidatedCall call) {
            return call.transformParams(this);
        }

        @Override
        public Call visitUnboundCall(UnboundCall call) {
            throw new UnexpectedNodeException(call);
        }

        @Override
        public Call visitBoundCall(BoundCall call) {
            Callable callee = call.getCallee();
            ImmutableMap.Builder<String, Attribute> newAttrBuilder = ImmutableMap.builder();
            HashMap<String, AttributeValidator> validatorMap = Maps.newHashMap();
            for (FormalParameter parameter : callee.getParameters()) {
                if (!(parameter.getType() instanceof BundleType)) continue;
                BundleType calleeBundle = (BundleType)parameter.getType();
                validatorMap.putAll(calleeBundle.getAttrMap());
            }
            ImmutableSet<String> allowedAttributes = ImmutableSet.copyOf(validatorMap.keySet());
            for (Map.Entry<String, Attribute> param : call.getAttributes().entrySet()) {
                Expression actualArgument = param.getValue().getValue();
                if (actualArgument instanceof AttrBundleParam) {
                    AttrBundleParam bundle = (AttrBundleParam)actualArgument;
                    for (Map.Entry<AttributeValidator, Attribute> attr : bundle.getAttrs().entrySet()) {
                        validatorMap.remove(attr.getKey().getName());
                        if (attr.getValue().getCondition() == null || !attr.getKey().isFlagSet(AttributeValidator.Flag.REQUIRED)) continue;
                        this.alertSink.add(new RequiredAttributeHasCondError(call, attr.getValue()));
                    }
                }
                newAttrBuilder.put(param.getKey(), this.visitAttribute(param.getValue()));
            }
            this.validateAttributeBundles(call, call.getAttrBundles(), validatorMap, allowedAttributes);
            ImmutableMap<String, Attribute> newAttrParams = newAttrBuilder.build();
            for (FormalParameter parameter : callee.getParameters()) {
                if (parameter.hasDefault()) continue;
                if (!newAttrParams.containsKey(parameter.getPrimaryName())) {
                    this.alertSink.add(new MissingAttributeError(call, parameter.getPrimaryName()));
                    continue;
                }
                Attribute fpAttribute = call.getAttributes().get(parameter.getPrimaryName());
                if (fpAttribute == null || fpAttribute.getCondition() == null) continue;
                this.alertSink.add(new RequiredAttributeHasCondError(call, fpAttribute));
            }
            return new ValidatedCall(call, callee, newAttrParams);
        }

        @Override
        public Expression visitObjectConstant(ObjectConstant value) {
            if (value.getType() == null) {
                throw new UnexpectedNodeException(value);
            }
            return value;
        }

        @Override
        public Void visitUnboundImplementsDeclaration(UnboundImplementsDeclaration uid) {
            throw new UnexpectedNodeException(uid);
        }

        @Override
        public Void visitBoundImplementsDeclaration(BoundImplementsDeclaration bid) {
            if (!this.template.getSchema().equals((Object)bid.getImplementable().getSchema())) {
                this.alertSink.add(new SchemaMismatchError(bid, this.template.getName().toString()));
            }
            Implementable implementable = bid.getImplementable();
            if (this.template.getParameters().size() != implementable.getParameters().size() - 1) {
                this.alertSink.add(new NumParamsMismatchError(bid, implementable.getParameters().size() - 1, this.template.getParameters().size()));
            } else {
                Iterator<FormalParameter> interfaceParams = implementable.getParameters().iterator();
                Iterator<Parameter> templateParams = this.template.getParameters().iterator();
                while (interfaceParams.hasNext()) {
                    FormalParameter interfaceParam = interfaceParams.next();
                    if ("this".equals(interfaceParam.getPrimaryName())) continue;
                    Parameter templateParam = templateParams.next();
                    if (!interfaceParam.getPrimaryName().equals(templateParam.getPrimaryName())) {
                        this.alertSink.add(new ParamNameMismatchError(bid, interfaceParam, templateParam));
                        continue;
                    }
                    if (!interfaceParam.getType().matches(templateParam.getType())) {
                        this.alertSink.add(new ParamTypeMismatchError(bid, interfaceParam, templateParam));
                        continue;
                    }
                    if (interfaceParam.hasDefault() && templateParam.getDefaultValue() == null) {
                        this.alertSink.add(new ParamDefaultMismatchError(templateParam));
                    }
                    if (!interfaceParam.hasConstructor() || templateParam.getConstructor() != null) continue;
                    this.alertSink.add(new ParamConstructorMismatchError(templateParam));
                }
            }
            return null;
        }

        @Override
        public Void visitNativeImplementsDeclaration(NativeImplementsDeclaration nid) {
            return null;
        }
    }
}

