/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.transconsole.common.messages.InvalidMessageException;
import com.google.transconsole.common.messages.MessageFragment;
import com.google.transconsole.common.messages.Placeholder;
import com.google.transconsole.common.messages.TextFragment;
import com.google.transconsole.common.messages.Translation;
import java.util.ArrayList;
import java.util.List;

public class TranslationBuilder {
    private String id;
    private String language;
    private List<MessageFragment> fragments = new ArrayList<MessageFragment>();

    public TranslationBuilder appendText(String text) {
        this.fragments.add(new TextFragment(text));
        return this;
    }

    public TranslationBuilder appendFragment(MessageFragment fragment) {
        this.fragments.add(fragment);
        return this;
    }

    public TranslationBuilder appendPlaceholder(String presentation) throws InvalidMessageException {
        if (presentation == null || presentation.length() == 0) {
            throw new InvalidMessageException("Invalid placeholder specification: presentation required");
        }
        if (!presentation.matches("^[A-Z0-9_]+$")) {
            throw new InvalidMessageException("Invalid placeholder specification: only caps, digits, and underscores allowed in presentation");
        }
        Placeholder p = new Placeholder(presentation);
        this.fragments.add(p);
        return this;
    }

    public TranslationBuilder setId(String id) {
        this.id = id;
        return this;
    }

    public TranslationBuilder setLanguage(String language) {
        this.language = language;
        return this;
    }

    public Translation createTranslation() throws InvalidMessageException {
        if (this.id == null) {
            throw new InvalidMessageException("Translation must have an id");
        }
        Translation t = new Translation(this.id, this.language, this.fragments);
        return t;
    }
}

