/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.java;

import com.google.gxp.com.google.common.base.Functions;
import com.google.gxp.com.google.common.base.Join;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.PrimitiveArrays;
import com.google.gxp.compiler.alerts.AlertPolicy;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.OutputLanguage;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.ThrowsDeclaration;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.io.RuntimeIOException;
import com.google.gxp.compiler.java.BaseJavaCodeGenerator;
import com.google.gxp.compiler.java.DynamicImplJavaCodeGenerator;
import com.google.gxp.compiler.msgextract.MessageExtractedTree;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class DynamicStubJavaCodeGenerator
extends BaseJavaCodeGenerator<MessageExtractedTree> {
    private final Collection<FileRef> sourceFiles;
    private final Collection<FileRef> schemaFiles;
    private final Collection<FileRef> sourcePaths;
    private final AlertPolicy alertPolicy;
    private static final Map<String, String> PRIMITIVE_TO_BOXED_MAP = ImmutableMap.builder().put("boolean", "Boolean").put("byte", "Byte").put("char", "Character").put("double", "Double").put("float", "Float").put("int", "Integer").put("long", "Long").put("short", "Short").build();

    public DynamicStubJavaCodeGenerator(MessageExtractedTree tree, Collection<FileRef> sourceFiles, Collection<FileRef> schemaFiles, Collection<FileRef> sourcePaths, AlertPolicy alertPolicy) {
        super(tree, null);
        this.sourceFiles = Preconditions.checkNotNull(sourceFiles);
        this.schemaFiles = Preconditions.checkNotNull(schemaFiles);
        this.sourcePaths = Preconditions.checkNotNull(sourcePaths);
        this.alertPolicy = Preconditions.checkNotNull(alertPolicy);
    }

    @Override
    protected TemplateWorker createTemplateWorker(Appendable appendable, AlertSink alertSink, Template template, String runtimeMessageSource) {
        return new TemplateWorker(appendable, alertSink, template, this.sourceFiles, this.schemaFiles, this.sourcePaths, this.alertPolicy);
    }

    private static String toReferenceType(String type) {
        String result = PRIMITIVE_TO_BOXED_MAP.get(type);
        return result == null ? type : result;
    }

    protected static class InnerClassTemplateWorker
    extends DynamicImplJavaCodeGenerator.TemplateWorker {
        protected InnerClassTemplateWorker(Appendable appendable, AlertSink alertSink, Template template) {
            super(appendable, alertSink, template, 0L);
            this.out.addIndent();
        }

        @Override
        protected void appendClassDecl() {
            this.formatLine(this.template.getSourcePosition(), "public static class %s extends %s {", this.getClassName(this.template.getName()), this.getBaseClassName());
        }
    }

    private static class TemplateWorker
    extends BaseJavaCodeGenerator.TemplateWorker {
        private final Collection<FileRef> sourceFiles;
        private final Collection<FileRef> schemaFiles;
        private final Collection<FileRef> sourcePaths;
        private final InnerClassTemplateWorker innerWorker;
        private final AlertPolicy alertPolicy;
        private static final String GXP_COMPILATION_EXCEPTION = "com.google.gxp.base.dynamic.GxpCompilationException";
        private static final String TEMP_OUT_VAR = "temp$out";

        TemplateWorker(Appendable appendable, AlertSink alertSink, Template template, Collection<FileRef> sourceFiles, Collection<FileRef> schemaFiles, Collection<FileRef> sourcePaths, AlertPolicy alertPolicy) {
            super(appendable, alertSink, template);
            this.sourceFiles = sourceFiles;
            this.schemaFiles = schemaFiles;
            this.sourcePaths = sourcePaths;
            this.innerWorker = new InnerClassTemplateWorker(appendable, alertSink, template);
            this.alertPolicy = alertPolicy;
        }

        @Override
        protected SourcePosition getDefaultSourcePosition() {
            return this.template.getSourcePosition();
        }

        @Override
        protected String getBaseClassName() {
            return "com.google.gxp.base.dynamic.StubGxpTemplate";
        }

        @Override
        protected void appendClass() {
            TemplateName.FullyQualified templateName = this.template.getName();
            this.appendAnnotations(this.template.getJavaAnnotations(JavaAnnotation.Element.CLASS));
            this.formatLine(this.template.getSourcePosition(), "public class %s extends %s {", this.getClassName(templateName), this.getBaseClassName());
            this.appendStaticContent();
            this.appendWriteMethod();
            this.appendLine();
            this.appendWriteImplMethod();
            this.appendDefaultAccessors();
            this.appendParamConstructors();
            this.appendGetArgListMethod();
            this.appendGetGxpClosureMethod(true);
            this.appendInterface();
            this.appendInstance();
            this.appendLine();
            this.innerWorker.appendClass();
            this.appendLine("}");
        }

        private String serializeAlertPolicy() {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.alertPolicy);
                oos.close();
                baos.close();
                return Join.join(",", Iterables.transform(PrimitiveArrays.asList(baos.toByteArray()), Functions.toStringFunction()));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        private void appendStaticContent() {
            this.formatLine("private static long COMPILATION$CHECKSUM = %dL;", this.template.getSourcePosition().getSource().getChecksum());
            this.formatLine("private static long COMPILATION$VERSION = 0;", new Object[0]);
            this.appendLine("private static final com.google.gxp.compiler.alerts.AlertPolicy ALERT$POLICY =");
            this.formatLine("  createAlertPolicy(new byte[] {%s});", this.serializeAlertPolicy());
            this.appendLine("private static final com.google.gxp.compiler.fs.FileRef SRC$GXP = ");
            this.formatLine("  parseFilename(%s);", OutputLanguage.JAVA.toStringLiteral(this.template.getSourcePosition().getSourceName()));
            String classBase = OutputLanguage.JAVA.toStringLiteral(this.template.getName().toString() + "$Impl");
            String javaBase = OutputLanguage.JAVA.toStringLiteral("/" + this.template.getName().toString().replace('.', '/') + "$Impl");
            this.appendLine("private static final String JAVA$BASE =");
            this.formatLine("  %s;", javaBase);
            this.appendLine("private static final String CLASS$BASE =");
            this.formatLine("  %s;", classBase);
            this.appendStaticFileRefList("SRC$GXPS", this.sourceFiles);
            this.appendStaticFileRefList("SRC$SCHEMAS", this.schemaFiles);
            this.appendStaticFileRefList("SRC$PATHS", this.sourcePaths);
            this.appendLine();
            this.appendLine("private static com.google.gxp.compiler.fs.FileRef JAVA$FILE = null;");
            this.appendLine();
            this.appendLine("private static java.util.Map<String, java.lang.reflect.Method> METHODS$ =");
            this.formatLine("  getMethodMap(%s.class);", this.innerWorker.getClassName(this.template.getName()));
            this.appendLine();
        }

        private void appendStaticFileRefList(String varName, Iterable<FileRef> files) {
            this.appendLine();
            this.formatLine((SourcePosition)null, "private static final java.util.List<com.google.gxp.compiler.fs.FileRef> %s =", varName);
            this.appendLine(null, "  parseFilenameList(");
            ArrayList<String> parseFiles = Lists.newArrayList();
            for (FileRef file : files) {
                parseFiles.add("    " + OutputLanguage.JAVA.toStringLiteral(file.toFilename()));
            }
            this.appendLine(null, Join.join(",\n", parseFiles));
            this.appendLine(null, "  );");
        }

        private void appendReload() {
            this.appendLine("long LAST$CHECKSUM = SRC$GXP.getChecksum();");
            this.appendLine("if ((LAST$CHECKSUM != 0 && LAST$CHECKSUM != COMPILATION$CHECKSUM)");
            this.appendLine("    || METHODS$ == null) {");
            this.appendLine("COMPILATION$VERSION++;");
            this.appendLine("com.google.gxp.compiler.fs.InMemoryFileSystem MEM$FS =");
            this.appendLine("    new com.google.gxp.compiler.fs.InMemoryFileSystem();");
            this.appendLine("JAVA$FILE = compileGxp(MEM$FS, SRC$GXPS, SRC$SCHEMAS, SRC$PATHS,");
            this.appendLine("                       JAVA$BASE, COMPILATION$VERSION, ALERT$POLICY);");
            this.appendLine("METHODS$ = compileJava(MEM$FS, CLASS$BASE, COMPILATION$VERSION);");
            this.appendLine("COMPILATION$CHECKSUM = LAST$CHECKSUM;");
            this.appendLine("}");
        }

        private void appendDefaultAccessors() {
            for (Parameter param : this.template.getAllParameters()) {
                Expression defaultValue = param.getDefaultValue();
                if (defaultValue == null) continue;
                String methodName = DynamicStubJavaCodeGenerator.getDefaultMethodName(param);
                String paramType = this.toJavaType(param.getType());
                this.appendLine();
                this.formatLine("public static %s %s() {", paramType, methodName);
                this.appendReload();
                this.formatLine("return %s.<%s>execNoExceptions(METHODS$, \"%s\", new Object[] {});", this.getBaseClassName(), DynamicStubJavaCodeGenerator.toReferenceType(paramType), methodName);
                this.appendLine("}");
            }
        }

        private void appendParamConstructors() {
            for (Parameter param : this.template.getAllParameters()) {
                if (param.getConstructor() == null) continue;
                String methodName = DynamicStubJavaCodeGenerator.getConstructorMethodName(param);
                String paramType = this.toJavaType(param.getType());
                String paramName = param.getPrimaryName();
                this.appendLine();
                this.formatLine("public static %s %s(String %s) {", paramType, methodName, paramName);
                this.appendReload();
                this.formatLine("return %s.<%s>execNoExceptions(METHODS$, \"%s\", new Object[] { %s });", this.getBaseClassName(), DynamicStubJavaCodeGenerator.toReferenceType(paramType), methodName, paramName);
                this.appendLine("}");
            }
        }

        @Override
        protected void appendWriteMethodBody() {
            StringBuilder sb = new StringBuilder();
            sb.append("writeImpl(%s, gxp_context");
            for (Parameter param : this.template.getAllParameters()) {
                sb.append(", ");
                sb.append(param.getPrimaryName());
            }
            sb.append(");");
            String writeLine = sb.toString();
            this.appendLine("if (gxp_context.isTopLevelCall()) {");
            this.appendLine("try {");
            this.formatLine("java.io.StringWriter %s = new java.io.StringWriter();", TEMP_OUT_VAR);
            this.formatLine(writeLine, TEMP_OUT_VAR);
            this.formatLine("%s.append(%s.toString());", "gxp$out", TEMP_OUT_VAR);
            this.formatLine("} catch (%s gxp$e) {", GXP_COMPILATION_EXCEPTION);
            this.formatLine("gxp$e.write(%s, gxp_context);", "gxp$out");
            this.appendLine("}");
            this.appendLine("} else {");
            this.formatLine(writeLine, "gxp$out");
            this.appendLine("}");
        }

        protected void appendWriteImplMethod() {
            ArrayList<String> throwsTypes = Lists.newArrayList();
            for (ThrowsDeclaration throwsDeclaration : this.template.getThrowsDeclarations()) {
                throwsTypes.add(throwsDeclaration.getExceptionType());
            }
            throwsTypes.add("java.io.IOException");
            throwsTypes.add("java.lang.RuntimeException");
            this.appendLine(this.getWriteMethodSignature(BaseJavaCodeGenerator.TemplateWorker.Access._private, true, "writeImpl") + " {");
            this.appendReload();
            this.appendLine("try {");
            StringBuilder sb = new StringBuilder("exec(METHODS$, \"write\", ");
            sb.append("new Object[] {");
            sb.append("gxp$out");
            sb.append(", gxp_context");
            for (Parameter param : this.template.getAllParameters()) {
                sb.append(", ");
                sb.append(param.getPrimaryName());
            }
            sb.append("});");
            this.appendLine(sb);
            this.appendLine("} catch (Throwable gxp$t) {");
            this.appendLine("rewriteStackTraceElements(gxp$t, JAVA$FILE);");
            for (String throwType : throwsTypes) {
                this.formatLine("if (gxp$t instanceof %s) {", throwType);
                this.formatLine("throw (%s)gxp$t;", throwType);
                this.appendLine("}");
            }
            this.formatLine("throw new %s.Throw(gxp$t);", GXP_COMPILATION_EXCEPTION);
            this.appendLine("}");
            this.appendLine("}");
        }
    }
}

