/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.host;

import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.felix.shell.ShellService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.host.BaseOsgiHost;
import org.apache.struts2.osgi.host.OsgiHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleReference;

public class GlassfishOSGiHost
extends BaseOsgiHost
implements OsgiHost {
    private static final Logger LOG = LogManager.getLogger(GlassfishOSGiHost.class);
    private static final String BUNDLES_DIR = "/WEB-INF/classes/bundles/2/";
    private BundleContext bctx = null;

    @Override
    public void init(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.installManagedBundles();
        this.addSpringOSGiSupport();
        servletContext.setAttribute("__struts_osgi_bundle_context", (Object)this.bctx);
    }

    private void installManagedBundles() {
        try {
            BundleReference ref = (BundleReference)this.servletContext.getClass().getClassLoader();
            this.bctx = ref.getBundle().getBundleContext();
            this.installBundles();
        }
        catch (Exception ex) {
            LOG.error("Installing Managed Bundles met a problem", (Throwable)ex);
        }
    }

    private void installBundles() throws Exception {
        ArrayList<Bundle> installed = new ArrayList<Bundle>();
        for (URL url : this.findBundles()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Installing bundle [{}]", (Object)url);
            }
            Bundle bundle = this.bctx.installBundle(url.toExternalForm());
            installed.add(bundle);
        }
        for (Bundle bundle : installed) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                LOG.error("Failed to start [{}]", (Object)bundle, (Object)e);
            }
        }
    }

    private List<URL> findBundles() throws Exception {
        ArrayList<URL> list = new ArrayList<URL>();
        for (Object o : this.servletContext.getResourcePaths(BUNDLES_DIR)) {
            URL url;
            String name = (String)o;
            if (!name.endsWith(".jar") || (url = this.servletContext.getResource(name)) == null) continue;
            list.add(url);
        }
        ProtectionDomain protectionDomain = ShellService.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL loc = codeSource.getLocation();
        list.add(loc);
        return list;
    }

    @Override
    protected void addSpringOSGiSupport() {
        try {
            Class<?> clazz = Class.forName("org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext");
            String key = (String)clazz.getDeclaredField("BUNDLE_CONTEXT_ATTRIBUTE").get(null);
            this.servletContext.setAttribute(key, (Object)this.bctx);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Spring OSGi support is not enabled");
        }
        catch (Exception e) {
            LOG.error("The API of Spring OSGi has changed and the field [{}] is no longer available. The OSGi plugin needs to be updated", (Object)"org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext.BUNDLE_CONTEXT_ATTRIBUTE", (Object)e);
        }
    }

    @Override
    public Map<String, Bundle> getBundles() {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.bctx.getBundles()) {
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public Map<String, Bundle> getActiveBundles() {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.bctx.getBundles()) {
            if (bundle.getState() != 32) continue;
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.bctx;
    }

    @Override
    public void destroy() throws Exception {
    }
}

