/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import java.io.IOException;
import java.util.Deque;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.Expression;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.autotag.core.runtime.ModelBody;
import org.apache.tiles.request.Request;
import org.apache.tiles.template.ComposeStackUtil;

public class PutAttributeModel {
    public void execute(String name, Object value, String expression, String role, String type, boolean cascade, Request request, ModelBody modelBody) throws IOException {
        Deque<Object> composeStack = ComposeStackUtil.getComposeStack(request);
        Attribute attribute = new Attribute();
        composeStack.push(attribute);
        String currentBody = modelBody.evaluateAsString();
        TilesContainer container = TilesAccess.getCurrentContainer((Request)request);
        attribute = (Attribute)composeStack.pop();
        this.putAttributeInParent(attribute, container, composeStack, name, value, expression, currentBody, role, type, cascade, request);
    }

    private void putAttributeInParent(Attribute attribute, TilesContainer container, Deque<Object> composeStack, String name, Object value, String expression, String body, String role, String type, boolean cascade, Request request) {
        Object obj;
        AttributeContext attributeContext = null;
        if (!composeStack.isEmpty() && (obj = composeStack.peek()) instanceof AttributeContext) {
            attributeContext = (AttributeContext)obj;
        }
        if (attributeContext == null) {
            attributeContext = container.getAttributeContext(request);
        }
        if (value != null) {
            attribute.setValue(value);
        } else if (attribute.getValue() == null && body != null) {
            attribute.setValue((Object)body);
        }
        if (expression != null) {
            attribute.setExpressionObject(Expression.createExpressionFromDescribedExpression((String)expression));
        }
        if (role != null) {
            attribute.setRole(role);
        }
        if (type != null) {
            attribute.setRenderer(type);
        }
        attributeContext.putAttribute(name, attribute, cascade);
    }
}

