/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.PackageProvider;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.BundleAccessor;
import org.apache.struts2.osgi.BundleClassLoaderInterface;
import org.apache.struts2.osgi.BundlePackageLoader;
import org.apache.struts2.osgi.DefaultBundleAccessor;
import org.apache.struts2.osgi.host.OsgiHost;
import org.apache.struts2.osgi.loaders.VelocityBundleResourceLoader;
import org.apache.struts2.views.velocity.VelocityManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class OsgiConfigurationProvider
implements PackageProvider,
BundleListener {
    private static final Logger LOG = LogManager.getLogger(OsgiConfigurationProvider.class);
    private Configuration configuration;
    private ObjectFactory objectFactory;
    private FileManagerFactory fileManagerFactory;
    private OsgiHost osgiHost;
    private BundleContext bundleContext;
    private BundleAccessor bundleAccessor;
    private boolean bundlesChanged = false;
    private ServletContext servletContext;

    public void init(Configuration configuration) throws ConfigurationException {
        if (this.servletContext == null) {
            throw new IllegalStateException("ServletContext is null (may not have been injected).  Unable to initialize");
        }
        this.osgiHost = (OsgiHost)this.servletContext.getAttribute("__struts_osgi_host");
        if (this.osgiHost == null) {
            throw new IllegalStateException("Cannot locate Struts OsgiHost in servlet context (null).  Unable to initialize");
        }
        if (this.bundleAccessor == null) {
            throw new IllegalStateException("BundleAccessor is null (may not have been injected).  Unable to initialize");
        }
        this.bundleContext = this.osgiHost.getBundleContext();
        this.bundleAccessor.setBundleContext(this.bundleContext);
        this.bundleAccessor.setOsgiHost(this.osgiHost);
        this.configuration = configuration;
        if (this.bundleContext == null) {
            LOG.warn("Struts BundleContext is null at initialization, check OsgiHost configuration");
        }
        if (configuration == null) {
            LOG.warn("Struts OSGi configuration is null at initialization, check OsgiHost configuration");
        }
        if (this.bundleAccessor instanceof DefaultBundleAccessor) {
            LOG.debug("Struts OSGi Bundle Accessor is a DefaultBundleAccessor or descendant");
        } else {
            LOG.debug("Struts OSGi Bundle Accessor is a non-standard BundleAccessor");
        }
        this.servletContext.setAttribute("__current_class_loader_interface", (Object)new BundleClassLoaderInterface());
    }

    public synchronized void loadPackages() throws ConfigurationException {
        LOG.trace("Loading packages from XML and Convention on startup");
        if (this.osgiHost == null) {
            throw new IllegalStateException("Cannot load packages, Struts OsgiHost is null");
        }
        if (this.bundleContext == null) {
            throw new IllegalStateException("Cannot load packages, Struts BundleContext is null");
        }
        ActionContext ctx = ActionContext.getContext();
        if (ctx == null) {
            ctx = this.createActionContext();
            ActionContext.setContext((ActionContext)ctx);
        }
        HashSet<String> bundleNames = new HashSet<String>();
        for (Bundle bundle : this.osgiHost.getBundles().values()) {
            String bundleName = bundle.getSymbolicName();
            if (!this.shouldProcessBundle(bundle) || bundleNames.contains(bundleName)) continue;
            bundleNames.add(bundleName);
            this.loadConfigFromBundle(bundle);
        }
        this.bundlesChanged = false;
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    protected ActionContext createActionContext() {
        return new ActionContext(new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfigFromBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Cannot load configuration from a null bundle");
        }
        if (this.configuration == null) {
            throw new IllegalStateException("Struts OSGi configuration is null.  Cannot load bundle configuration");
        }
        if (this.bundleAccessor == null) {
            LOG.warn("BundleAccessor is null (may not have been injected).  May cause NPE to be thrown");
        }
        if (this.fileManagerFactory == null) {
            LOG.warn("FileManagerFactory is null, FileManagerFactory may not have been set.  May cause NPE to be thrown");
        }
        String bundleName = bundle.getSymbolicName();
        LOG.debug("Loading packages from bundle [{}]", (Object)bundleName);
        ActionContext ctx = ActionContext.getContext();
        if (ctx == null) {
            ctx = this.createActionContext();
            ActionContext.setContext((ActionContext)ctx);
        }
        try {
            ctx.put("__current_class_loader_interface", (Object)new BundleClassLoaderInterface());
            ctx.put("__bundle_name__", (Object)bundleName);
            LOG.trace("Loading XML config from bundle [{}]", (Object)bundleName);
            BundlePackageLoader loader = new BundlePackageLoader();
            for (PackageConfig pkg : loader.loadPackages(bundle, this.bundleContext, this.objectFactory, this.fileManagerFactory, this.configuration.getPackageConfigs())) {
                this.configuration.addPackageConfig(pkg.getName(), pkg);
                this.bundleAccessor.addPackageFromBundle(bundle, pkg.getName());
            }
            HashSet packagesBeforeLoading = new HashSet(this.configuration.getPackageConfigNames());
            PackageProvider conventionPackageProvider = (PackageProvider)this.configuration.getContainer().getInstance(PackageProvider.class, "convention.packageProvider");
            if (conventionPackageProvider != null) {
                LOG.trace("Loading Convention config from bundle [{}]", (Object)bundleName);
                conventionPackageProvider.loadPackages();
            }
            HashSet packagesAfterLoading = new HashSet(this.configuration.getPackageConfigNames());
            packagesAfterLoading.removeAll(packagesBeforeLoading);
            if (!packagesAfterLoading.isEmpty()) {
                for (String packageName : packagesAfterLoading) {
                    this.bundleAccessor.addPackageFromBundle(bundle, packageName);
                }
            }
            if (this.configuration.getRuntimeConfiguration() != null) {
                this.configuration.rebuildRuntimeConfiguration();
            }
        }
        finally {
            ctx.put("__bundle_name__", null);
            ctx.put("__current_class_loader_interface", null);
        }
    }

    protected boolean shouldProcessBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Cannot check if Struts OSGi Plugin should process a null bundle");
        }
        String strutsEnabled = (String)bundle.getHeaders().get("Struts2-Enabled");
        return "true".equalsIgnoreCase(strutsEnabled);
    }

    public synchronized boolean needsReload() {
        return this.bundlesChanged;
    }

    @Inject
    public void setObjectFactory(ObjectFactory factory) {
        LOG.trace("OSGi ConfigurationProvider - setObjectFactory() called - ObjectFactory: [{}]", (Object)factory);
        this.objectFactory = factory;
    }

    @Inject
    public void setBundleAccessor(BundleAccessor acc) {
        LOG.trace("OSGi ConfigurationProvider - setBundleAccessor() called - BundleAccessor: [{}]", (Object)acc);
        this.bundleAccessor = acc;
    }

    @Inject
    public void setVelocityManager(VelocityManager vm) {
        LOG.trace("OSGi ConfigurationProvider - setVelocityManager() called - VelocityManager: [{}]", (Object)vm);
        Properties props = new Properties();
        props.setProperty("osgi.resource.loader.description", "OSGI bundle loader");
        props.setProperty("osgi.resource.loader.class", VelocityBundleResourceLoader.class.getName());
        props.setProperty("resource.loader", "strutsfile,strutsclass,osgi");
        vm.setVelocityProperties(props);
    }

    @Inject
    public void setServletContext(ServletContext servletContext) {
        LOG.trace("OSGi ConfigurationProvider - setServletContext() called - ServletContext: [{}]", (Object)servletContext);
        this.servletContext = servletContext;
    }

    @Inject
    public void setFileManagerFactory(FileManagerFactory fmFactory) {
        LOG.trace("OSGi ConfigurationProvider - setFileManagerFactory() called - FileManagerFactory: [{}]", (Object)fmFactory);
        this.fileManagerFactory = fmFactory;
    }

    public void destroy() {
        block2: {
            try {
                this.osgiHost.destroy();
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block2;
                LOG.error("Failed to stop OSGi container", (Throwable)e);
            }
        }
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent == null) {
            throw new IllegalArgumentException("Cannot check if bundle changed for a null BundleEvent");
        }
        Bundle bundle = bundleEvent.getBundle();
        if (bundle == null) {
            throw new IllegalArgumentException("Cannot check if bundle changed for a null Bundle within the BundleEvent");
        }
        String bundleName = bundle.getSymbolicName();
        if (bundleName != null && this.shouldProcessBundle(bundle)) {
            switch (bundleEvent.getType()) {
                case 2: {
                    LOG.trace("The bundle [{}] has been activated and will be scanned for struts configuration", (Object)bundleName);
                    this.loadConfigFromBundle(bundle);
                    break;
                }
                case 4: {
                    this.onBundleStopped(bundle);
                }
            }
        }
    }

    protected void onBundleStopped(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Cannot process bundle stopped event on a null Bundle");
        }
        if (this.bundleAccessor == null) {
            throw new IllegalStateException("BundleAccessor is null.  Cannot process bundle stopped event");
        }
        Set<String> packages = this.bundleAccessor.getPackagesByBundle(bundle);
        if (!packages.isEmpty()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("The bundle [{}] has been stopped. The packages [{}] will be disabled", (Object)bundle.getSymbolicName(), (Object)StringUtils.join(packages, (String)","));
            }
            for (String packageName : packages) {
                this.configuration.removePackageConfig(packageName);
            }
        }
    }
}

