/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.result;

import com.opensymphony.xwork2.ActionInvocation;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.result.StrutsResultSupport;

public class StreamResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -1468409635999059850L;
    protected static final Logger LOG = LogManager.getLogger(StreamResult.class);
    public static final String DEFAULT_PARAM = "inputName";
    protected String contentType = "text/plain";
    protected String contentLength;
    protected String contentDisposition = "inline";
    protected String contentCharSet;
    protected String inputName = "inputStream";
    protected InputStream inputStream;
    protected int bufferSize = 1024;
    protected boolean allowCaching = true;

    public StreamResult() {
    }

    public StreamResult(InputStream in) {
        this.inputStream = in;
    }

    public boolean getAllowCaching() {
        return this.allowCaching;
    }

    public void setAllowCaching(boolean allowCaching) {
        this.allowCaching = allowCaching;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(String contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public String getContentCharSet() {
        return this.contentCharSet;
    }

    public void setContentCharSet(String contentCharSet) {
        this.contentCharSet = contentCharSet;
    }

    public String getInputName() {
        return this.inputName;
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        LOG.debug("Find the Response in context");
        OutputStream oOutput = null;
        try {
            int iSize;
            if (this.inputStream == null) {
                LOG.debug("Find the inputstream from the invocation variable stack");
                this.inputStream = (InputStream)invocation.getStack().findValue(this.conditionalParse(this.inputName, invocation));
            }
            if (this.inputStream == null) {
                String msg = "Can not find a java.io.InputStream with the name [" + this.inputName + "] in the invocation stack. " + "Check the <param name=\"inputName\"> tag specified for this action.";
                LOG.error(msg);
                throw new IllegalArgumentException(msg);
            }
            HttpServletResponse oResponse = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
            LOG.debug("Set the content type: {};charset{}", (Object)this.contentType, (Object)this.contentCharSet);
            if (this.contentCharSet != null && !this.contentCharSet.equals("")) {
                oResponse.setContentType(this.conditionalParse(this.contentType, invocation) + ";charset=" + this.conditionalParse(this.contentCharSet, invocation));
            } else {
                oResponse.setContentType(this.conditionalParse(this.contentType, invocation));
            }
            LOG.debug("Set the content length: {}", (Object)this.contentLength);
            if (this.contentLength != null) {
                String _contentLength = this.conditionalParse(this.contentLength, invocation);
                try {
                    int _contentLengthAsInt = Integer.parseInt(_contentLength);
                    if (_contentLengthAsInt >= 0) {
                        oResponse.setContentLength(_contentLengthAsInt);
                    }
                }
                catch (NumberFormatException e) {
                    LOG.warn("failed to recognize {} as a number, contentLength header will not be set", (Object)_contentLength, (Object)e);
                }
            }
            LOG.debug("Set the content-disposition: {}", (Object)this.contentDisposition);
            if (this.contentDisposition != null) {
                oResponse.addHeader("Content-Disposition", this.conditionalParse(this.contentDisposition, invocation));
            }
            LOG.debug("Set the cache control headers if necessary: {}", (Object)this.allowCaching);
            if (!this.allowCaching) {
                oResponse.addHeader("Pragma", "no-cache");
                oResponse.addHeader("Cache-Control", "no-cache");
            }
            oOutput = oResponse.getOutputStream();
            LOG.debug("Streaming result [{}] type=[{}] length=[{}] content-disposition=[{}] charset=[{}]", (Object)this.inputName, (Object)this.contentType, (Object)this.contentLength, (Object)this.contentDisposition, (Object)this.contentCharSet);
            LOG.debug("Streaming to output buffer +++ START +++");
            byte[] oBuff = new byte[this.bufferSize];
            while (-1 != (iSize = this.inputStream.read(oBuff))) {
                LOG.debug("Sending stream ... {}", (Object)iSize);
                oOutput.write(oBuff, 0, iSize);
            }
            LOG.debug("Streaming to output buffer +++ END +++");
            oOutput.flush();
        }
        finally {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (oOutput != null) {
                oOutput.close();
            }
        }
    }
}

