/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.loaders.FreeMarkerBundleResourceLoader;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.freemarker.StrutsClassTemplateLoader;

public class BundleFreemarkerManager
extends FreemarkerManager {
    private static final Logger LOG = LogManager.getLogger(BundleFreemarkerManager.class);

    protected TemplateLoader createTemplateLoader(ServletContext servletContext, String templatePath) {
        ClassTemplateLoader templatePathLoader = null;
        if (servletContext == null) {
            throw new IllegalArgumentException("Unable to create a template loader using a null servlet context");
        }
        try {
            if (templatePath != null && templatePath.startsWith("class://")) {
                templatePathLoader = new ClassTemplateLoader(((Object)((Object)this)).getClass(), templatePath.substring(7));
            } else if (templatePath != null && templatePath.startsWith("file://")) {
                templatePathLoader = new FileTemplateLoader(new File(URI.create(templatePath)));
            } else {
                LOG.warn("The provided template path specified: [{}] does not start with expected path protocol (class: or file:).  The template loader will only look in standard locations", (Object)templatePath);
            }
        }
        catch (IOException e) {
            LOG.error("Invalid template path specified: [{}]", (Object)e.getMessage(), (Object)e);
        }
        return templatePathLoader != null ? new MultiTemplateLoader(new TemplateLoader[]{templatePathLoader, new WebappTemplateLoader(servletContext), new StrutsClassTemplateLoader(), new FreeMarkerBundleResourceLoader()}) : new MultiTemplateLoader(new TemplateLoader[]{new WebappTemplateLoader(servletContext), new StrutsClassTemplateLoader(), new FreeMarkerBundleResourceLoader()});
    }
}

