/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.validation.Constraint;
import javax.validation.Valid;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.FutureOrPresent;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Negative;
import javax.validation.constraints.NegativeOrZero;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.PastOrPresent;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import javax.validation.constraints.PositiveOrZero;
import javax.validation.constraints.Size;
import net.sf.oval.Check;
import net.sf.oval.Validator;
import net.sf.oval.collection.CollectionFactory;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.constraint.AssertFalseCheck;
import net.sf.oval.constraint.AssertNullCheck;
import net.sf.oval.constraint.AssertTrueCheck;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.DateRangeCheck;
import net.sf.oval.constraint.DigitsCheck;
import net.sf.oval.constraint.FutureCheck;
import net.sf.oval.constraint.MatchPatternCheck;
import net.sf.oval.constraint.MaxCheck;
import net.sf.oval.constraint.MinCheck;
import net.sf.oval.constraint.NotBlankCheck;
import net.sf.oval.constraint.NotEmptyCheck;
import net.sf.oval.constraint.NotNegativeCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.constraint.PastCheck;
import net.sf.oval.constraint.SizeCheck;
import net.sf.oval.guard.Guarded;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationAnnotationsConfigurer
implements Configurer {
    private static final Log LOG = Log.getLog(BeanValidationAnnotationsConfigurer.class);
    private static final ConstraintMapper CONSTRAINT_MAPPER;

    static {
        JSR303Mapper constraintMapper = null;
        try {
            constraintMapper = new JSR380Mapper();
        }
        catch (LinkageError linkageError) {
            constraintMapper = new JSR303Mapper();
        }
        CONSTRAINT_MAPPER = constraintMapper;
    }

    private List<ParameterConfiguration> _createParameterConfiguration(Annotation[][] paramAnnotations, Class<?>[] parameterTypes) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<ParameterConfiguration> paramCfg = cf.createList(paramAnnotations.length);
        List<Check> paramChecks = cf.createList(2);
        int i = 0;
        while (i < paramAnnotations.length) {
            Annotation[] annotationArray = paramAnnotations[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                this.initializeChecks(annotation, paramChecks);
                ++n2;
            }
            ParameterConfiguration pc = new ParameterConfiguration();
            paramCfg.add(pc);
            pc.type = parameterTypes[i];
            if (paramChecks.size() > 0) {
                pc.checks = paramChecks;
                paramChecks = cf.createList(2);
            }
            ++i;
        }
        return paramCfg;
    }

    protected void configureConstructorParameterChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        Constructor<?>[] constructorArray = classCfg.type.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            List<ParameterConfiguration> paramCfg = this._createParameterConfiguration(ctor.getParameterAnnotations(), ctor.getParameterTypes());
            if (paramCfg.size() > 0) {
                if (classCfg.constructorConfigurations == null) {
                    classCfg.constructorConfigurations = cf.createSet(2);
                }
                ConstructorConfiguration cc = new ConstructorConfiguration();
                cc.parameterConfigurations = paramCfg;
                cc.postCheckInvariants = false;
                classCfg.constructorConfigurations.add(cc);
            }
            ++n2;
        }
    }

    protected void configureFieldChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> checks = cf.createList(2);
        Field[] fieldArray = classCfg.type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Annotation[] annotationArray = field.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                this.initializeChecks(annotation, checks);
                ++n4;
            }
            if (checks.size() > 0) {
                if (classCfg.fieldConfigurations == null) {
                    classCfg.fieldConfigurations = cf.createSet(2);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                classCfg.fieldConfigurations.add(fc);
                checks = cf.createList(2);
            }
            ++n2;
        }
    }

    protected void configureMethodChecks(ClassConfiguration classCfg) {
        CollectionFactory cf = Validator.getCollectionFactory();
        List<Check> returnValueChecks = cf.createList(2);
        Method[] methodArray = classCfg.type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Annotation[] annotationArray = ReflectionUtils.getAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces));
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                this.initializeChecks(annotation, returnValueChecks);
                ++n4;
            }
            List<ParameterConfiguration> paramCfg = this._createParameterConfiguration(ReflectionUtils.getParameterAnnotations(method, Boolean.TRUE.equals(classCfg.inspectInterfaces)), method.getParameterTypes());
            if (paramCfg.size() > 0 || returnValueChecks.size() > 0) {
                if (classCfg.methodConfigurations == null) {
                    classCfg.methodConfigurations = cf.createSet(2);
                }
                MethodConfiguration mc = new MethodConfiguration();
                mc.name = method.getName();
                mc.parameterConfigurations = paramCfg;
                mc.isInvariant = ReflectionUtils.isGetter(method);
                if (returnValueChecks.size() > 0) {
                    mc.returnValueConfiguration = new MethodReturnValueConfiguration();
                    mc.returnValueConfiguration.checks = returnValueChecks;
                    returnValueChecks = cf.createList(2);
                }
                classCfg.methodConfigurations.add(mc);
            }
            ++n2;
        }
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) {
        ClassConfiguration classCfg = new ClassConfiguration();
        classCfg.type = clazz;
        Guarded guarded = clazz.getAnnotation(Guarded.class);
        if (guarded == null) {
            classCfg.applyFieldConstraintsToConstructors = false;
            classCfg.applyFieldConstraintsToSetters = false;
            classCfg.assertParametersNotNull = false;
            classCfg.checkInvariants = false;
            classCfg.inspectInterfaces = false;
        } else {
            classCfg.applyFieldConstraintsToConstructors = guarded.applyFieldConstraintsToConstructors();
            classCfg.applyFieldConstraintsToSetters = guarded.applyFieldConstraintsToSetters();
            classCfg.assertParametersNotNull = guarded.assertParametersNotNull();
            classCfg.checkInvariants = guarded.checkInvariants();
            classCfg.inspectInterfaces = guarded.inspectInterfaces();
        }
        this.configureFieldChecks(classCfg);
        this.configureConstructorParameterChecks(classCfg);
        this.configureMethodChecks(classCfg);
        return classCfg;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) {
        return null;
    }

    protected void initializeChecks(Annotation annotation, Collection<Check> checks) {
        Annotation[] list;
        assert (annotation != null);
        assert (checks != null);
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        if (annotationClass.getAnnotation(Constraint.class) != null || annotation instanceof Valid) {
            Check check = CONSTRAINT_MAPPER.map(annotation);
            if (check != null) {
                Class[] groups;
                Method getGroups;
                String message;
                Method getMessage = ReflectionUtils.getMethod(annotationClass, "message", new Class[0]);
                if (getMessage != null && (message = (String)ReflectionUtils.invokeMethod(getMessage, annotation, new Object[0])) != null && !message.startsWith("{javax.validation.constraints.")) {
                    check.setMessage(message);
                }
                if ((getGroups = ReflectionUtils.getMethod(annotationClass, "groups", new Class[0])) != null && (groups = (Class[])ReflectionUtils.invokeMethod(getGroups, annotation, new Object[0])) != null && groups.length > 0) {
                    String[] profiles = new String[groups.length];
                    int i = 0;
                    int l = groups.length;
                    while (i < l) {
                        profiles[i] = groups[i].getName();
                        ++i;
                    }
                    check.setProfiles(profiles);
                }
                checks.add(check);
                return;
            }
            LOG.warn("Ignoring unsupported bean validation constraint annotation {1}", annotation);
            return;
        }
        if (annotationClass.getPackage().getName().equals("javax.validation.constraints") && "List".equals(annotationClass.getSimpleName()) && (list = (Annotation[])ReflectionUtils.invokeMethod(ReflectionUtils.getMethod(annotationClass, "value", new Class[0]), annotation, new Object[0])) != null) {
            Annotation[] annotationArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation anno = annotationArray[n2];
                this.initializeChecks(anno, checks);
                ++n2;
            }
        }
    }

    private static interface ConstraintMapper {
        public Check map(Annotation var1);
    }

    private static class JSR303Mapper
    implements ConstraintMapper {
        private JSR303Mapper() {
        }

        public Check map(Annotation annotation) {
            if (annotation instanceof NotNull) {
                return new NotNullCheck();
            }
            if (annotation instanceof Null) {
                return new AssertNullCheck();
            }
            if (annotation instanceof Valid) {
                return new AssertValidCheck();
            }
            if (annotation instanceof AssertTrue) {
                return new AssertTrueCheck();
            }
            if (annotation instanceof AssertFalse) {
                return new AssertFalseCheck();
            }
            if (annotation instanceof DecimalMax) {
                MaxCheck check = new MaxCheck();
                check.setMax(Double.parseDouble(((DecimalMax)annotation).value()));
                Method getInclusive = ReflectionUtils.getMethod(annotation.annotationType(), "inclusive", new Class[0]);
                if (getInclusive != null) {
                    check.setInclusive((Boolean)ReflectionUtils.invokeMethod(getInclusive, annotation, new Object[0]));
                }
                return check;
            }
            if (annotation instanceof DecimalMin) {
                MinCheck check = new MinCheck();
                check.setMin(Double.parseDouble(((DecimalMin)annotation).value()));
                Method getInclusive = ReflectionUtils.getMethod(annotation.annotationType(), "inclusive", new Class[0]);
                if (getInclusive != null) {
                    check.setInclusive((Boolean)ReflectionUtils.invokeMethod(getInclusive, annotation, new Object[0]));
                }
                return check;
            }
            if (annotation instanceof Max) {
                MaxCheck check = new MaxCheck();
                check.setMax(((Max)annotation).value());
                return check;
            }
            if (annotation instanceof Min) {
                MinCheck check = new MinCheck();
                check.setMin(((Min)annotation).value());
                return check;
            }
            if (annotation instanceof Future) {
                return new FutureCheck();
            }
            if (annotation instanceof Past) {
                return new PastCheck();
            }
            if (annotation instanceof Pattern) {
                MatchPatternCheck check = new MatchPatternCheck();
                int iflag = 0;
                Pattern.Flag[] flagArray = ((Pattern)annotation).flags();
                int n = flagArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Pattern.Flag flag = flagArray[n2];
                    iflag |= flag.getValue();
                    ++n2;
                }
                check.setPattern(((Pattern)annotation).regexp(), iflag);
                return check;
            }
            if (annotation instanceof Digits) {
                DigitsCheck check = new DigitsCheck();
                check.setMaxFraction(((Digits)annotation).fraction());
                check.setMaxInteger(((Digits)annotation).integer());
                return check;
            }
            if (annotation instanceof Size) {
                SizeCheck check = new SizeCheck();
                check.setMax(((Size)annotation).max());
                check.setMin(((Size)annotation).min());
                return check;
            }
            return null;
        }

        /* synthetic */ JSR303Mapper(JSR303Mapper jSR303Mapper, JSR303Mapper jSR303Mapper2) {
            this();
        }
    }

    private static class JSR380Mapper
    extends JSR303Mapper {
        private JSR380Mapper() {
            super(null, null);
        }

        public Check map(Annotation annotation) {
            Check jsr303check = super.map(annotation);
            if (jsr303check != null) {
                return jsr303check;
            }
            if (annotation instanceof FutureOrPresent) {
                DateRangeCheck check = new DateRangeCheck();
                check.setMin("now");
                return check;
            }
            if (annotation instanceof Negative) {
                MaxCheck check = new MaxCheck();
                check.setInclusive(false);
                check.setMax(0.0);
                return check;
            }
            if (annotation instanceof NegativeOrZero) {
                MaxCheck check = new MaxCheck();
                check.setInclusive(true);
                check.setMax(0.0);
                return check;
            }
            if (annotation instanceof NotBlank) {
                return new NotBlankCheck();
            }
            if (annotation instanceof NotEmpty) {
                return new NotEmptyCheck();
            }
            if (annotation instanceof PastOrPresent) {
                DateRangeCheck check = new DateRangeCheck();
                check.setMax("now");
                return check;
            }
            if (annotation instanceof Positive) {
                MinCheck check = new MinCheck();
                check.setInclusive(false);
                check.setMin(0.0);
                return check;
            }
            if (annotation instanceof PositiveOrZero) {
                return new NotNegativeCheck();
            }
            return null;
        }
    }
}

