/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.TypeVisitor;
import com.google.gxp.compiler.schema.Schema;

public class ContentType
extends Type {
    private final Schema schema;

    public ContentType(SourcePosition sourcePosition, String displayName, Schema schema) {
        super(sourcePosition, displayName);
        this.schema = Preconditions.checkNotNull(schema);
    }

    public ContentType(Schema schema) {
        this(schema.getSourcePosition(), schema.getDisplayName(), schema);
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public boolean onlyAllowedInParam() {
        return false;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean takesDefaultParam() {
        return true;
    }

    @Override
    public Expression parseObjectConstant(String paramName, ObjectConstant objectConstant, AlertSink alertSink) {
        return new StringConstant(objectConstant, null, objectConstant.getValue());
    }

    @Override
    public <T> T acceptTypeVisitor(TypeVisitor<T> visitor) {
        return visitor.visitContentType(this);
    }

    @Override
    public String toString() {
        return this.schema.getCanonicalContentType();
    }

    @Override
    public boolean matches(Type that) {
        if (that instanceof ContentType) {
            ContentType thatContent = (ContentType)that;
            return Objects.equal(this.getSchema(), thatContent.getSchema());
        }
        return false;
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof ContentType && this.equals((ContentType)that);
    }

    public boolean equals(ContentType that) {
        return this.equalsType(that) && Objects.equal(this.getSchema(), that.getSchema());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.typeHashCode(), this.getSchema());
    }
}

