/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitegraph.model;

import java.io.IOException;
import org.apache.struts2.sitegraph.model.IndentWriter;
import org.apache.struts2.sitegraph.model.Render;
import org.apache.struts2.sitegraph.model.SubGraph;

public abstract class SiteGraphNode
implements Render,
Comparable {
    private String name;
    private SubGraph parent;

    public SiteGraphNode(String name) {
        this.name = name;
    }

    public SubGraph getParent() {
        return this.parent;
    }

    public void setParent(SubGraph parent) {
        this.parent = parent;
    }

    @Override
    public void render(IndentWriter writer) throws IOException {
        writer.write(this.getFullName() + " [label=\"" + this.name + "\",color=\"" + this.getColor() + "\"];");
    }

    public String getFullName() {
        String parentPrefix;
        String prefix = "";
        if (this.parent != null && !(parentPrefix = this.parent.getPrefix()).equals("")) {
            prefix = parentPrefix + "_";
        }
        return prefix + this.cleanName();
    }

    private String cleanName() {
        return this.name.replaceAll("[\\./\\-\\$\\{\\}]", "_");
    }

    public abstract String getColor();

    public int compareTo(Object o) {
        return this.name.compareTo(((SiteGraphNode)o).name);
    }
}

