/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public class Main {
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage:");
            System.out.println("  java -jar struts-toolbox.jar [command] (optional command args)");
            System.out.println("");
            System.out.println("Where [command] is one of the following:");
            System.out.println("  sitegraph");
            System.out.println("  sitegraph:xxx");
            System.out.println("");
            System.out.println("Execute the commands for additional usage instructions.");
            System.out.println("Note: the *:xxx commands are just shortcuts for ");
            System.out.println("      running the command on a webapp in the apps dir.");
            return;
        }
        String javaHome = System.getProperty("java.home");
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            String prop;
            File[] jars;
            Main.findJars(new File("lib"), urls);
            File wd = new File(".");
            for (File jar : jars = wd.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") && !name.contains("-src.");
                }
            })) {
                urls.add(jar.toURL());
            }
            urls.add(new File(System.getProperty("struts.classes", "build/java")).toURL());
            urls.add(new File(System.getProperty("xwork.classes", "../xwork/build/java/")).toURL());
            File tools = new File(javaHome, "lib/tools.jar");
            if (!tools.exists()) {
                tools = new File(javaHome, "../lib/tools.jar");
            }
            if (!tools.exists()) {
                tools = new File(javaHome, "../Classes/classes.jar");
            }
            if (!tools.exists()) {
                tools = new File(javaHome, "../Classes/classes.jar");
            }
            if (!tools.exists() && (prop = System.getProperty("tools")) != null) {
                tools = new File(prop);
            }
            if (!tools.exists()) {
                System.out.println("Error: Could not find tools.jar! Please do one of the following: ");
                System.out.println("");
                System.out.println("        - Use the JDK's JVM (ie: c:\\jdk1.5.0\\bin\\java)");
                System.out.println("        - Specify JAVA_HOME to point to your JDK 1.5 home");
                System.out.println("        - Specify a direct path to tools.jar via, as shown below:");
                System.out.println("");
                System.out.println("       java -Dtools=/path/to/tools.jar -jar struts.jar ...");
                return;
            }
            urls.add(tools.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.out.println("Could not find URLs -- see stack trace.");
        }
        String command = args[0];
        String[] programArgs = new String[args.length - 1];
        System.arraycopy(args, 1, programArgs, 0, programArgs.length);
        if (command.startsWith("sitegraph:")) {
            command = "sitegraph";
            String name = Main.checkWebAppArgs(args);
            programArgs = new String[]{"-config", "apps/" + name + "/src/webapp/WEB-INF/classes", "-views", "apps/" + name + "/src/webapp", "-output", "."};
        }
        if ("sitegraph".equals(command)) {
            Main.launch("org.apache.struts2.sitegraph.SiteGraph", programArgs, urls);
        }
    }

    private static String checkWebAppArgs(String[] args) {
        int colon = args[0].indexOf(58);
        String name = null;
        try {
            name = args[0].substring(colon + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null || name.equals("")) {
            System.out.println("Error: you must specify the webapp you wish");
            System.out.println("       to deploy. The webapp name must be the");
            System.out.println("       name of the directory found in apps/.");
            System.out.println("");
            System.out.println("Example: java -jar struts-core-VERSION.jar quickstart:sandbox");
            System.exit(1);
        }
        return name;
    }

    private static void launch(String program, String[] programArgs, List<URL> urls) {
        Collections.reverse(urls);
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        MainClassLoader cl = new MainClassLoader(urlArray);
        Thread.currentThread().setContextClassLoader(cl);
        try {
            Class<?> clazz = cl.loadClass(program);
            Method main = clazz.getDeclaredMethod("main", String[].class);
            main.invoke(null, new Object[]{programArgs});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void findJars(File file, ArrayList<URL> urls) throws MalformedURLException {
        File[] files = file.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                Main.findJars(f, urls);
                continue;
            }
            if (!f.getName().endsWith(".jar") || !Main.isValid(f.getName())) continue;
            urls.add(f.toURL());
        }
    }

    private static boolean isValid(String name) {
        return !"dom.jar".equals(name);
    }

    public static class MainClassLoader
    extends URLClassLoader {
        public MainClassLoader(URL[] urls) {
            super(urls);
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (name.startsWith("org.xml.") || name.startsWith("org.w3c.") || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.") || name.startsWith("com.sun.")) {
                return super.loadClass(name, resolve);
            }
            ClassLoader parent = this.getParent();
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (Throwable t) {
                    c = parent.loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }
}

