/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Objects;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.TypeVisitor;

public class TemplateType
extends Type {
    private final TemplateName templateName;

    public TemplateType(Node fromNode, TemplateName templateName) {
        super(fromNode);
        this.templateName = Preconditions.checkNotNull(templateName);
    }

    public TemplateType(SourcePosition pos, String displayName, TemplateName templateName) {
        super(pos, displayName);
        this.templateName = Preconditions.checkNotNull(templateName);
    }

    public TemplateName getTemplateName() {
        return this.templateName;
    }

    @Override
    public boolean onlyAllowedInParam() {
        return true;
    }

    @Override
    public boolean takesDefaultParam() {
        return false;
    }

    @Override
    public Expression parseObjectConstant(String paramName, ObjectConstant objectConstant, AlertSink alertSink) {
        return objectConstant.withType(this);
    }

    @Override
    public <T> T acceptTypeVisitor(TypeVisitor<T> visitor) {
        return visitor.visitTemplateType(this);
    }

    @Override
    public boolean matches(Type that) {
        if (that instanceof TemplateType) {
            TemplateType thatInstance = (TemplateType)that;
            return Objects.equal(this.getTemplateName(), thatInstance.getTemplateName());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.templateName.toString();
    }

    @Override
    public boolean equals(Object that) {
        return this == that || that instanceof TemplateType && this.equals((TemplateType)that);
    }

    public boolean equals(TemplateType that) {
        return this.equalsType(that) && Objects.equal(this.getTemplateName(), that.getTemplateName());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.typeHashCode(), this.getTemplateName());
    }
}

