/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.ogn;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.ReflectionUtils;
import net.sf.oval.ogn.ObjectGraphNavigationResult;
import net.sf.oval.ogn.ObjectGraphNavigator;

public class ObjectGraphNavigatorDefaultImpl
implements ObjectGraphNavigator {
    public ObjectGraphNavigationResult navigateTo(Object root, String path) throws InvalidConfigurationException {
        Assert.argumentNotNull("root", root);
        Assert.argumentNotNull("path", path);
        Object parent = null;
        Object target = root;
        AccessibleObject targetAccessor = null;
        String[] stringArray = path.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String chunk = stringArray[n2];
            parent = target;
            if (parent == null) {
                return null;
            }
            Field field = ReflectionUtils.getFieldRecursive(parent.getClass(), chunk);
            if (field == null) {
                Method getter = ReflectionUtils.getGetterRecursive(parent.getClass(), chunk);
                if (getter == null) {
                    throw new InvalidConfigurationException("Invalid object navigation path from root object class [" + root.getClass().getName() + "] path: " + path);
                }
                targetAccessor = getter;
                target = ReflectionUtils.invokeMethod(getter, parent, new Object[0]);
            } else {
                targetAccessor = field;
                target = ReflectionUtils.getFieldValue(field, parent);
            }
            ++n2;
        }
        return new ObjectGraphNavigationResult(root, path, parent, targetAccessor, target);
    }
}

