/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.preparer.factory;

import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.preparer.ViewPreparer;
import org.apache.tiles.preparer.factory.PreparerFactory;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.reflect.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPreparerFactory
implements PreparerFactory {
    private final Logger log = LoggerFactory.getLogger(BasicPreparerFactory.class);
    protected Map<String, ViewPreparer> preparers = new HashMap<String, ViewPreparer>();

    @Override
    public ViewPreparer getPreparer(String name, Request context) {
        if (!this.preparers.containsKey(name)) {
            this.preparers.put(name, this.createPreparer(name));
        }
        return this.preparers.get(name);
    }

    protected ViewPreparer createPreparer(String name) {
        this.log.debug("Creating ViewPreparer '{}' . . .", (Object)name);
        Object instance = ClassUtil.instantiate((String)name, (boolean)true);
        this.log.debug("ViewPreparer created successfully");
        return (ViewPreparer)instance;
    }
}

