/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.util.Map;
import net.sf.oval.CheckExclusion;
import net.sf.oval.Validator;
import net.sf.oval.expression.ExpressionLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheckExclusion
implements CheckExclusion {
    private static final long serialVersionUID = 1L;
    private String[] profiles;
    private String when;
    private String whenFormula;
    private String whenLang;

    public Map<String, String> getMessageVariables() {
        return null;
    }

    @Override
    public String[] getProfiles() {
        return this.profiles;
    }

    @Override
    public String getWhen() {
        return String.valueOf(this.whenLang) + ":" + this.when;
    }

    @Override
    public boolean isActive(Object validatedObject, Object valueToValidate, Validator validator) {
        if (this.when == null) {
            return true;
        }
        Map values = Validator.getCollectionFactory().createMap();
        values.put("_value", valueToValidate);
        values.put("_this", validatedObject);
        ExpressionLanguage el = validator.getExpressionLanguageRegistry().getExpressionLanguage(this.whenLang);
        return el.evaluateAsBoolean(this.whenFormula, values);
    }

    @Override
    public void setProfiles(String ... profiles) {
        this.profiles = profiles;
    }

    @Override
    public void setWhen(String when) {
        if (when == null || when.length() == 0) {
            this.when = null;
            this.whenFormula = null;
            this.whenLang = null;
        } else {
            this.when = when;
            String[] parts = when.split(":", 2);
            if (parts.length == 0) {
                throw new IllegalArgumentException("[when] is missing the scripting language declaration");
            }
            this.whenLang = parts[0];
            this.whenFormula = parts[1];
        }
    }
}

