/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.reparent;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.alerts.common.ContentTypeExpectedAlert;
import com.google.gxp.compiler.alerts.common.InvalidAttributeValueError;
import com.google.gxp.compiler.alerts.common.MissingAttributeError;
import com.google.gxp.compiler.alerts.common.UnknownAttributeError;
import com.google.gxp.compiler.base.AbbrExpression;
import com.google.gxp.compiler.base.BooleanConstant;
import com.google.gxp.compiler.base.BooleanType;
import com.google.gxp.compiler.base.BundleType;
import com.google.gxp.compiler.base.ClassImport;
import com.google.gxp.compiler.base.CollapseExpression;
import com.google.gxp.compiler.base.Conditional;
import com.google.gxp.compiler.base.Constructor;
import com.google.gxp.compiler.base.ContentType;
import com.google.gxp.compiler.base.ConvertibleToContent;
import com.google.gxp.compiler.base.CppFileImport;
import com.google.gxp.compiler.base.CppLibraryImport;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.FormalTypeParameter;
import com.google.gxp.compiler.base.ImplementsDeclaration;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.Interface;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.LoopExpression;
import com.google.gxp.compiler.base.MultiLanguageAttrValue;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.NativeImplementsDeclaration;
import com.google.gxp.compiler.base.NativeType;
import com.google.gxp.compiler.base.NoMessage;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.NullRoot;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.OutputElement;
import com.google.gxp.compiler.base.PackageImport;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.PlaceholderEnd;
import com.google.gxp.compiler.base.PlaceholderStart;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.SpaceOperator;
import com.google.gxp.compiler.base.SpaceOperatorSet;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.TemplateType;
import com.google.gxp.compiler.base.ThrowsDeclaration;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.UnboundCall;
import com.google.gxp.compiler.base.UnboundImplementsDeclaration;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.base.UnextractedMessage;
import com.google.gxp.compiler.ifexpand.IfExpandedTree;
import com.google.gxp.compiler.parser.CallNamespace;
import com.google.gxp.compiler.parser.CppNamespace;
import com.google.gxp.compiler.parser.DefaultingParsedElementVisitor;
import com.google.gxp.compiler.parser.ExprNamespace;
import com.google.gxp.compiler.parser.GxpNamespace;
import com.google.gxp.compiler.parser.JavaNamespace;
import com.google.gxp.compiler.parser.JavaScriptNamespace;
import com.google.gxp.compiler.parser.MsgNamespace;
import com.google.gxp.compiler.parser.Namespace;
import com.google.gxp.compiler.parser.NamespaceVisitor;
import com.google.gxp.compiler.parser.NoMsgNamespace;
import com.google.gxp.compiler.parser.NullElement;
import com.google.gxp.compiler.parser.NullNamespace;
import com.google.gxp.compiler.parser.OutputLanguageNamespace;
import com.google.gxp.compiler.parser.OutputNamespace;
import com.google.gxp.compiler.parser.ParsedAttribute;
import com.google.gxp.compiler.parser.ParsedElement;
import com.google.gxp.compiler.parser.ParsedElementVisitor;
import com.google.gxp.compiler.parser.TextElement;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.reparent.AttributeMap;
import com.google.gxp.compiler.reparent.BadRegexError;
import com.google.gxp.compiler.reparent.ConflictingAttributesError;
import com.google.gxp.compiler.reparent.EditableParts;
import com.google.gxp.compiler.reparent.IllegalVariableNameError;
import com.google.gxp.compiler.reparent.InvalidDoctypeError;
import com.google.gxp.compiler.reparent.InvalidRootError;
import com.google.gxp.compiler.reparent.InvalidTypeError;
import com.google.gxp.compiler.reparent.MismatchedTemplateNameError;
import com.google.gxp.compiler.reparent.MisplacedJavaAnnotationError;
import com.google.gxp.compiler.reparent.MissingAttributesError;
import com.google.gxp.compiler.reparent.MoreThanOneConstructorError;
import com.google.gxp.compiler.reparent.NoClausesInCondError;
import com.google.gxp.compiler.reparent.Parts;
import com.google.gxp.compiler.reparent.ReparentedTree;
import com.google.gxp.compiler.reparent.RequiresStaticContentError;
import com.google.gxp.compiler.reparent.UnknownContentTypeError;
import com.google.gxp.compiler.schema.AttributeValidator;
import com.google.gxp.compiler.schema.DocType;
import com.google.gxp.compiler.schema.ElementValidator;
import com.google.gxp.compiler.schema.Schema;
import com.google.gxp.compiler.schema.SchemaFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Reparenter
implements Function<IfExpandedTree, ReparentedTree> {
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private final SchemaFactory schemaFactory;
    private final String className;
    private Schema rootSchema = null;
    private static final Pattern VARIABLE_NAME_PATTERN = Pattern.compile("[a-zA-Z](_?[a-zA-Z0-9])*");
    private static final Pattern ILLEGAL_NAME_PATTERN = Pattern.compile("this|gxp_(.)*");

    public Reparenter(SchemaFactory schemaFactory, String className) {
        this.schemaFactory = Preconditions.checkNotNull(schemaFactory);
        this.className = Preconditions.checkNotNull(className);
    }

    @Override
    public ReparentedTree apply(IfExpandedTree parseTree) {
        List<ParsedAttribute> noAttrs;
        Parts parts;
        List<Root> roots;
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder(parseTree.getAlerts());
        List<ParsedElement> children = parseTree.getChildren();
        if (!children.isEmpty()) {
            ParsedElement first = (ParsedElement)children.get(0);
            if (!first.canBeRoot()) {
                alertSetBuilder.add(new InvalidRootError(first));
            } else {
                String contentType = DEFAULT_CONTENT_TYPE;
                for (ParsedAttribute attr : first.getAttributes()) {
                    if (!attr.getName().equals("content-type") || attr.getNamespace() != NullNamespace.INSTANCE) continue;
                    contentType = attr.getValue();
                }
                this.rootSchema = this.schemaFactory.fromContentTypeName(contentType);
            }
        }
        Root root = (roots = (parts = this.groupParts(alertSetBuilder, parseTree, noAttrs = Collections.emptyList(), children)).getRoots()).isEmpty() ? new NullRoot(parseTree, TemplateName.parseFullyQualifiedDottedName(this.className)) : roots.get(0);
        return new ReparentedTree(parseTree.getSourcePosition(), alertSetBuilder.buildAndClear(), root);
    }

    private static Attribute convertAttribute(AlertSink alertSink, final ParsedAttribute parsedAttr) {
        Namespace namespace = parsedAttr.getNamespace();
        return namespace.acceptVisitor(new NamespaceVisitor<Attribute>(){

            private Attribute defaultVisitNamespace(Namespace ns) {
                return new Attribute((Node)parsedAttr, ns, parsedAttr.getName(), (Expression)new StringConstant(parsedAttr, null, parsedAttr.getValue()));
            }

            @Override
            public Attribute visitCallNamespace(CallNamespace ns) {
                throw new Error("TODO(laurence): implement");
            }

            @Override
            public Attribute visitCppNamespace(CppNamespace ns) {
                return this.defaultVisitNamespace(ns);
            }

            @Override
            public Attribute visitExprNamespace(ExprNamespace ns) {
                MultiLanguageAttrValue value = new MultiLanguageAttrValue(parsedAttr.getValue());
                return new Attribute((Node)parsedAttr, NullNamespace.INSTANCE, parsedAttr.getName(), (Expression)new NativeExpression((Node)parsedAttr, value));
            }

            @Override
            public Attribute visitGxpNamespace(GxpNamespace ns) {
                return this.defaultVisitNamespace(ns);
            }

            @Override
            public Attribute visitJavaNamespace(JavaNamespace ns) {
                return this.defaultVisitNamespace(ns);
            }

            @Override
            public Attribute visitJavaScriptNamespace(JavaScriptNamespace ns) {
                return this.defaultVisitNamespace(ns);
            }

            @Override
            public Attribute visitMsgNamespace(MsgNamespace ns) {
                StringConstant str = new StringConstant(parsedAttr, null, parsedAttr.getValue());
                UnextractedMessage msg = new UnextractedMessage(parsedAttr, null, null, null, false, str);
                return new Attribute((Node)parsedAttr, NullNamespace.INSTANCE, parsedAttr.getName(), (Expression)new ConvertibleToContent(msg));
            }

            @Override
            public Attribute visitNoMsgNamespace(NoMsgNamespace ns) {
                StringConstant str = new StringConstant(parsedAttr, null, parsedAttr.getValue());
                NoMessage nomsg = new NoMessage(parsedAttr.getSourcePosition(), String.format("%s namespace on %s attribute", ns.getUri(), parsedAttr.getName()), str);
                return new Attribute((Node)parsedAttr, NullNamespace.INSTANCE, parsedAttr.getName(), (Expression)new ConvertibleToContent(nomsg));
            }

            @Override
            public Attribute visitNullNamespace(NullNamespace ns) {
                return this.defaultVisitNamespace(ns);
            }

            @Override
            public Attribute visitOutputNamespace(OutputNamespace ns) {
                throw new Error("TODO(laurence): implement");
            }
        });
    }

    private Parts groupParts(final AlertSink alertSink, Node forNode, Iterable<ParsedAttribute> parsedAttrs, Iterable<ParsedElement> children) {
        final EditableParts result = new EditableParts(alertSink, forNode);
        DefaultingParsedElementVisitor<Void> childVisitor = new DefaultingParsedElementVisitor<Void>(){

            @Override
            public Void defaultVisitElement(ParsedElement element) {
                Parts nodeParts = Reparenter.this.groupParts(alertSink, element, element.getAttributes(), element.getChildren());
                element.acceptVisitor(new ElementVisitor(result, nodeParts, alertSink));
                nodeParts.reportUnused();
                return null;
            }
        };
        for (ParsedAttribute parsedAttr : parsedAttrs) {
            result.accumulate(Reparenter.convertAttribute(alertSink, parsedAttr));
        }
        for (ParsedElement child : children) {
            child.acceptVisitor(childVisitor);
        }
        return result;
    }

    private static enum GxpType {
        BOOL,
        BUNDLE;

        private static final Map<String, GxpType> MAP;

        public static GxpType parse(String s) {
            return MAP.get(s);
        }

        static {
            MAP = ImmutableMap.builder().put("boolean", BOOL).put("bundle", BUNDLE).build();
        }
    }

    private class ElementVisitor
    implements ParsedElementVisitor<Void> {
        private final EditableParts output;
        private final Parts nodeParts;
        private final AlertSink alertSink;

        ElementVisitor(EditableParts output, Parts nodeParts, AlertSink alertSink) {
            this.output = Preconditions.checkNotNull(output);
            this.nodeParts = Preconditions.checkNotNull(nodeParts);
            this.alertSink = Preconditions.checkNotNull(alertSink);
        }

        private SpaceOperator parseSpaceOperator(AttributeMap attrMap, Namespace ns, String name) {
            String value = attrMap.getOptional(ns, name, null);
            if (value != null) {
                SpaceOperator result = SpaceOperator.valueOf(value.trim().toUpperCase());
                if (result == null) {
                    this.alertSink.add(new InvalidAttributeValueError(attrMap.getAttribute(ns, name)));
                }
                return result;
            }
            return null;
        }

        private SpaceOperatorSet getSpaceOperators(AttributeMap attrMap) {
            SpaceOperator interiorSpaceOperator = this.parseSpaceOperator(attrMap, GxpNamespace.INSTANCE, "ispace");
            SpaceOperator exteriorSpaceOperator = this.parseSpaceOperator(attrMap, GxpNamespace.INSTANCE, "espace");
            return new SpaceOperatorSet(interiorSpaceOperator, exteriorSpaceOperator);
        }

        private List<JavaAnnotation> getJavaAnnotations(Node parent, JavaAnnotation.Element defaultElement, JavaAnnotation.Element ... rest) {
            ArrayList<JavaAnnotation.Element> allowedElements = Lists.newArrayList(rest);
            allowedElements.add(defaultElement);
            ArrayList<JavaAnnotation> result = Lists.newArrayList();
            for (JavaAnnotation annotation : this.nodeParts.getJavaAnnotations()) {
                if (annotation.getElement() == null) {
                    result.add(annotation.withElement(defaultElement));
                    continue;
                }
                if (allowedElements.contains((Object)annotation.getElement())) {
                    result.add(annotation);
                    continue;
                }
                this.alertSink.add(new MisplacedJavaAnnotationError(annotation));
            }
            AttributeMap attrMap = this.nodeParts.getAttributes();
            Attribute annotateAttr = attrMap.getAttribute(JavaNamespace.INSTANCE, "annotate");
            if (annotateAttr != null) {
                String annotateStr = annotateAttr.getValue().getStaticString(this.alertSink, "");
                result.add(new JavaAnnotation(annotateAttr, defaultElement, annotateStr));
            }
            return result;
        }

        private Expression getCollapsableContent(AttributeMap attrMap) {
            Expression content = this.nodeParts.getContent();
            return CollapseExpression.create(content, this.getSpaceOperators(attrMap));
        }

        @Override
        public Void visitAttrElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String name = attrMap.get("name", null);
            if (name != null) {
                ConvertibleToContent content = new ConvertibleToContent(this.getCollapsableContent(attrMap));
                Expression condition = attrMap.getOptionalExprValue("cond", null);
                this.output.accumulate(new Attribute((Node)node, name, content, condition));
            }
            return null;
        }

        @Override
        public Void visitEvalElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            MultiLanguageAttrValue expr = attrMap.getMultiLanguageAttrValue("expr", true);
            String example = attrMap.getOptional("example", null);
            String phName = attrMap.getOptional(GxpNamespace.INSTANCE, "ph", null);
            if (expr.isEmpty()) {
                this.alertSink.add(new MissingAttributeError(node, "expr"));
            } else {
                this.output.accumulate(new NativeExpression(node, expr, example, phName));
            }
            return null;
        }

        @Override
        public Void visitCondElement(GxpNamespace.GxpElement node) {
            List<Conditional.Clause> clauses = this.nodeParts.getClauses();
            Expression elseExpression = null;
            Iterator<Conditional.Clause> iter = clauses.iterator();
            while (iter.hasNext()) {
                Conditional.Clause clause = iter.next();
                if (!clause.getPredicate().alwaysEquals(true) || clauses.size() != 1 && !iter.hasNext()) continue;
                this.alertSink.add(new MissingAttributeError(clause, "cond"));
            }
            if (!clauses.isEmpty()) {
                Conditional.Clause lastClause = clauses.get(clauses.size() - 1);
                if (lastClause.getPredicate().alwaysEquals(true)) {
                    elseExpression = lastClause.getExpression();
                    clauses = clauses.subList(0, clauses.size() - 1);
                } else {
                    elseExpression = new StringConstant(node, null, "");
                }
            }
            if (clauses.isEmpty()) {
                if (elseExpression == null) {
                    this.alertSink.add(new NoClausesInCondError(node));
                }
            } else {
                this.output.accumulate(new Conditional(node, null, clauses, elseExpression));
            }
            return null;
        }

        @Override
        public Void visitClauseElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            Expression predicate = attrMap.getOptionalExprValue("cond", new BooleanConstant((Node)node, true));
            if (predicate != null) {
                this.output.accumulate(new Conditional.Clause(node, predicate, this.getCollapsableContent(attrMap)));
            }
            return null;
        }

        @Override
        public Void visitIfElement(GxpNamespace.GxpElement node) {
            throw new UnexpectedNodeException(node);
        }

        @Override
        public Void visitElifElement(GxpNamespace.GxpElement node) {
            throw new UnexpectedNodeException(node);
        }

        @Override
        public Void visitElseElement(GxpNamespace.GxpElement node) {
            throw new UnexpectedNodeException(node);
        }

        @Override
        public Void visitImportElement(GxpNamespace.GxpElement node) {
            TemplateName.FullyQualified className;
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String cls = attrMap.getOptional("class", null);
            String pkg = attrMap.getOptional("package", null);
            if (cls == null && pkg == null) {
                this.alertSink.add(new MissingAttributesError(node, "class", "package"));
                return null;
            }
            if (cls != null && pkg != null) {
                this.alertSink.add(new ConflictingAttributesError(node, attrMap.getAttribute(NullNamespace.INSTANCE, "class"), attrMap.getAttribute(NullNamespace.INSTANCE, "package")));
                return null;
            }
            if (pkg != null) {
                TemplateName.FullyQualified packageName = TemplateName.parseFullyQualifiedDottedName(this.alertSink, node.getSourcePosition(), pkg);
                if (packageName != null) {
                    this.output.accumulate(new PackageImport(node, pkg));
                }
            } else if (cls != null && (className = TemplateName.parseFullyQualifiedDottedName(this.alertSink, node.getSourcePosition(), cls)) != null) {
                this.output.accumulate(new ClassImport(node, className));
            }
            return null;
        }

        private TemplateName.FullyQualified createRootName(Node node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            Expression nameAttr = attrMap.getValue("name", null);
            if (nameAttr != null) {
                String s = nameAttr.getStaticString(this.alertSink, null);
                if (!Reparenter.this.className.equals(s)) {
                    this.alertSink.add(new MismatchedTemplateNameError(nameAttr.getSourcePosition(), s, Reparenter.this.className));
                }
            }
            return TemplateName.parseFullyQualifiedDottedName(this.alertSink, node.getSourcePosition(), Reparenter.this.className);
        }

        @Override
        public Void visitInterfaceElement(GxpNamespace.GxpElement node) {
            TemplateName.FullyQualified name = this.createRootName(node);
            ContentType contentType = this.createContentType(node, Reparenter.DEFAULT_CONTENT_TYPE);
            ArrayList<Parameter> parameters = Lists.newArrayList(this.nodeParts.getParameters());
            FormalParameter formal = new FormalParameter(node.getSourcePosition(), "this", "this", new TemplateType(node.getSourcePosition(), name.toString(), name));
            parameters.add(new Parameter(formal));
            List<JavaAnnotation> javaAnnotations = this.getJavaAnnotations(node, JavaAnnotation.Element.INTERFACE, new JavaAnnotation.Element[0]);
            List<Import> imports = this.nodeParts.getImports();
            List<ThrowsDeclaration> throwsDeclarations = this.nodeParts.getThrowsDeclarations();
            List<FormalTypeParameter> formalTypeParameters = this.nodeParts.getFormalTypeParameters();
            if (contentType != null) {
                this.output.accumulate(new Interface(node, name, contentType.getSchema(), javaAnnotations, imports, throwsDeclarations, parameters, formalTypeParameters));
            }
            return null;
        }

        @Override
        public Void visitAbbrElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            Type type = this.createType(node, attrMap, false, null);
            String name = this.getVariableName(attrMap, "name", false);
            Expression expr = attrMap.getExprValue("expr", null);
            Expression content = this.getCollapsableContent(attrMap);
            if (type != null && name != null && expr != null) {
                this.output.accumulate(new AbbrExpression(node, type, name, expr, content));
            }
            return null;
        }

        @Override
        public Void visitLoopElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            Type type = this.createType(node, attrMap, false, null);
            String key = this.getVariableName(attrMap, "key", true);
            String var = this.getVariableName(attrMap, "var", false);
            Expression content = this.getCollapsableContent(attrMap);
            Expression delimiter = attrMap.getOptionalAttributeValue("delimiter", new StringConstant(node, null, " "));
            Expression iterator = attrMap.getOptionalExprValue("iterator", null);
            Expression iterable = attrMap.getOptionalExprValue("iterable", null);
            if (iterable == null && iterator == null) {
                this.alertSink.add(new MissingAttributesError(node, "iterator", "iterable"));
                return null;
            }
            boolean foundConflict = this.checkForConflictingLoopAttributes(node, attrMap, NullNamespace.INSTANCE, NullNamespace.INSTANCE);
            for (OutputLanguageNamespace ns : AttributeMap.getOutputLanguageNamespaces()) {
                foundConflict |= this.checkForConflictingLoopAttributes(node, attrMap, NullNamespace.INSTANCE, ns);
                foundConflict |= this.checkForConflictingLoopAttributes(node, attrMap, ns, NullNamespace.INSTANCE);
                foundConflict |= this.checkForConflictingLoopAttributes(node, attrMap, ns, ns);
            }
            Attribute jsIterator = attrMap.getAttribute(JavaScriptNamespace.INSTANCE, "iterator");
            if (jsIterator != null) {
                this.alertSink.add(new UnknownAttributeError((Node)node, jsIterator));
                return null;
            }
            if (type != null && var != null && !foundConflict) {
                this.output.accumulate(new LoopExpression(node, type, key, var, iterable, iterator, content, delimiter));
            }
            return null;
        }

        public boolean checkForConflictingLoopAttributes(Node node, AttributeMap attrMap, Namespace iterableNs, Namespace iteratorNs) {
            Attribute attrA = attrMap.getAttribute(iterableNs, "iterable");
            Attribute attrB = attrMap.getAttribute(iteratorNs, "iterator");
            if (attrA != null && attrB != null) {
                this.alertSink.add(new ConflictingAttributesError(node, attrA, attrB));
                return true;
            }
            return false;
        }

        private Type createGxpType(Node node, AttributeMap attrMap, Attribute gxpType) {
            String kind = gxpType.getValue().getStaticString(this.alertSink, null);
            GxpType type = GxpType.parse(kind);
            if (type == null) {
                this.alertSink.add(new InvalidAttributeValueError(gxpType));
                return null;
            }
            switch (type) {
                case BOOL: {
                    return new BooleanType(node);
                }
                case BUNDLE: {
                    String from = attrMap.get("from-element", null);
                    if (from == null || Reparenter.this.rootSchema == null) {
                        return null;
                    }
                    HashMap<String, AttributeValidator> subAttrMap = Maps.newHashMap(Reparenter.this.rootSchema.getElementValidator(from).getAttributeValidatorMap());
                    String exclude = attrMap.getOptional("exclude", null);
                    if (exclude != null) {
                        for (String eItem : exclude.split(",")) {
                            subAttrMap.remove(eItem.trim());
                        }
                    }
                    return new BundleType(node, Reparenter.this.rootSchema, subAttrMap);
                }
            }
            this.alertSink.add(new InvalidAttributeValueError(gxpType));
            return null;
        }

        private Type createType(Node node, AttributeMap attrMap, boolean forParam, Type defaultType) {
            Type type;
            Attribute gxpType = attrMap.getAttribute(GxpNamespace.INSTANCE, "type");
            Attribute contentType = attrMap.getAttribute(NullNamespace.INSTANCE, "content-type");
            MultiLanguageAttrValue nativeType = attrMap.getMultiLanguageAttrValue("type");
            if (gxpType != null && contentType != null) {
                this.alertSink.add(new ConflictingAttributesError(node, gxpType, contentType));
            }
            if (!(gxpType == null && contentType == null || nativeType.isEmpty())) {
                Attribute conflict = gxpType != null ? gxpType : contentType;
                for (OutputLanguageNamespace ns : AttributeMap.getOutputLanguageNamespaces()) {
                    Attribute nsAttr = attrMap.getAttribute(ns, "type");
                    if (nsAttr == null) continue;
                    this.alertSink.add(new ConflictingAttributesError(node, conflict, nsAttr));
                }
                Attribute defaultTypeAttr = attrMap.getAttribute("type");
                if (defaultTypeAttr != null) {
                    this.alertSink.add(new ConflictingAttributesError(node, conflict, defaultTypeAttr));
                }
            }
            Type type2 = gxpType != null ? this.createGxpType(node, attrMap, gxpType) : (contentType != null ? this.createContentType(node, null) : (type = defaultType == null || !nativeType.isEmpty() ? new NativeType(node, nativeType) : defaultType));
            if (type != null && type.onlyAllowedInParam() && !forParam) {
                this.alertSink.add(new InvalidTypeError(type));
                type = null;
            }
            return type;
        }

        private ContentType createContentType(Node forNode, String defaultValue) {
            Schema schema;
            String contentType;
            Node node;
            AttributeMap attrMap = this.nodeParts.getAttributes();
            Attribute attr = attrMap.getAttribute("content-type");
            if (attr == null) {
                node = forNode;
                contentType = defaultValue;
            } else {
                node = attr;
                contentType = attr.getValue().getStaticString(this.alertSink, defaultValue);
            }
            Schema schema2 = schema = contentType == null ? null : Reparenter.this.schemaFactory.fromContentTypeName(contentType);
            if (schema == null && contentType != null) {
                this.alertSink.add(new UnknownContentTypeError(node, contentType));
            }
            return schema == null ? null : new ContentType(node.getSourcePosition(), node.getDisplayName(), schema);
        }

        @Override
        public Void visitParamElement(GxpNamespace.GxpElement node) {
            Type type;
            boolean consumesContent;
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String name = this.getVariableName(attrMap, "name", false);
            List<JavaAnnotation> javaAnnotations = this.getJavaAnnotations(node, JavaAnnotation.Element.PARAM, new JavaAnnotation.Element[0]);
            Expression defaultValue = null;
            boolean hasDefaultFlag = false;
            Pattern regex = null;
            Expression constructor = null;
            boolean hasConstructorFlag = false;
            String content = attrMap.getOptional("content", null);
            ContentType defaultType = null;
            boolean bl = consumesContent = content != null;
            if (consumesContent) {
                if (!"*".equals(content)) {
                    this.alertSink.add(new InvalidAttributeValueError(attrMap.getAttribute("content")));
                }
                if (Reparenter.this.rootSchema != null) {
                    defaultType = new ContentType(node.getSourcePosition(), node.getDisplayName(), Reparenter.this.rootSchema);
                }
            }
            if ((type = this.createType(node, attrMap, true, defaultType)) == null) {
                return null;
            }
            if (consumesContent && !type.isContent()) {
                this.alertSink.add(new ContentTypeExpectedAlert(node.getSourcePosition(), node.getDisplayName(), "when content='*' is set."));
                type = defaultType;
            }
            if (type.takesDefaultParam()) {
                defaultValue = attrMap.getOptionalExprValue("default", null);
                hasDefaultFlag = attrMap.getBooleanValue("has-default");
            }
            if (type.takesRegexParam()) {
                String regexStr = attrMap.getOptional("regex", null);
                if (regexStr != null) {
                    try {
                        regex = Pattern.compile(regexStr);
                    }
                    catch (PatternSyntaxException e) {
                        this.alertSink.add(new BadRegexError(node, e.getPattern()));
                    }
                }
            } else {
                regex = type.getPattern(name);
            }
            if (type.takesConstructorParam()) {
                constructor = attrMap.getOptionalExprValue("constructor", null);
                hasConstructorFlag = attrMap.getBooleanValue("has-constructor");
            }
            SpaceOperatorSet spaceOperators = this.getSpaceOperators(attrMap);
            Expression comment = this.nodeParts.getContent();
            if (!comment.hasStaticString()) {
                this.alertSink.add(new RequiresStaticContentError(node));
                comment = new StringConstant(node, null, "");
            }
            if (name != null) {
                FormalParameter formal = new FormalParameter(node, name, consumesContent, type, defaultValue, hasDefaultFlag, regex, constructor, hasConstructorFlag, spaceOperators);
                this.output.accumulate(new Parameter(formal, javaAnnotations, defaultValue, hasDefaultFlag, constructor, hasConstructorFlag, comment));
            }
            return null;
        }

        @Override
        public Void visitTemplateElement(GxpNamespace.GxpElement node) {
            Constructor constructor;
            TemplateName.FullyQualified name = this.createRootName(node);
            AttributeMap attrMap = this.nodeParts.getAttributes();
            ContentType contentType = this.createContentType(node, Reparenter.DEFAULT_CONTENT_TYPE);
            List<Constructor> constructors = this.nodeParts.getConstructors();
            Constructor constructor2 = constructor = constructors.isEmpty() ? Constructor.empty(node) : constructors.get(0);
            if (constructors.size() > 1) {
                this.alertSink.add(new MoreThanOneConstructorError(constructors.get(1)));
            }
            List<JavaAnnotation> javaAnnotations = this.getJavaAnnotations(node, JavaAnnotation.Element.CLASS, JavaAnnotation.Element.INSTANCE, JavaAnnotation.Element.INTERFACE);
            List<Import> imports = this.nodeParts.getImports();
            List<ImplementsDeclaration> implementsDeclarations = this.nodeParts.getImplementsDeclarations();
            List<ThrowsDeclaration> throwsDeclarations = this.nodeParts.getThrowsDeclarations();
            List<Parameter> parameters = this.nodeParts.getParameters();
            List<FormalTypeParameter> formalTypeParameters = this.nodeParts.getFormalTypeParameters();
            Expression content = this.getCollapsableContent(attrMap);
            if (contentType != null) {
                this.output.accumulate(new Template(node, name, contentType.getSchema(), javaAnnotations, constructor, imports, implementsDeclarations, throwsDeclarations, parameters, formalTypeParameters, content));
            }
            return null;
        }

        @Override
        public Void visitConstructorElement(GxpNamespace.GxpElement node) {
            this.output.accumulate(new Constructor(node, this.getJavaAnnotations(node, JavaAnnotation.Element.CONSTRUCTOR, new JavaAnnotation.Element[0]), this.nodeParts.getParameters()));
            return null;
        }

        @Override
        public Void visitImplementsElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String interfaceType = attrMap.getOptional(JavaNamespace.INSTANCE, "interface", null);
            if (interfaceType != null) {
                NativeType type = new NativeType((Node)node, interfaceType);
                this.output.accumulate(new NativeImplementsDeclaration(node, type));
            } else {
                interfaceType = attrMap.get("interface", null);
                if (interfaceType != null) {
                    TemplateName templateName = TemplateName.create(null, interfaceType);
                    this.output.accumulate(new UnboundImplementsDeclaration(node, templateName));
                }
            }
            return null;
        }

        @Override
        public Void visitThrowsElement(GxpNamespace.GxpElement node) {
            TemplateName exception;
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String exceptionType = attrMap.get("exception", null);
            if (exceptionType != null && (exception = TemplateName.parseDottedName(this.alertSink, node.getSourcePosition(), exceptionType)) != null) {
                this.output.accumulate(new ThrowsDeclaration(node, exceptionType));
            }
            return null;
        }

        @Override
        public Void visitTypeParamElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String name = this.getVariableName(attrMap, "name", false);
            String extendsType = attrMap.getOptional("extends", null);
            if (name != null) {
                NativeType type = extendsType == null ? null : new NativeType((Node)node, extendsType);
                this.output.accumulate(new FormalTypeParameter(node, name, type));
            }
            return null;
        }

        @Override
        public Void visitMsgElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String meaning = attrMap.getOptional("meaning", null);
            String comment = attrMap.getOptional("comment", null);
            boolean hidden = attrMap.getBooleanValue("hidden");
            Expression content = this.getCollapsableContent(attrMap);
            ContentType contentType = this.createContentType(node, null);
            Schema schema = contentType == null ? null : contentType.getSchema();
            this.output.accumulate(new UnextractedMessage(node, schema, meaning, comment, hidden, content));
            return null;
        }

        @Override
        public Void visitNoMsgElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            this.output.accumulate(new NoMessage((Node)node, this.getCollapsableContent(attrMap)));
            return null;
        }

        @Override
        public Void visitPHElement(GxpNamespace.GxpElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String name = attrMap.get("name", null);
            String example = attrMap.getOptional("example", null);
            if (example != null && example.trim().length() == 0) {
                this.alertSink.add(new InvalidAttributeValueError(attrMap.getAttribute("example")));
                example = "<var>" + name + "</var>";
            }
            if (name != null) {
                this.output.accumulate(new PlaceholderStart(node, null, name, example));
            }
            return null;
        }

        @Override
        public Void visitEPHElement(GxpNamespace.GxpElement node) {
            this.output.accumulate(new PlaceholderEnd(node, null));
            return null;
        }

        private List<String> getBundles(AttributeMap attrMap) {
            ArrayList<String> bundles = Lists.newArrayList();
            String bundlesStr = attrMap.getOptional(GxpNamespace.INSTANCE, "bundles", null);
            if (bundlesStr != null) {
                for (String s : bundlesStr.split(",")) {
                    bundles.add(s.trim());
                }
            }
            return bundles;
        }

        @Override
        public Void visitCallElement(CallNamespace.CallElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            ImmutableMap.Builder<String, Attribute> attrBuilder = ImmutableMap.builder();
            ConvertibleToContent content = new ConvertibleToContent(this.getCollapsableContent(attrMap));
            List<String> bundles = this.getBundles(attrMap);
            for (Attribute attr : attrMap.getUnusedAttributes()) {
                if (attr.getNamespace() instanceof NullNamespace) {
                    Expression value = attr.getValue();
                    if (value instanceof StringConstant) {
                        attr = attr.withValue(new ObjectConstant((StringConstant)value));
                    }
                    attrBuilder.put(attr.getName(), attr);
                    continue;
                }
                this.alertSink.add(new UnknownAttributeError((Node)node, attr));
            }
            TemplateName callee = TemplateName.parseDottedName(this.alertSink, node.getSourcePosition(), node.getTagName());
            if (callee.isValid()) {
                this.output.accumulate(new UnboundCall(node.getSourcePosition(), node.getDisplayName(), callee, attrBuilder.build(), bundles, content));
            }
            return null;
        }

        @Override
        public Void visitParsedOutputElement(OutputNamespace.ParsedOutputElement node) {
            DocType docType;
            ElementValidator validator = node.getValidator();
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String docTypeName = attrMap.getOptional(GxpNamespace.INSTANCE, "doctype", null);
            if (docTypeName == null) {
                docType = null;
            } else {
                docType = validator.getDocType(docTypeName);
                if (docType == null) {
                    this.alertSink.add(new InvalidDoctypeError(node, docTypeName));
                }
            }
            String phName = attrMap.getOptional(GxpNamespace.INSTANCE, "ph", null);
            Expression content = validator.isFlagSet(ElementValidator.Flag.NOENDTAG) ? new StringConstant(node, null, "") : this.getCollapsableContent(attrMap);
            String innerContentTypeString = validator.getInnerContentType();
            Schema innerSchema = innerContentTypeString == null ? null : Reparenter.this.schemaFactory.fromContentTypeName(innerContentTypeString);
            List<String> bundles = this.getBundles(attrMap);
            List<Attribute> attrs = attrMap.getUnusedAttributes();
            this.output.accumulate(new OutputElement(node.getSourcePosition(), node.getDisplayName(), node.getSchema(), innerSchema, validator.getTagName(), validator, docType, this.checkAttributes(node, validator, attrs), bundles, phName, content));
            return null;
        }

        @Override
        public Void visitCppIncludeElement(CppNamespace.CppElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String libraryName = attrMap.getOptional("library", null);
            String fileName = attrMap.getOptional("file", null);
            if (libraryName == null && fileName == null) {
                this.alertSink.add(new MissingAttributesError(node, "library", "file"));
                return null;
            }
            if (libraryName != null && fileName != null) {
                this.alertSink.add(new ConflictingAttributesError(node, attrMap.getAttribute(NullNamespace.INSTANCE, "library"), attrMap.getAttribute(NullNamespace.INSTANCE, "file")));
                return null;
            }
            if (libraryName != null) {
                this.output.accumulate(new CppLibraryImport(node, libraryName));
            } else if (fileName != null) {
                this.output.accumulate(new CppFileImport(node, fileName));
            }
            return null;
        }

        @Override
        public Void visitJavaAnnotateElement(JavaNamespace.JavaElement node) {
            AttributeMap attrMap = this.nodeParts.getAttributes();
            String with = attrMap.get("with", null);
            JavaAnnotation.Element element = null;
            String elementStr = attrMap.getOptional("element", null);
            if (elementStr != null) {
                try {
                    element = JavaAnnotation.Element.valueOf(elementStr.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.alertSink.add(new InvalidAttributeValueError(attrMap.getValue("element", null)));
                    with = null;
                }
            }
            if (with != null) {
                this.output.accumulate(new JavaAnnotation(node.getSourcePosition(), node.getDisplayName(), element, with));
            }
            return null;
        }

        @Override
        public Void visitTextElement(TextElement node) {
            this.output.accumulate(new StringConstant(node, null, node.getText()));
            return null;
        }

        @Override
        public Void visitNullElement(NullElement node) {
            return null;
        }

        private List<Attribute> checkAttributes(Node forNode, ElementValidator elementValidator, List<Attribute> attrs) {
            if (attrs.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Attribute> result = Lists.newArrayList();
            for (Attribute attr : attrs) {
                String innerContentTypeString;
                String value;
                AttributeValidator attrValidator = elementValidator.getAttributeValidator(attr.getName());
                if (attrValidator == null) {
                    this.alertSink.add(new UnknownAttributeError(forNode, attr));
                    continue;
                }
                Expression attrValue = attr.getValue();
                if (attrValue instanceof StringConstant && !attrValidator.isValidValue(value = ((StringConstant)attrValue).evaluate())) {
                    this.alertSink.add(new InvalidAttributeValueError(attr));
                }
                if ((innerContentTypeString = attrValidator.getContentType()) != null) {
                    Schema innerSchema = Reparenter.this.schemaFactory.fromContentTypeName(innerContentTypeString);
                    attr = attr.withInnerSchema(innerSchema);
                }
                result.add(attr);
            }
            return result;
        }

        private String getVariableName(AttributeMap attrMap, String attrName, boolean optional) {
            String result;
            String string = result = optional ? attrMap.getOptional(attrName, null) : attrMap.get(attrName, null);
            if (result != null) {
                if (!VARIABLE_NAME_PATTERN.matcher(result).matches()) {
                    this.alertSink.add(new IllegalVariableNameError(attrMap.getAttribute(attrName), result));
                    return null;
                }
                if (ILLEGAL_NAME_PATTERN.matcher(result).matches()) {
                    this.alertSink.add(new IllegalVariableNameError(attrMap.getAttribute(attrName), result));
                    return null;
                }
                if (result.length() > 64) {
                    this.alertSink.add(new IllegalVariableNameError(attrMap.getAttribute(attrName), result));
                    return null;
                }
            }
            return result;
        }
    }
}

