/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.admin.actions;

import com.opensymphony.xwork2.ActionSupport;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.felix.shell.ShellService;
import org.apache.struts2.osgi.DefaultBundleAccessor;
import org.apache.struts2.osgi.interceptor.BundleContextAware;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ShellAction
extends ActionSupport
implements BundleContextAware {
    private String command;
    private String output;
    private BundleContext bundleContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        ByteArrayOutputStream outByteStream = new ByteArrayOutputStream();
        ByteArrayOutputStream errByteStream = new ByteArrayOutputStream();
        PrintStream outStream = new PrintStream(outByteStream);
        PrintStream errStream = new PrintStream(errByteStream);
        String outString = null;
        String errString = null;
        try {
            this.executeCommand(this.command, outStream, errStream);
            outString = outByteStream.toString().trim();
            errString = errByteStream.toString().trim();
        }
        catch (Exception e) {
            outString = outByteStream.toString().trim();
            errString = "Exception: " + e.toString() + " (" + e.getMessage() + ").  Output:" + outString + ".  Error: " + errByteStream.toString().trim();
        }
        finally {
            outStream.close();
            errStream.close();
        }
        this.output = errString != null && errString.length() > 0 ? errString : outString;
        return "success";
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getOutput() {
        return this.output;
    }

    public void executeCommand(String commandLine, PrintStream out, PrintStream err) throws Exception {
        ShellService shellService = this.getShellService(out);
        if (shellService != null) {
            out.println("Attempting to execute command: " + commandLine);
            shellService.executeCommand(commandLine, out, err);
        } else {
            err.println("Apache Felix Shell service is not installed");
        }
    }

    private ShellService getShellService(PrintStream out) {
        Bundle[] bundles;
        ServiceReference ref;
        DefaultBundleAccessor bundleAccessor = DefaultBundleAccessor.getInstance();
        ServiceReference serviceReference = ref = bundleAccessor != null ? bundleAccessor.getServiceReference(ShellService.class.getName()) : null;
        if (ref == null && this.bundleContext != null && (bundles = this.bundleContext.getBundles()) != null && bundles.length > 0) {
            for (Bundle currentBundle : bundles) {
                ServiceReference directShellServiceByName;
                if (currentBundle == null || !currentBundle.getSymbolicName().startsWith("org.apache.felix.shell")) continue;
                BundleContext currentBundleContext = currentBundle.getBundleContext();
                ServiceReference directShellServiceByClass = currentBundleContext != null ? currentBundleContext.getServiceReference(ShellService.class) : null;
                ServiceReference serviceReference2 = directShellServiceByName = currentBundleContext != null ? currentBundleContext.getServiceReference("org.apache.felix.shell.ShellService") : null;
                if (ref != null) continue;
                ref = directShellServiceByClass != null ? directShellServiceByClass : directShellServiceByName;
            }
        }
        if (ref == null) {
            out.println("ShellService reference cannot be found (null), service lookup will fail.");
        }
        return (ShellService)(bundleAccessor != null ? bundleAccessor.getService(ref) : null);
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }
}

