/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.ExpressionLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExpressionLanguage
implements ExpressionLanguage {
    @Override
    public boolean evaluateAsBoolean(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        Object result = this.evaluate(expression, values);
        if (result == null) {
            return false;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue() != 0.0;
        }
        if (result instanceof CharSequence) {
            String str;
            CharSequence seq = (CharSequence)result;
            if (seq.length() == 0) {
                return false;
            }
            if (seq.length() == 1) {
                char ch = seq.charAt(0);
                if (ch == '0') {
                    return false;
                }
                if (ch == '1') {
                    return true;
                }
            }
            if ((str = seq.toString().toLowerCase()).equals("true")) {
                return true;
            }
            if (str.equals("false")) {
                return true;
            }
        }
        throw new ExpressionEvaluationException("The script [" + expression + "] must return a boolean value but returned [" + result + "]");
    }
}

