/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.gxp;

import com.google.gxp.base.GxpContext;
import com.google.gxp.html.HtmlClosure;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.io.IOException;
import org.apache.struts2.views.gxp.AbstractGxpResult;
import org.apache.struts2.views.gxp.Gxp;
import org.apache.struts2.views.gxp.GxpInstance;

public class GxpResult
extends AbstractGxpResult {
    public static final String DEFAULT_PARAM = "gxpName";
    private Container container;
    private boolean outputXml = false;

    public void setOutputXml(boolean outputXml) {
        this.outputXml = outputXml;
    }

    protected HtmlClosure getGxpClosure() {
        Gxp gxp;
        Gxp gxp2 = gxp = this.getUseInstances() ? GxpInstance.getInstance(this.getGxpName()) : Gxp.getInstance(this.getGxpName());
        if (null == gxp) {
            throw new NullPointerException("The GXP " + this.getGxpName() + " could not be loaded.  This is probably because you have" + " a typo in your config.");
        }
        this.container.inject((Object)gxp);
        return new HtmlClosure(){

            public void write(Appendable out, GxpContext gxpContext) throws IOException {
                gxp.write(out, gxpContext);
            }
        };
    }

    public void execute(ActionInvocation actionInvocation) {
        AbstractGxpResult.GxpResourceProvider provider = this.getProvider();
        try {
            this.getGxpClosure().write((Appendable)provider.getWriter(), new GxpContext(provider.getLocale(), this.outputXml));
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while rendering " + this.getGxpName() + " coming from " + actionInvocation.getAction().getClass().getName() + ".", e);
        }
    }

    AbstractGxpResult.GxpResourceProvider getProvider() {
        return new HtmlOrXmlProvider(this.outputXml);
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    private static class HtmlOrXmlProvider
    extends AbstractGxpResult.DefaultProvider {
        private static final String HTML_CONTENT_TYPE = "text/html; charset=UTF-8";
        private static final String XML_CONTENT_TYPE = "application/xml; charset=UTF-8";

        HtmlOrXmlProvider(boolean outputXml) {
            super(outputXml ? XML_CONTENT_TYPE : HTML_CONTENT_TYPE);
        }
    }
}

