/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.impl;

import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.BasicAttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.AttributeEvaluatorFactoryAware;
import org.apache.tiles.preparer.ViewPreparer;
import org.apache.tiles.preparer.factory.NoSuchPreparerException;
import org.apache.tiles.preparer.factory.PreparerFactory;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.render.CannotRenderException;
import org.apache.tiles.request.render.Renderer;
import org.apache.tiles.request.render.RendererFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTilesContainer
implements TilesContainer,
AttributeEvaluatorFactoryAware {
    private static final String ATTRIBUTE_CONTEXT_STACK = "org.apache.tiles.AttributeContext.STACK";
    private final Logger log = LoggerFactory.getLogger(BasicTilesContainer.class);
    private ApplicationContext context;
    private DefinitionsFactory definitionsFactory;
    private PreparerFactory preparerFactory;
    private RendererFactory rendererFactory;
    private AttributeEvaluatorFactory attributeEvaluatorFactory;

    public AttributeContext startContext(Request request) {
        BasicAttributeContext context = new BasicAttributeContext();
        Deque<AttributeContext> stack = this.getContextStack(request);
        if (!stack.isEmpty()) {
            AttributeContext parent = stack.peek();
            context.inheritCascadedAttributes(parent);
        }
        stack.push((AttributeContext)context);
        return context;
    }

    public void endContext(Request request) {
        this.popContext(request);
    }

    public void renderContext(Request request) {
        AttributeContext attributeContext = this.getAttributeContext(request);
        this.render(request, attributeContext);
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public void setApplicationContext(ApplicationContext context) {
        this.context = context;
    }

    public AttributeContext getAttributeContext(Request request) {
        AttributeContext context = this.getContext(request);
        if (context == null) {
            context = new BasicAttributeContext();
            this.pushContext(context, request);
        }
        return context;
    }

    public DefinitionsFactory getDefinitionsFactory() {
        return this.definitionsFactory;
    }

    public void setDefinitionsFactory(DefinitionsFactory definitionsFactory) {
        this.definitionsFactory = definitionsFactory;
    }

    public PreparerFactory getPreparerFactory() {
        return this.preparerFactory;
    }

    public void setPreparerFactory(PreparerFactory preparerFactory) {
        this.preparerFactory = preparerFactory;
    }

    public void setRendererFactory(RendererFactory rendererFactory) {
        this.rendererFactory = rendererFactory;
    }

    @Override
    public void setAttributeEvaluatorFactory(AttributeEvaluatorFactory attributeEvaluatorFactory) {
        this.attributeEvaluatorFactory = attributeEvaluatorFactory;
    }

    public void prepare(String preparer, Request request) {
        this.prepare(request, preparer, false);
    }

    public void render(String definitionName, Request request) {
        this.log.debug("Render request received for definition '{}'", (Object)definitionName);
        Definition definition = this.getDefinition(definitionName, request);
        if (definition == null) {
            throw new NoSuchDefinitionException("Unable to find the definition '" + definitionName + "'");
        }
        this.render(definition, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Definition definition, Request request) {
        AttributeContext originalContext = this.getAttributeContext(request);
        BasicAttributeContext subContext = new BasicAttributeContext(originalContext);
        subContext.inherit((BasicAttributeContext)definition);
        this.pushContext((AttributeContext)subContext, request);
        try {
            this.render(request, (AttributeContext)subContext);
        }
        finally {
            this.popContext(request);
        }
    }

    public void render(Attribute attr, Request request) throws IOException {
        if (attr == null) {
            throw new CannotRenderException("Cannot render a null attribute");
        }
        if (attr.isPermitted(request)) {
            Renderer renderer = this.rendererFactory.getRenderer(attr.getRenderer());
            Object value = this.evaluate(attr, request);
            if (!(value instanceof String)) {
                throw new CannotRenderException("Cannot render an attribute that is not a string, toString returns: " + value);
            }
            renderer.render((String)value, request);
        }
    }

    public Object evaluate(Attribute attribute, Request request) {
        AttributeEvaluator evaluator = this.attributeEvaluatorFactory.getAttributeEvaluator(attribute);
        return evaluator.evaluate(attribute, request);
    }

    public boolean isValidDefinition(String definitionName, Request request) {
        try {
            Definition definition = this.getDefinition(definitionName, request);
            return definition != null;
        }
        catch (NoSuchDefinitionException nsde) {
            this.log.debug("Cannot find definition '{}'", (Object)definitionName);
            this.log.debug("Exception related to the not found definition", (Throwable)((Object)nsde));
            return false;
        }
    }

    public Definition getDefinition(String definitionName, Request request) {
        Definition definition = this.definitionsFactory.getDefinition(definitionName, request);
        return definition;
    }

    protected Deque<AttributeContext> getContextStack(Request tilesContext) {
        Map requestScope = tilesContext.getContext("request");
        LinkedList contextStack = (LinkedList)requestScope.get(ATTRIBUTE_CONTEXT_STACK);
        if (contextStack == null) {
            contextStack = new LinkedList();
            requestScope.put(ATTRIBUTE_CONTEXT_STACK, contextStack);
        }
        return contextStack;
    }

    protected void pushContext(AttributeContext context, Request tilesContext) {
        Deque<AttributeContext> contextStack = this.getContextStack(tilesContext);
        contextStack.push(context);
    }

    protected AttributeContext popContext(Request tilesContext) {
        Deque<AttributeContext> contextStack = this.getContextStack(tilesContext);
        return contextStack.pop();
    }

    protected AttributeContext getContext(Request tilesContext) {
        Deque<AttributeContext> contextStack = this.getContextStack(tilesContext);
        if (!contextStack.isEmpty()) {
            return contextStack.peek();
        }
        return null;
    }

    private void prepare(Request context, String preparerName, boolean ignoreMissing) {
        this.log.debug("Prepare request received for '{}'", (Object)preparerName);
        ViewPreparer preparer = this.preparerFactory.getPreparer(preparerName, context);
        if (preparer == null && ignoreMissing) {
            return;
        }
        if (preparer == null) {
            throw new NoSuchPreparerException("Preparer '" + preparerName + " not found");
        }
        AttributeContext attributeContext = this.getContext(context);
        preparer.execute(context, attributeContext);
    }

    protected void render(Request request, AttributeContext attributeContext) {
        try {
            if (attributeContext.getPreparer() != null) {
                this.prepare(request, attributeContext.getPreparer(), true);
            }
            this.render(attributeContext.getTemplateAttribute(), request);
        }
        catch (IOException e) {
            throw new CannotRenderException(e.getMessage(), (Throwable)e);
        }
    }
}

