/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import net.sf.oval.Check;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.context.OValContext;
import net.sf.oval.expression.ExpressionLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCheck
implements Check {
    private static final long serialVersionUID = 1L;
    private OValContext context;
    private String errorCode;
    private String message;
    private Map<String, ? extends Serializable> messageVariables;
    private Map<String, ? extends Serializable> messageVariablesUnmodifiable;
    private boolean messageVariablesUpToDate = true;
    private String[] profiles;
    private int severity;
    private ConstraintTarget[] appliesTo;
    private String target;
    private String when;
    private transient String whenFormula;
    private transient String whenLang;

    protected Map<String, ? extends Serializable> createMessageVariables() {
        return null;
    }

    @Override
    public ConstraintTarget[] getAppliesTo() {
        return this.appliesTo == null ? this.getAppliesToDefault() : this.appliesTo;
    }

    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.CONTAINER};
    }

    @Override
    public OValContext getContext() {
        return this.context;
    }

    @Override
    public String getErrorCode() {
        if (this.errorCode == null) {
            String className = this.getClass().getName();
            this.errorCode = className.endsWith("Check") ? className.substring(0, this.getClass().getName().length() - "Check".length()) : className;
        }
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        if (this.message == null) {
            String className = this.getClass().getName();
            this.message = className.endsWith("Check") ? String.valueOf(className.substring(0, this.getClass().getName().length() - "Check".length())) + ".violated" : String.valueOf(className) + ".violated";
        }
        return this.message;
    }

    @Override
    public final Map<String, ? extends Serializable> getMessageVariables() {
        if (!this.messageVariablesUpToDate) {
            this.messageVariables = this.createMessageVariables();
            this.messageVariablesUnmodifiable = this.messageVariables == null ? null : Collections.unmodifiableMap(this.messageVariables);
            this.messageVariablesUpToDate = true;
        }
        return this.messageVariablesUnmodifiable;
    }

    @Override
    public String[] getProfiles() {
        return this.profiles;
    }

    @Override
    public int getSeverity() {
        return this.severity;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    @Override
    public String getWhen() {
        return this.when;
    }

    @Override
    public boolean isActive(Object validatedObject, Object valueToValidate, Validator validator) {
        if (this.when == null) {
            return true;
        }
        if (this.whenLang == null) {
            this.setWhen(this.when);
        }
        Map values = Validator.getCollectionFactory().createMap();
        values.put("_value", valueToValidate);
        values.put("_this", validatedObject);
        ExpressionLanguage el = validator.getExpressionLanguageRegistry().getExpressionLanguage(this.whenLang);
        return el.evaluateAsBoolean(this.whenFormula, values);
    }

    protected void requireMessageVariablesRecreation() {
        this.messageVariablesUpToDate = false;
    }

    @Override
    public void setAppliesTo(ConstraintTarget ... targets) {
        this.appliesTo = targets;
    }

    @Override
    public void setContext(OValContext context) {
        this.context = context;
    }

    @Override
    public void setErrorCode(String failureCode) {
        this.errorCode = failureCode;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setProfiles(String ... profiles) {
        this.profiles = profiles;
    }

    @Override
    public void setSeverity(int severity) {
        this.severity = severity;
    }

    @Override
    public void setTarget(String target) {
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWhen(String when) {
        AbstractCheck abstractCheck = this;
        synchronized (abstractCheck) {
            if (when == null || when.length() == 0) {
                this.when = null;
                this.whenFormula = null;
                this.whenLang = null;
            } else {
                String[] parts = when.split(":", 2);
                if (parts.length == 0) {
                    throw new IllegalArgumentException("[when] is missing the scripting language declaration");
                }
                this.when = when;
                this.whenLang = parts[0];
                this.whenFormula = parts[1];
            }
        }
    }
}

