/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableList;
import com.google.gxp.com.google.common.collect.Iterables;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.compiler.alerts.SourcePosition;
import com.google.gxp.compiler.base.AbstractCallable;
import com.google.gxp.compiler.base.AbstractRoot;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.CallableVisitor;
import com.google.gxp.compiler.base.Constructor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.FormalParameter;
import com.google.gxp.compiler.base.FormalTypeParameter;
import com.google.gxp.compiler.base.Implementable;
import com.google.gxp.compiler.base.ImplementsDeclaration;
import com.google.gxp.compiler.base.Import;
import com.google.gxp.compiler.base.InstanceCallable;
import com.google.gxp.compiler.base.InstanceType;
import com.google.gxp.compiler.base.JavaAnnotation;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.RootVisitor;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.base.ThrowsDeclaration;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.schema.Schema;
import java.util.ArrayList;
import java.util.List;

public final class Template
extends AbstractRoot<Template> {
    private final Constructor constructor;
    private final ImmutableList<Parameter> allParameters;
    private final ImmutableList<ImplementsDeclaration> implementsDeclarations;
    private final Expression content;
    private final Callable callable;
    private final InstanceCallable instanceCallable;

    public Template(SourcePosition sourcePosition, String displayName, TemplateName.FullyQualified name, Schema schema, List<JavaAnnotation> javaAnnotations, Constructor constructor, List<Import> imports, List<ImplementsDeclaration> implementsDeclarations, List<ThrowsDeclaration> throwsDeclarations, List<Parameter> parameters, List<FormalTypeParameter> formalTypeParameters, Expression content) {
        super(sourcePosition, displayName, name, schema, javaAnnotations, imports, throwsDeclarations, parameters, formalTypeParameters);
        this.constructor = Preconditions.checkNotNull(constructor);
        this.allParameters = ImmutableList.copyOf(Iterables.concat(constructor.getParameters(), this.getParameters()));
        this.implementsDeclarations = ImmutableList.copyOf(implementsDeclarations);
        this.content = Preconditions.checkNotNull(content);
        this.callable = new TemplateCallable(name, schema, this.getAllParameters());
        ArrayList<Parameter> params = Lists.newArrayList();
        params.addAll(this.getParameters());
        params.add(new Parameter(new FormalParameter(sourcePosition, "this", "this", new InstanceType(this, name))));
        this.instanceCallable = new TemplateInstanceCallable(name, schema, params);
    }

    public Template(Node fromNode, TemplateName.FullyQualified name, Schema schema, List<JavaAnnotation> javaAnnotations, Constructor constructor, List<Import> imports, List<ImplementsDeclaration> implementsDeclarations, List<ThrowsDeclaration> throwsDeclarations, List<Parameter> parameters, List<FormalTypeParameter> formalTypeParameters, Expression content) {
        this(fromNode.getSourcePosition(), fromNode.getDisplayName(), name, schema, javaAnnotations, constructor, imports, implementsDeclarations, throwsDeclarations, parameters, formalTypeParameters, content);
    }

    @Override
    protected Template self() {
        return this;
    }

    @Override
    protected Template withParameters(List<Parameter> newParameters) {
        return new Template(this, this.getName(), this.getSchema(), this.getJavaAnnotations(), this.constructor, this.getImports(), this.getImplementsDeclarations(), this.getThrowsDeclarations(), newParameters, this.getFormalTypeParameters(), this.content);
    }

    public Template withContent(Expression newContent) {
        return newContent.equals(this.content) ? this : new Template(this, this.getName(), this.getSchema(), this.getJavaAnnotations(), this.constructor, this.getImports(), this.getImplementsDeclarations(), this.getThrowsDeclarations(), this.getParameters(), this.getFormalTypeParameters(), newContent);
    }

    public Template withConstructor(Constructor newConstructor) {
        return this.constructor.equals(newConstructor) ? this : new Template(this, this.getName(), this.getSchema(), this.getJavaAnnotations(), newConstructor, this.getImports(), this.getImplementsDeclarations(), this.getThrowsDeclarations(), this.getParameters(), this.getFormalTypeParameters(), this.content);
    }

    public Template withImplementsDeclarations(List<ImplementsDeclaration> newImplDec) {
        return this.implementsDeclarations.equals(newImplDec) ? this : new Template(this, this.getName(), this.getSchema(), this.getJavaAnnotations(), this.getConstructor(), this.getImports(), newImplDec, this.getThrowsDeclarations(), this.getParameters(), this.getFormalTypeParameters(), this.content);
    }

    @Override
    public <T> T acceptVisitor(RootVisitor<T> visitor) {
        return visitor.visitTemplate(this);
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public List<Parameter> getAllParameters() {
        return this.allParameters;
    }

    public List<ImplementsDeclaration> getImplementsDeclarations() {
        return this.implementsDeclarations;
    }

    public Expression getContent() {
        return this.content;
    }

    @Override
    public Callable getCallable() {
        return this.callable;
    }

    @Override
    public InstanceCallable getInstanceCallable() {
        return this.instanceCallable;
    }

    @Override
    public Implementable getImplementable() {
        return null;
    }

    private static class TemplateInstanceCallable
    extends AbstractCallable
    implements InstanceCallable {
        public TemplateInstanceCallable(TemplateName.FullyQualified name, Schema schema, List<Parameter> parameters) {
            super(name, schema, parameters);
        }

        @Override
        public Type getInstanceType() {
            return this.getParameter("this").getType();
        }

        @Override
        public <T> T acceptCallableVisitor(CallableVisitor<T> visitor) {
            return visitor.visitInstanceCallable(this);
        }

        @Override
        public boolean equals(Object that) {
            return this == that || that instanceof TemplateInstanceCallable && this.equals((TemplateInstanceCallable)that);
        }

        public boolean equals(TemplateInstanceCallable that) {
            return this.equalsAbstractCallable(that);
        }

        @Override
        public int hashCode() {
            return this.abstractCallableHashCode();
        }
    }

    private static class TemplateCallable
    extends AbstractCallable {
        public TemplateCallable(TemplateName.FullyQualified name, Schema schema, List<Parameter> parameters) {
            super(name, schema, parameters);
        }

        @Override
        public <T> T acceptCallableVisitor(CallableVisitor<T> visitor) {
            return visitor.visitCallable(this);
        }

        @Override
        public boolean equals(Object that) {
            return this == that || that instanceof TemplateCallable && this.equals((TemplateCallable)that);
        }

        public boolean equals(TemplateCallable that) {
            return this.equalsAbstractCallable(that);
        }

        @Override
        public int hashCode() {
            return this.abstractCallableHashCode();
        }
    }
}

