/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.impl;

import java.util.StringTokenizer;

public class LogOptions {
    private int minLevel = 4;
    private int maxNumberOfLogs = -1;

    public LogOptions(String commandLine) {
        StringTokenizer st = new StringTokenizer(commandLine);
        this.readOptions(st);
    }

    private void readOptions(StringTokenizer st) {
        if (st.countTokens() > 1) {
            st.nextToken();
            String firstOption = st.nextToken();
            this.checkOption(firstOption);
            if (st.hasMoreTokens()) {
                this.checkOption(st.nextToken());
            }
        }
    }

    private void checkOption(String opt) {
        try {
            this.maxNumberOfLogs = Integer.parseInt(opt);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ("info".equalsIgnoreCase(opt)) {
            this.minLevel = 3;
        } else if ("warn".equalsIgnoreCase(opt)) {
            this.minLevel = 2;
        } else if ("error".equalsIgnoreCase(opt)) {
            this.minLevel = 1;
        }
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    public int getMaxNumberOfLogs() {
        return this.maxNumberOfLogs;
    }
}

