/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.osgi.framework.Bundle;

public class OsgiUtil {
    private static final Logger LOG = LogManager.getLogger(OsgiUtil.class);

    public static URL translateBundleURLToJarURL(URL bundleUrl, Bundle bundle) throws MalformedURLException {
        if (bundleUrl != null && "bundle".equalsIgnoreCase(bundleUrl.getProtocol())) {
            StringBuilder sb = new StringBuilder("jar:");
            sb.append(bundle.getLocation());
            sb.append("!");
            sb.append(bundleUrl.getFile());
            return new URL(sb.toString());
        }
        return bundleUrl;
    }

    public static Object getBean(Object beanFactory, String beanId) {
        try {
            Method getBeanMethod = beanFactory.getClass().getMethod("getBean", String.class);
            return getBeanMethod.invoke(beanFactory, beanId);
        }
        catch (Exception ex) {
            LOG.error("Unable to call getBean() on object of type [{}], with bean id [{}]", (Object)beanFactory.getClass().getName(), (Object)beanId, (Object)ex);
            return null;
        }
    }

    public static boolean containsBean(Object beanFactory, String beanId) {
        try {
            Method getBeanMethod = beanFactory.getClass().getMethod("containsBean", String.class);
            return (Boolean)getBeanMethod.invoke(beanFactory, beanId);
        }
        catch (Exception ex) {
            LOG.error("Unable to call containsBean() on object of type [{}], with bean id [{}]", (Object)beanFactory.getClass().getName(), (Object)beanId, (Object)ex);
            return false;
        }
    }
}

