/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.OgnlTypeConverterWrapper;
import com.opensymphony.xwork2.ognl.SecurityMemberAccess;
import com.opensymphony.xwork2.ognl.accessor.CompoundRootAccessor;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.reflection.ReflectionException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import ognl.ClassResolver;
import ognl.MemberAccess;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.TypeConverter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OgnlUtil {
    private static final Logger LOG = LogManager.getLogger(OgnlUtil.class);
    private ConcurrentMap<String, Object> expressions = new ConcurrentHashMap<String, Object>();
    private final ConcurrentMap<Class, BeanInfo> beanInfoCache = new ConcurrentHashMap<Class, BeanInfo>();
    private TypeConverter defaultConverter;
    private boolean devMode = false;
    private boolean enableExpressionCache = true;
    private boolean enableEvalExpression;
    private Set<Class<?>> excludedClasses = new HashSet();
    private Set<Pattern> excludedPackageNamePatterns = new HashSet<Pattern>();
    private Set<String> excludedPackageNames = new HashSet<String>();
    private Container container;
    private boolean allowStaticMethodAccess;
    private boolean disallowProxyMemberAccess;

    @Inject
    public void setXWorkConverter(XWorkConverter conv) {
        this.defaultConverter = new OgnlTypeConverterWrapper(conv);
    }

    @Inject(value="devMode")
    public void setDevMode(String mode) {
        this.devMode = BooleanUtils.toBoolean((String)mode);
    }

    @Inject(value="enableOGNLExpressionCache")
    public void setEnableExpressionCache(String cache) {
        this.enableExpressionCache = BooleanUtils.toBoolean((String)cache);
    }

    @Inject(value="enableOGNLEvalExpression", required=false)
    public void setEnableEvalExpression(String evalExpression) {
        this.enableEvalExpression = "true".equals(evalExpression);
        if (this.enableEvalExpression) {
            LOG.warn("Enabling OGNL expression evaluation may introduce security risks (see http://struts.apache.org/release/2.3.x/docs/s2-013.html for further details)");
        }
    }

    @Inject(value="ognlExcludedClasses", required=false)
    public void setExcludedClasses(String commaDelimitedClasses) {
        HashSet excludedClasses = new HashSet();
        excludedClasses.addAll(this.excludedClasses);
        excludedClasses.addAll(this.parseExcludedClasses(commaDelimitedClasses));
        this.excludedClasses = Collections.unmodifiableSet(excludedClasses);
    }

    private Set<Class<?>> parseExcludedClasses(String commaDelimitedClasses) {
        Set<String> classNames = TextParseUtil.commaDelimitedStringToSet(commaDelimitedClasses);
        HashSet classes = new HashSet();
        for (String className : classNames) {
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Cannot load excluded class: " + className, e);
            }
        }
        return classes;
    }

    @Inject(value="ognlExcludedPackageNamePatterns", required=false)
    public void setExcludedPackageNamePatterns(String commaDelimitedPackagePatterns) {
        HashSet<Pattern> excludedPackageNamePatterns = new HashSet<Pattern>();
        excludedPackageNamePatterns.addAll(this.excludedPackageNamePatterns);
        excludedPackageNamePatterns.addAll(this.parseExcludedPackageNamePatterns(commaDelimitedPackagePatterns));
        this.excludedPackageNamePatterns = Collections.unmodifiableSet(excludedPackageNamePatterns);
    }

    private Set<Pattern> parseExcludedPackageNamePatterns(String commaDelimitedPackagePatterns) {
        Set<String> packagePatterns = TextParseUtil.commaDelimitedStringToSet(commaDelimitedPackagePatterns);
        HashSet<Pattern> packageNamePatterns = new HashSet<Pattern>();
        for (String pattern : packagePatterns) {
            packageNamePatterns.add(Pattern.compile(pattern));
        }
        return packageNamePatterns;
    }

    @Inject(value="ognlExcludedPackageNames", required=false)
    public void setExcludedPackageNames(String commaDelimitedPackageNames) {
        HashSet<String> excludedPackageNames = new HashSet<String>();
        excludedPackageNames.addAll(this.excludedPackageNames);
        excludedPackageNames.addAll(this.parseExcludedPackageNames(commaDelimitedPackageNames));
        this.excludedPackageNames = Collections.unmodifiableSet(excludedPackageNames);
    }

    private Set<String> parseExcludedPackageNames(String commaDelimitedPackageNames) {
        return TextParseUtil.commaDelimitedStringToSet(commaDelimitedPackageNames);
    }

    public Set<Class<?>> getExcludedClasses() {
        return this.excludedClasses;
    }

    public Set<Pattern> getExcludedPackageNamePatterns() {
        return this.excludedPackageNamePatterns;
    }

    public Set<String> getExcludedPackageNames() {
        return this.excludedPackageNames;
    }

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="allowStaticMethodAccess", required=false)
    public void setAllowStaticMethodAccess(String allowStaticMethodAccess) {
        this.allowStaticMethodAccess = Boolean.parseBoolean(allowStaticMethodAccess);
    }

    @Inject(value="struts.disallowProxyMemberAccess", required=false)
    public void setDisallowProxyMemberAccess(String disallowProxyMemberAccess) {
        this.disallowProxyMemberAccess = Boolean.parseBoolean(disallowProxyMemberAccess);
    }

    public boolean isDisallowProxyMemberAccess() {
        return this.disallowProxyMemberAccess;
    }

    public void setProperties(Map<String, ?> props, Object o, Map<String, Object> context) {
        this.setProperties(props, o, context, false);
    }

    public void setProperties(Map<String, ?> props, Object o, Map<String, Object> context, boolean throwPropertyExceptions) throws ReflectionException {
        if (props == null) {
            return;
        }
        Ognl.setTypeConverter(context, (TypeConverter)this.getTypeConverterFromContext(context));
        Object oldRoot = Ognl.getRoot(context);
        Ognl.setRoot(context, (Object)o);
        for (Map.Entry<String, ?> entry : props.entrySet()) {
            String expression = entry.getKey();
            this.internalSetProperty(expression, entry.getValue(), o, context, throwPropertyExceptions);
        }
        Ognl.setRoot(context, (Object)oldRoot);
    }

    public void setProperties(Map<String, ?> properties, Object o) {
        this.setProperties(properties, o, false);
    }

    public void setProperties(Map<String, ?> properties, Object o, boolean throwPropertyExceptions) {
        Map context = this.createDefaultContext(o, null);
        this.setProperties(properties, o, context, throwPropertyExceptions);
    }

    public void setProperty(String name, Object value, Object o, Map<String, Object> context) {
        this.setProperty(name, value, o, context, false);
    }

    public void setProperty(String name, Object value, Object o, Map<String, Object> context, boolean throwPropertyExceptions) {
        Ognl.setTypeConverter(context, (TypeConverter)this.getTypeConverterFromContext(context));
        Object oldRoot = Ognl.getRoot(context);
        Ognl.setRoot(context, (Object)o);
        this.internalSetProperty(name, value, o, context, throwPropertyExceptions);
        Ognl.setRoot(context, (Object)oldRoot);
    }

    public Object getRealTarget(String property, Map<String, Object> context, Object root) throws OgnlException {
        if ("top".equals(property)) {
            return root;
        }
        if (root instanceof CompoundRoot) {
            CompoundRoot cr = (CompoundRoot)root;
            try {
                for (Object target : cr) {
                    if (!OgnlRuntime.hasSetProperty((OgnlContext)((OgnlContext)context), target, (Object)property) && !OgnlRuntime.hasGetProperty((OgnlContext)((OgnlContext)context), target, (Object)property) && OgnlRuntime.getIndexedPropertyType((OgnlContext)((OgnlContext)context), target.getClass(), (String)property) == OgnlRuntime.INDEXED_PROPERTY_NONE) continue;
                    return target;
                }
            }
            catch (IntrospectionException ex) {
                throw new ReflectionException("Cannot figure out real target class", ex);
            }
            return null;
        }
        return root;
    }

    public void setValue(String name, final Map<String, Object> context, final Object root, final Object value) throws OgnlException {
        this.compileAndExecute(name, context, new OgnlTask<Void>(){

            @Override
            public Void execute(Object tree) throws OgnlException {
                if (OgnlUtil.this.isEvalExpression(tree, context)) {
                    throw new OgnlException("Eval expression/chained expressions cannot be used as parameter name");
                }
                if (OgnlUtil.this.isArithmeticExpression(tree, context)) {
                    throw new OgnlException("Arithmetic expressions cannot be used as parameter name");
                }
                Ognl.setValue((Object)tree, (Map)context, (Object)root, (Object)value);
                return null;
            }
        });
    }

    private boolean isEvalExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (tree instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)tree;
            OgnlContext ognlContext = null;
            if (context != null && context instanceof OgnlContext) {
                ognlContext = (OgnlContext)context;
            }
            return node.isEvalChain(ognlContext) || node.isSequence(ognlContext);
        }
        return false;
    }

    private boolean isArithmeticExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (tree instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)tree;
            OgnlContext ognlContext = null;
            if (context != null && context instanceof OgnlContext) {
                ognlContext = (OgnlContext)context;
            }
            return node.isOperation(ognlContext);
        }
        return false;
    }

    private boolean isSimpleMethod(Object tree, Map<String, Object> context) throws OgnlException {
        if (tree instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)tree;
            OgnlContext ognlContext = null;
            if (context != null && context instanceof OgnlContext) {
                ognlContext = (OgnlContext)context;
            }
            return node.isSimpleMethod(ognlContext) && !node.isChain(ognlContext);
        }
        return false;
    }

    public Object getValue(String name, final Map<String, Object> context, final Object root) throws OgnlException {
        return this.compileAndExecute(name, context, new OgnlTask<Object>(){

            @Override
            public Object execute(Object tree) throws OgnlException {
                return Ognl.getValue((Object)tree, (Map)context, (Object)root);
            }
        });
    }

    public Object callMethod(String name, final Map<String, Object> context, final Object root) throws OgnlException {
        return this.compileAndExecuteMethod(name, context, new OgnlTask<Object>(){

            @Override
            public Object execute(Object tree) throws OgnlException {
                return Ognl.getValue((Object)tree, (Map)context, (Object)root);
            }
        });
    }

    public Object getValue(String name, final Map<String, Object> context, final Object root, final Class resultType) throws OgnlException {
        return this.compileAndExecute(name, context, new OgnlTask<Object>(){

            @Override
            public Object execute(Object tree) throws OgnlException {
                return Ognl.getValue((Object)tree, (Map)context, (Object)root, (Class)resultType);
            }
        });
    }

    public Object compile(String expression) throws OgnlException {
        return this.compile(expression, null);
    }

    private <T> Object compileAndExecute(String expression, Map<String, Object> context, OgnlTask<T> task) throws OgnlException {
        Object tree;
        if (this.enableExpressionCache) {
            tree = this.expressions.get(expression);
            if (tree == null) {
                tree = Ognl.parseExpression((String)expression);
                this.checkEnableEvalExpression(tree, context);
            }
        } else {
            tree = Ognl.parseExpression((String)expression);
            this.checkEnableEvalExpression(tree, context);
        }
        T exec = task.execute(tree);
        if (this.enableExpressionCache) {
            this.expressions.putIfAbsent(expression, tree);
        }
        return exec;
    }

    private <T> Object compileAndExecuteMethod(String expression, Map<String, Object> context, OgnlTask<T> task) throws OgnlException {
        Object tree;
        if (this.enableExpressionCache) {
            tree = this.expressions.get(expression);
            if (tree == null) {
                tree = Ognl.parseExpression((String)expression);
                this.checkSimpleMethod(tree, context);
            }
        } else {
            tree = Ognl.parseExpression((String)expression);
            this.checkSimpleMethod(tree, context);
        }
        T exec = task.execute(tree);
        if (this.enableExpressionCache) {
            this.expressions.putIfAbsent(expression, tree);
        }
        return exec;
    }

    public Object compile(String expression, Map<String, Object> context) throws OgnlException {
        return this.compileAndExecute(expression, context, new OgnlTask<Object>(){

            @Override
            public Object execute(Object tree) throws OgnlException {
                return tree;
            }
        });
    }

    private void checkEnableEvalExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (!this.enableEvalExpression && this.isEvalExpression(tree, context)) {
            throw new OgnlException("Eval expressions/chained expressions have been disabled!");
        }
    }

    private void checkSimpleMethod(Object tree, Map<String, Object> context) throws OgnlException {
        if (!this.isSimpleMethod(tree, context)) {
            throw new OgnlException("It isn't a simple method which can be called!");
        }
    }

    public void copy(Object from, Object to, Map<String, Object> context, Collection<String> exclusions, Collection<String> inclusions) {
        this.copy(from, to, context, exclusions, inclusions, null);
    }

    public void copy(final Object from, final Object to, Map<String, Object> context, Collection<String> exclusions, Collection<String> inclusions, Class<?> editable) {
        PropertyDescriptor[] toPds;
        PropertyDescriptor[] fromPds;
        if (from == null || to == null) {
            LOG.warn("Attempting to copy from or to a null source. This is illegal and is bein skipped. This may be due to an error in an OGNL expression, action chaining, or some other event.");
            return;
        }
        TypeConverter converter = this.getTypeConverterFromContext(context);
        final Map contextFrom = this.createDefaultContext(from, null);
        Ognl.setTypeConverter((Map)contextFrom, (TypeConverter)converter);
        final Map contextTo = this.createDefaultContext(to, null);
        Ognl.setTypeConverter((Map)contextTo, (TypeConverter)converter);
        try {
            fromPds = this.getPropertyDescriptors(from);
            toPds = editable != null ? this.getPropertyDescriptors(editable) : this.getPropertyDescriptors(to);
        }
        catch (IntrospectionException e) {
            LOG.error("An error occurred", (Throwable)e);
            return;
        }
        HashMap<String, PropertyDescriptor> toPdHash = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor toPd : toPds) {
            toPdHash.put(toPd.getName(), toPd);
        }
        for (PropertyDescriptor fromPd : fromPds) {
            PropertyDescriptor toPd;
            if (fromPd.getReadMethod() == null) continue;
            boolean copy = true;
            if (exclusions != null && exclusions.contains(fromPd.getName())) {
                copy = false;
            } else if (inclusions != null && !inclusions.contains(fromPd.getName())) {
                copy = false;
            }
            if (!copy || (toPd = (PropertyDescriptor)toPdHash.get(fromPd.getName())) == null || toPd.getWriteMethod() == null) continue;
            try {
                this.compileAndExecute(fromPd.getName(), context, new OgnlTask<Object>(){

                    @Override
                    public Void execute(Object expr) throws OgnlException {
                        Object value = Ognl.getValue((Object)expr, (Map)contextFrom, (Object)from);
                        Ognl.setValue((Object)expr, (Map)contextTo, (Object)to, (Object)value);
                        return null;
                    }
                });
            }
            catch (OgnlException e) {
                LOG.debug("Got OGNL exception", (Throwable)e);
            }
        }
    }

    public void copy(Object from, Object to, Map<String, Object> context) {
        this.copy(from, to, context, null, null);
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object source) throws IntrospectionException {
        BeanInfo beanInfo = this.getBeanInfo(source);
        return beanInfo.getPropertyDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class clazz) throws IntrospectionException {
        BeanInfo beanInfo = this.getBeanInfo(clazz);
        return beanInfo.getPropertyDescriptors();
    }

    public Map<String, Object> getBeanMap(final Object source) throws IntrospectionException, OgnlException {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, Object> beanMap = new HashMap<String, Object>();
        final Map sourceMap = this.createDefaultContext(source, null);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = this.getPropertyDescriptors(source)) {
            String propertyName = propertyDescriptor.getDisplayName();
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod != null) {
                Object value = this.compileAndExecute(propertyName, null, new OgnlTask<Object>(){

                    @Override
                    public Object execute(Object expr) throws OgnlException {
                        return Ognl.getValue((Object)expr, (Map)sourceMap, (Object)source);
                    }
                });
                beanMap.put(propertyName, value);
                continue;
            }
            beanMap.put(propertyName, "There is no read method for " + propertyName);
        }
        return beanMap;
    }

    public BeanInfo getBeanInfo(Object from) throws IntrospectionException {
        return this.getBeanInfo(from.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
        ConcurrentMap<Class, BeanInfo> concurrentMap = this.beanInfoCache;
        synchronized (concurrentMap) {
            BeanInfo beanInfo = (BeanInfo)this.beanInfoCache.get(clazz);
            if (beanInfo == null) {
                beanInfo = Introspector.getBeanInfo(clazz, Object.class);
                this.beanInfoCache.putIfAbsent(clazz, beanInfo);
            }
            return beanInfo;
        }
    }

    void internalSetProperty(String name, Object value, Object o, Map<String, Object> context, boolean throwPropertyExceptions) throws ReflectionException {
        block3: {
            try {
                this.setValue(name, context, o, value);
            }
            catch (OgnlException e) {
                Throwable exception;
                Throwable reason = e.getReason();
                String msg = "Caught OgnlException while setting property '" + name + "' on type '" + o.getClass().getName() + "'.";
                Throwable throwable = exception = reason == null ? e : reason;
                if (throwPropertyExceptions) {
                    throw new ReflectionException(msg, exception);
                }
                if (!this.devMode) break block3;
                LOG.warn(msg, exception);
            }
        }
    }

    TypeConverter getTypeConverterFromContext(Map<String, Object> context) {
        return this.defaultConverter;
    }

    protected Map createDefaultContext(Object root) {
        return this.createDefaultContext(root, null);
    }

    protected Map createDefaultContext(Object root, ClassResolver classResolver) {
        ClassResolver resolver = classResolver;
        if (resolver == null) {
            resolver = this.container.getInstance(CompoundRootAccessor.class);
        }
        SecurityMemberAccess memberAccess = new SecurityMemberAccess(this.allowStaticMethodAccess);
        memberAccess.setExcludedClasses(this.excludedClasses);
        memberAccess.setExcludedPackageNamePatterns(this.excludedPackageNamePatterns);
        memberAccess.setExcludedPackageNames(this.excludedPackageNames);
        memberAccess.setDisallowProxyMemberAccess(this.disallowProxyMemberAccess);
        return Ognl.createDefaultContext((Object)root, (ClassResolver)resolver, (TypeConverter)this.defaultConverter, (MemberAccess)memberAccess);
    }

    private static interface OgnlTask<T> {
        public T execute(Object var1) throws OgnlException;
    }
}

