/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.osgi.host;

import com.opensymphony.xwork2.config.ConfigurationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.felix.framework.Felix;
import org.apache.felix.main.AutoProcessor;
import org.apache.felix.main.Main;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.osgi.host.BaseOsgiHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FelixOsgiHost
extends BaseOsgiHost {
    private static final Logger LOG = LogManager.getLogger(FelixOsgiHost.class);
    protected Felix felix;

    protected void startFelix() {
        Properties configProps = this.getProperties("default.properties");
        Main.copySystemProperties((Properties)configProps);
        this.replaceSystemPackages(configProps);
        Properties strutsConfigProps = this.getProperties("struts-osgi.properties");
        this.addExportedPackages(strutsConfigProps, configProps);
        this.addAutoStartBundles(configProps);
        String storageDir = System.getProperty("java.io.tmpdir") + ".felix-cache";
        configProps.setProperty("org.osgi.framework.storage", storageDir);
        LOG.debug("Storing bundles at [{}]", (Object)storageDir);
        String cleanBundleCache = this.getServletContextParam("struts.osgi.clearBundleCache", "true");
        if ("true".equalsIgnoreCase(cleanBundleCache)) {
            LOG.debug("Clearing bundle cache");
            configProps.put("org.osgi.framework.storage.clean", "onFirstInit");
        }
        configProps.put("felix.service.urlhandlers", "false");
        configProps.put("felix.log.level", this.getServletContextParam("struts.osgi.logLevel", "1"));
        configProps.put("Bundle-ClassPath", ".");
        configProps.put("org.osgi.framework.startlevel.beginning", this.getServletContextParam("struts.osgi.runLevel", "3"));
        try {
            this.felix = new Felix((Map)configProps);
            this.felix.init();
            AutoProcessor.process((Map)configProps, (BundleContext)this.felix.getBundleContext());
            this.felix.start();
            LOG.trace("Apache Felix is running");
        }
        catch (Exception ex) {
            throw new ConfigurationException("Couldn't start Apache Felix", (Throwable)ex);
        }
        this.addSpringOSGiSupport();
        this.servletContext.setAttribute("__struts_osgi_bundle_context", (Object)this.felix.getBundleContext());
    }

    @Override
    public void init(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.startFelix();
    }

    @Override
    public Map<String, Bundle> getBundles() {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.felix.getBundleContext().getBundles()) {
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public Map<String, Bundle> getActiveBundles() {
        HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
        for (Bundle bundle : this.felix.getBundleContext().getBundles()) {
            if (bundle.getState() != 32) continue;
            bundles.put(bundle.getSymbolicName(), bundle);
        }
        return Collections.unmodifiableMap(bundles);
    }

    @Override
    public BundleContext getBundleContext() {
        return this.felix.getBundleContext();
    }

    @Override
    public void destroy() throws Exception {
        this.felix.stop();
        LOG.trace("Apache Felix has stopped");
    }

    @Override
    protected void addSpringOSGiSupport() {
        try {
            Class<?> clazz = Class.forName("org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext");
            String key = (String)clazz.getDeclaredField("BUNDLE_CONTEXT_ATTRIBUTE").get(null);
            this.servletContext.setAttribute(key, (Object)this.felix.getBundleContext());
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Spring OSGi support is not enabled");
            }
        }
        catch (Exception e) {
            LOG.error("The API of Spring OSGi has changed and the field [{}] is no longer available. The OSGi plugin needs to be updated", (Object)"org.springframework.osgi.web.context.support.OsgiBundleXmlWebApplicationContext.BUNDLE_CONTEXT_ATTRIBUTE", (Object)e);
        }
    }
}

