/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.base;

import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.Node;
import com.google.gxp.compiler.base.OutputLanguageVisitor;
import com.google.gxp.compiler.codegen.OutputLanguageUtil;
import com.google.gxp.compiler.cpp.CppUtil;
import com.google.gxp.compiler.java.JavaUtil;
import com.google.gxp.compiler.js.JavaScriptUtil;

public enum OutputLanguage {
    CPP("C++", ".cc", CppUtil.INSTANCE){

        @Override
        public <K, V> V acceptVisitor(OutputLanguageVisitor<K, V> visitor, K arg) {
            return visitor.visitCpp(arg);
        }
    }
    ,
    CPP_HEADER("C++ header", ".h", CppUtil.INSTANCE){

        @Override
        public <K, V> V acceptVisitor(OutputLanguageVisitor<K, V> visitor, K arg) {
            return visitor.visitCppHeader(arg);
        }
    }
    ,
    JAVA("Java", ".java", JavaUtil.INSTANCE){

        @Override
        public <K, V> V acceptVisitor(OutputLanguageVisitor<K, V> visitor, K arg) {
            return visitor.visitJava(arg);
        }
    }
    ,
    DYNAMIC_IMPL_JAVA("Dynamic Java", "$Impl%d.java", JavaUtil.INSTANCE){

        @Override
        public <K, V> V acceptVisitor(OutputLanguageVisitor<K, V> visitor, K arg) {
            return visitor.visitDynamicImplJava(arg);
        }
    }
    ,
    JAVASCRIPT("JavaScript", ".js", JavaScriptUtil.INSTANCE){

        @Override
        public <K, V> V acceptVisitor(OutputLanguageVisitor<K, V> visitor, K arg) {
            return visitor.visitJavaScript(arg);
        }
    }
    ,
    XMB("Xmb", ".xmb", null){

        @Override
        public <K, V> V acceptVisitor(OutputLanguageVisitor<K, V> visitor, K arg) {
            return visitor.visitXmb(arg);
        }
    };

    private final String display;
    private final String suffix;
    private final boolean suffixIncludesVersion;
    private final OutputLanguageUtil outputLanguageUtil;

    private OutputLanguage(String display, String suffix, OutputLanguageUtil outputLanguageUtil) {
        this.display = display;
        this.suffix = suffix;
        this.suffixIncludesVersion = suffix.contains("%d");
        this.outputLanguageUtil = outputLanguageUtil;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean suffixIncludesVersion() {
        return this.suffixIncludesVersion;
    }

    public String validateExpression(AlertSink alertSink, NativeExpression expr) {
        return this.outputLanguageUtil.validateExpression(alertSink, expr, this);
    }

    public String validateName(AlertSink alertSink, Node node, String name) {
        return this.outputLanguageUtil.validateName(alertSink, node, name, this);
    }

    public String toStringLiteral(String s) {
        return this.outputLanguageUtil.toStringLiteral(s);
    }

    public abstract <K, V> V acceptVisitor(OutputLanguageVisitor<K, V> var1, K var2);
}

