/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.sf.oval.Check;
import net.sf.oval.context.OValContext;
import net.sf.oval.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintViolation
implements Serializable {
    private static final Log LOG = Log.getLog(ConstraintViolation.class);
    private static final long serialVersionUID = 1L;
    private final String checkName;
    private final ConstraintViolation[] causes;
    private final OValContext context;
    private final String errorCode;
    private final String message;
    private final String messageTemplate;
    private final Map<String, String> messageVariables;
    private final int severity;
    private transient Object validatedObject;
    private transient Object invalidValue;

    public ConstraintViolation(Check check, String message, Object validatedObject, Object invalidValue, OValContext context) {
        this(check, message, validatedObject, invalidValue, context, (ConstraintViolation[])null);
    }

    public ConstraintViolation(Check check, String message, Object validatedObject, Object invalidValue, OValContext context, ConstraintViolation ... causes) {
        this.checkName = check.getClass().getName();
        this.errorCode = check.getErrorCode();
        this.message = message;
        this.messageTemplate = check.getMessage();
        this.messageVariables = check.getMessageVariables();
        this.severity = check.getSeverity();
        this.validatedObject = validatedObject;
        this.invalidValue = invalidValue;
        this.context = context;
        this.causes = causes != null && causes.length == 0 ? null : causes;
    }

    public ConstraintViolation(Check check, String message, Object validatedObject, Object invalidValue, OValContext context, List<ConstraintViolation> causes) {
        this.checkName = check.getClass().getName();
        this.errorCode = check.getErrorCode();
        this.message = message;
        this.messageTemplate = check.getMessage();
        this.messageVariables = check.getMessageVariables();
        this.severity = check.getSeverity();
        this.validatedObject = validatedObject;
        this.invalidValue = invalidValue;
        this.context = context;
        this.causes = causes == null || causes.size() == 0 ? null : causes.toArray(new ConstraintViolation[causes.size()]);
    }

    public ConstraintViolation[] getCauses() {
        return this.causes == null ? null : (ConstraintViolation[])this.causes.clone();
    }

    public String getCheckName() {
        return this.checkName;
    }

    public OValContext getContext() {
        return this.context;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Object getInvalidValue() {
        return this.invalidValue;
    }

    public String getMessage() {
        return this.message;
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public Map<String, String> getMessageVariables() {
        return this.messageVariables;
    }

    public int getSeverity() {
        return this.severity;
    }

    public Object getValidatedObject() {
        return this.validatedObject;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (in.readBoolean()) {
            this.validatedObject = in.readObject();
        }
        if (in.readBoolean()) {
            this.invalidValue = in.readObject();
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.message;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.validatedObject instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.validatedObject);
        } else {
            LOG.warn("Field 'validatedObject' not serialized because the field value object " + this.validatedObject + " of type " + this.invalidValue.getClass() + " does not implement " + Serializable.class.getName());
            out.writeBoolean(false);
        }
        if (this.invalidValue instanceof Serializable) {
            out.writeBoolean(true);
            out.writeObject(this.invalidValue);
        } else {
            LOG.warn("Field 'invalidValue' could not be serialized because the field value object {1} does not implement java.io.Serializable.", this.invalidValue);
            out.writeBoolean(false);
        }
    }
}

