/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor.annotations;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.PreResultListener;
import com.opensymphony.xwork2.interceptor.annotations.After;
import com.opensymphony.xwork2.interceptor.annotations.Before;
import com.opensymphony.xwork2.interceptor.annotations.BeforeResult;
import com.opensymphony.xwork2.util.AnnotationUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class AnnotationWorkflowInterceptor
extends AbstractInterceptor
implements PreResultListener {
    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        invocation.addPreResultListener(this);
        ArrayList<Method> methods = new ArrayList<Method>(AnnotationUtils.getAnnotatedMethods(action.getClass(), Before.class));
        if (methods.size() > 0) {
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method method1, Method method2) {
                    return AnnotationWorkflowInterceptor.comparePriorities(method1.getAnnotation(Before.class).priority(), method2.getAnnotation(Before.class).priority());
                }
            });
            for (Method m : methods) {
                String resultCode = (String)m.invoke(action, (Object[])null);
                if (resultCode == null) continue;
                return resultCode;
            }
        }
        String invocationResult = invocation.invoke();
        methods = new ArrayList<Method>(AnnotationUtils.getAnnotatedMethods(action.getClass(), After.class));
        if (methods.size() > 0) {
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method method1, Method method2) {
                    return AnnotationWorkflowInterceptor.comparePriorities(method1.getAnnotation(After.class).priority(), method2.getAnnotation(After.class).priority());
                }
            });
            for (Method m : methods) {
                m.invoke(action, (Object[])null);
            }
        }
        return invocationResult;
    }

    protected static int comparePriorities(int val1, int val2) {
        if (val2 < val1) {
            return -1;
        }
        if (val2 > val1) {
            return 1;
        }
        return 0;
    }

    @Override
    public void beforeResult(ActionInvocation invocation, String resultCode) {
        Object action = invocation.getAction();
        ArrayList<Method> methods = new ArrayList<Method>(AnnotationUtils.getAnnotatedMethods(action.getClass(), BeforeResult.class));
        if (methods.size() > 0) {
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method method1, Method method2) {
                    return AnnotationWorkflowInterceptor.comparePriorities(method1.getAnnotation(BeforeResult.class).priority(), method2.getAnnotation(BeforeResult.class).priority());
                }
            });
            for (Method m : methods) {
                try {
                    m.invoke(action, (Object[])null);
                }
                catch (Exception e) {
                    throw new XWorkException(e);
                }
            }
        }
    }
}

