/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.mapper;

import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;

public class CompositeActionMapper
implements ActionMapper {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeActionMapper.class);
    protected List<ActionMapper> actionMappers = new LinkedList<ActionMapper>();

    @Inject
    public CompositeActionMapper(Container container, @Inject(value="struts.mapper.composite") String list) {
        if (list != null) {
            String[] arr;
            for (String name : arr = list.split(",")) {
                Object obj = container.getInstance(ActionMapper.class, name);
                if (obj == null) continue;
                this.actionMappers.add((ActionMapper)obj);
            }
        }
    }

    @Override
    public ActionMapping getMapping(HttpServletRequest request, ConfigurationManager configManager) {
        for (ActionMapper actionMapper : this.actionMappers) {
            ActionMapping actionMapping = actionMapper.getMapping(request, configManager);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using ActionMapper " + actionMapper, new String[0]);
            }
            if (actionMapping == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("ActionMapper " + actionMapper + " failed to return an ActionMapping (null)", new String[0]);
                continue;
            }
            return actionMapping;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("exhausted from ActionMapper that could return an ActionMapping", new String[0]);
        }
        return null;
    }

    @Override
    public ActionMapping getMappingFromActionName(String actionName) {
        for (ActionMapper actionMapper : this.actionMappers) {
            ActionMapping actionMapping = actionMapper.getMappingFromActionName(actionName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using ActionMapper " + actionMapper, new String[0]);
            }
            if (actionMapping == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("ActionMapper " + actionMapper + " failed to return an ActionMapping (null)", new String[0]);
                continue;
            }
            return actionMapping;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("exhausted from ActionMapper that could return an ActionMapping", new String[0]);
        }
        return null;
    }

    @Override
    public String getUriFromActionMapping(ActionMapping mapping) {
        for (ActionMapper actionMapper : this.actionMappers) {
            String uri = actionMapper.getUriFromActionMapping(mapping);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using ActionMapper " + actionMapper, new String[0]);
            }
            if (uri == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("ActionMapper " + actionMapper + " failed to return an ActionMapping (null)", new String[0]);
                continue;
            }
            return uri;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("exhausted from ActionMapper that could return a uri", new String[0]);
        }
        return null;
    }
}

