/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashMap;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.rest.ContentTypeHandlerManager;
import org.apache.struts2.rest.DefaultHttpHeaders;

public class RestWorkflowInterceptor
extends MethodFilterInterceptor {
    private static final long serialVersionUID = 7563014655616490865L;
    private static final Logger LOG = LoggerFactory.getLogger(RestWorkflowInterceptor.class);
    private String inputResultName = "input";
    private ContentTypeHandlerManager manager;
    private String postMethodName = "create";
    private String editMethodName = "edit";
    private String newMethodName = "editNew";
    private String putMethodName = "update";
    private int validationFailureStatusCode = 400;

    @Inject(required=false, value="struts.mapper.postMethodName")
    public void setPostMethodName(String postMethodName) {
        this.postMethodName = postMethodName;
    }

    @Inject(required=false, value="struts.mapper.editMethodName")
    public void setEditMethodName(String editMethodName) {
        this.editMethodName = editMethodName;
    }

    @Inject(required=false, value="struts.mapper.newMethodName")
    public void setNewMethodName(String newMethodName) {
        this.newMethodName = newMethodName;
    }

    @Inject(required=false, value="struts.mapper.putMethodName")
    public void setPutMethodName(String putMethodName) {
        this.putMethodName = putMethodName;
    }

    @Inject(required=false, value="struts.rest.validationFailureStatusCode")
    public void setValidationFailureStatusCode(String code) {
        this.validationFailureStatusCode = Integer.parseInt(code);
    }

    @Inject
    public void setContentTypeHandlerManager(ContentTypeHandlerManager mgr) {
        this.manager = mgr;
    }

    public void setInputResultName(String inputResultName) {
        this.inputResultName = inputResultName;
    }

    protected String doIntercept(ActionInvocation invocation) throws Exception {
        ValidationAware validationAwareAction;
        Object action = invocation.getAction();
        if (action instanceof ValidationAware && (validationAwareAction = (ValidationAware)action).hasErrors()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Errors on action " + validationAwareAction + ", returning result name 'input'", new String[0]);
            }
            ActionMapping mapping = (ActionMapping)ActionContext.getContext().get("struts.actionMapping");
            String method = this.inputResultName;
            if (this.postMethodName.equals(mapping.getMethod())) {
                method = this.newMethodName;
            } else if (this.putMethodName.equals(mapping.getMethod())) {
                method = this.editMethodName;
            }
            DefaultHttpHeaders info = new DefaultHttpHeaders().disableCaching().renderResult(method).withStatus(this.validationFailureStatusCode);
            HashMap<String, Object> errors = new HashMap<String, Object>();
            errors.put("actionErrors", validationAwareAction.getActionErrors());
            errors.put("fieldErrors", validationAwareAction.getFieldErrors());
            return this.manager.handleResult(invocation, (Object)info, errors);
        }
        return invocation.invoke();
    }
}

