/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.portlet.result;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.portlet.ActionResponse;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.StrutsResultSupport;
import org.apache.struts2.portlet.PortletConstants;
import org.apache.struts2.portlet.PortletPhase;
import org.apache.struts2.portlet.context.PortletActionContext;
import org.apache.struts2.views.JspSupportServlet;
import org.apache.struts2.views.velocity.VelocityManager;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class PortletVelocityResult
extends StrutsResultSupport {
    private static final long serialVersionUID = -8241086555872212274L;
    private static final Logger LOG = LoggerFactory.getLogger(PortletVelocityResult.class);
    private String defaultEncoding;
    private VelocityManager velocityManager;
    private JspFactory jspFactory = JspFactory.getDefaultFactory();

    public PortletVelocityResult() {
    }

    public PortletVelocityResult(String location) {
        super(location);
    }

    @Inject
    public void setVelocityManager(VelocityManager mgr) {
        this.velocityManager = mgr;
    }

    @Inject(value="struts.i18n.encoding")
    public void setDefaultEncoding(String encoding) {
        this.defaultEncoding = encoding;
    }

    public void doExecute(String location, ActionInvocation invocation) throws Exception {
        PortletPhase phase = PortletActionContext.getPhase();
        if (phase.isAction()) {
            this.executeActionResult(location, invocation);
        } else if (phase.isRender()) {
            this.executeRenderResult(location, invocation);
        }
    }

    private void executeActionResult(String location, ActionInvocation invocation) {
        ActionResponse res = PortletActionContext.getActionResponse();
        res.setRenderParameter(PortletConstants.ACTION_PARAM, "freemarkerDirect");
        res.setRenderParameter("location", location);
        res.setRenderParameter(PortletConstants.MODE_PARAM, PortletActionContext.getRequest().getPortletMode().toString());
    }

    public void executeRenderResult(String finalLocation, ActionInvocation invocation) throws Exception {
        ValueStack stack = ActionContext.getContext().getValueStack();
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        ServletContext servletContext = ServletActionContext.getServletContext();
        JspSupportServlet servlet = JspSupportServlet.jspSupportServlet;
        this.velocityManager.init(servletContext);
        boolean usedJspFactory = false;
        PageContext pageContext = (PageContext)ActionContext.getContext().get("com.opensymphony.xwork2.dispatcher.PageContext");
        if (pageContext == null && servlet != null) {
            pageContext = this.jspFactory.getPageContext((Servlet)servlet, (ServletRequest)request, (ServletResponse)response, null, true, 8192, true);
            ActionContext.getContext().put("com.opensymphony.xwork2.dispatcher.PageContext", (Object)pageContext);
            usedJspFactory = true;
        }
        try {
            String encoding = this.getEncoding(finalLocation);
            String contentType = this.getContentType(finalLocation);
            if (encoding != null) {
                contentType = contentType + ";charset=" + encoding;
            }
            response.setContentType(contentType);
            Template t = this.getTemplate(stack, this.velocityManager.getVelocityEngine(), invocation, finalLocation, encoding);
            Context context = this.createContext(this.velocityManager, stack, request, response, finalLocation);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)response.getOutputStream(), encoding);
            t.merge(context, (Writer)writer);
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            LOG.error("Unable to render Velocity Template, '" + finalLocation + "'", (Throwable)e, new String[0]);
            throw e;
        }
        finally {
            if (usedJspFactory) {
                this.jspFactory.releasePageContext(pageContext);
            }
        }
    }

    protected String getContentType(String templateLocation) {
        return "text/html";
    }

    protected String getEncoding(String templateLocation) {
        String encoding = this.defaultEncoding;
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        return encoding;
    }

    protected Template getTemplate(ValueStack stack, VelocityEngine velocity, ActionInvocation invocation, String location, String encoding) throws Exception {
        if (!location.startsWith("/")) {
            location = invocation.getProxy().getNamespace() + "/" + location;
        }
        return velocity.getTemplate(location, encoding);
    }

    protected Context createContext(VelocityManager velocityManager, ValueStack stack, HttpServletRequest request, HttpServletResponse response, String location) {
        return velocityManager.createContext(stack, request, response);
    }
}

