/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.localization.message;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.oval.Validator;
import net.sf.oval.localization.message.MessageResolver;

public class ResourceBundleMessageResolver
implements MessageResolver {
    private final Map<ResourceBundle, List<String>> messageBundleKeys = Validator.getCollectionFactory().createMap(8);
    private final LinkedList<ResourceBundle> messageBundles = new LinkedList();
    public static final ResourceBundleMessageResolver INSTANCE = new ResourceBundleMessageResolver();

    public ResourceBundleMessageResolver() {
        this.addMessageBundle(ResourceBundle.getBundle("net/sf/oval/Messages"));
    }

    public final boolean addMessageBundle(ResourceBundle messageBundle) {
        if (this.messageBundles.contains(messageBundle)) {
            return false;
        }
        this.messageBundles.addFirst(messageBundle);
        List keys = Validator.getCollectionFactory().createList();
        Enumeration<String> keysEnum = messageBundle.getKeys();
        while (keysEnum.hasMoreElements()) {
            keys.add(keysEnum.nextElement());
        }
        this.messageBundleKeys.put(messageBundle, keys);
        return true;
    }

    public String getMessage(String key) {
        for (ResourceBundle bundle : this.messageBundles) {
            List<String> keys = this.messageBundleKeys.get(bundle);
            if (!keys.contains(key)) continue;
            return bundle.getString(key);
        }
        return null;
    }

    public boolean removeMessageBundle(ResourceBundle messageBundle) {
        if (!this.messageBundles.contains(messageBundle)) {
            return false;
        }
        this.messageBundles.remove(messageBundle);
        return true;
    }
}

