/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.ArrayList;
import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.internal.Log;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageJRubyImpl
implements ExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageJRubyImpl.class);

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        try {
            Ruby runtime = JavaEmbedUtils.initialize(new ArrayList());
            StringBuilder localVars = new StringBuilder();
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                runtime.getGlobalVariables().set("$" + entry.getKey(), JavaEmbedUtils.javaToRuby((Ruby)runtime, entry.getValue()));
                localVars.append(entry.getKey());
                localVars.append("=$");
                localVars.append(entry.getKey());
                localVars.append("\n");
            }
            LOG.debug("Evaluating Ruby expression: {1}", expression);
            IRubyObject result = runtime.evalScriptlet(localVars + expression);
            return JavaEmbedUtils.rubyToJava((Ruby)runtime, (IRubyObject)result, Object.class);
        }
        catch (RuntimeException ex) {
            ex.printStackTrace(System.out);
            throw new ExpressionEvaluationException("Evaluating script with JRuby failed.", ex);
        }
    }

    @Override
    public boolean evaluateAsBoolean(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        Object result = this.evaluate(expression, values);
        if (!(result instanceof Boolean)) {
            throw new ExpressionEvaluationException("The script must return a boolean value.");
        }
        return (Boolean)result;
    }
}

