/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.NotNegative;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotNegativeCheck
extends AbstractAnnotationCheck<NotNegative> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Number) {
            if (valueToValidate instanceof Float || valueToValidate instanceof Double) {
                return ((Number)valueToValidate).doubleValue() >= 0.0;
            }
            return ((Number)valueToValidate).longValue() >= 0L;
        }
        String stringValue = valueToValidate.toString();
        try {
            return Double.parseDouble(stringValue) >= 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

