/*
 * Decompiled with CFR 0.152.
 */
package com.sampullara.mustache;

import com.sampullara.mustache.Mustache;
import com.sampullara.mustache.MustacheException;
import com.sampullara.mustache.ObjectHandler;
import com.sampullara.mustache.ObjectHandler6;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.MappingJsonFactory;

public class Scope
extends HashMap<Object, Object> {
    public static final Iterable<Scope> EMPTY = new ArrayList<Scope>(0);
    public static final Object NULL = new Object(){

        public String toString() {
            return "";
        }
    };
    private Object parent;
    private Scope parentScope;
    private static Logger logger = Logger.getLogger(Mustache.class.getName());
    private static ObjectHandler defaultHandleObject;
    private ObjectHandler handleObject = defaultHandleObject;
    private static final ConcurrentMap<String, Average> profile;

    public Scope() {
    }

    public Scope(Object parent) {
        if (parent instanceof Scope) {
            this.parentScope = (Scope)parent;
        } else {
            this.parent = parent;
        }
    }

    public Scope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    public Scope(Object parent, Scope parentScope) {
        this.parentScope = parentScope;
        this.parent = parent;
    }

    public void setHandleObject(ObjectHandler handleObject) {
        this.handleObject = handleObject;
    }

    public Scope getParentScope() {
        return this.parentScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object o) {
        Object object;
        block4: {
            long start = 0L;
            if (Mustache.profile) {
                start = System.nanoTime();
            }
            try {
                object = this.get(o, this);
                if (!Mustache.profile) break block4;
            }
            catch (Throwable throwable) {
                if (Mustache.profile) {
                    long diff = System.nanoTime() - start;
                    Average newaverage = new Average();
                    Average average = profile.putIfAbsent(o.toString(), newaverage);
                    (average == null ? newaverage : average).increment(diff);
                }
                throw throwable;
            }
            long diff = System.nanoTime() - start;
            Average newaverage = new Average();
            Average average = profile.putIfAbsent(o.toString(), newaverage);
            (average == null ? newaverage : average).increment(diff);
        }
        return object;
    }

    public Object get(Object o, Scope scope) {
        String name = o.toString();
        Object value = null;
        Iterable<String> components = Scope.split(name, ".");
        Scope current = this;
        Scope currentScope = scope;
        if (components == null) {
            value = current.localGet(currentScope, name);
            if (value == null || value == NULL) {
                return null;
            }
        } else {
            for (String component : components) {
                value = current.localGet(currentScope, component);
                if (value == null || value == NULL) {
                    return null;
                }
                currentScope = current;
                current = new Scope(value);
            }
        }
        return value;
    }

    public static void report() {
        ArrayList entries = new ArrayList(profile.entrySet());
        if (entries.size() > 0) {
            logger.info("Top 10 Average");
            Collections.sort(entries, new Comparator<Map.Entry<String, Average>>(){

                @Override
                public int compare(Map.Entry<String, Average> o1, Map.Entry<String, Average> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            for (Map.Entry entry : entries.subList(0, Math.min(entries.size() - 1, 10))) {
                logger.info((String)entry.getKey() + ": " + ((Average)entry.getValue()).average() + " (" + ((Average)entry.getValue()).total + " / " + ((Average)entry.getValue()).num + ")");
            }
            logger.info("Top 10 Total");
            Collections.sort(entries, new Comparator<Map.Entry<String, Average>>(){

                @Override
                public int compare(Map.Entry<String, Average> o1, Map.Entry<String, Average> o2) {
                    long l = o2.getValue().total.longValue() - o1.getValue().total.longValue();
                    return l < 0L ? -1 : (l > 0L ? 1 : 0);
                }
            });
            for (Map.Entry entry : entries.subList(0, 10)) {
                logger.info((String)entry.getKey() + ": " + ((Average)entry.getValue()).average() + " (" + ((Average)entry.getValue()).total + " / " + ((Average)entry.getValue()).num + ")");
            }
            profile.clear();
        }
    }

    private Object localGet(Scope scope, String name) {
        Object v = super.get(name);
        if (v == null && this.parent != null) {
            if (this.parent instanceof Future) {
                try {
                    this.parent = ((Future)this.parent).get();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to get value from future", e);
                }
            }
            v = this.parent instanceof Map ? ((Map)this.parent).get(name) : (this.parent instanceof JsonNode ? this.handleJsonNode(name) : this.handleObject.handleObject(this.parent, scope, name));
        }
        if (v == null && this.parentScope != null) {
            v = this.parentScope.get(name, scope);
        }
        return v;
    }

    private Object handleJsonNode(String name) {
        JsonNode jsonNode = (JsonNode)this.parent;
        JsonNode result = jsonNode.get(name);
        if (result == null || result.isNull()) {
            return null;
        }
        Object v = result.isTextual() ? result.getTextValue() : (result.isBoolean() ? Boolean.valueOf(result.getBooleanValue()) : result);
        return v;
    }

    public Object getParent() {
        return this.parent;
    }

    private static Iterable<String> split(final String s, final String d) {
        if (!s.contains(d)) {
            return null;
        }
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int length;
                    int current;
                    {
                        this.length = s.length();
                        this.current = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current < this.length;
                    }

                    @Override
                    public String next() {
                        int start = this.current;
                        int i = s.indexOf(d, start);
                        if (i == -1) {
                            this.current = this.length;
                            return s.substring(start);
                        }
                        this.current = i + d.length();
                        return s.substring(start, i);
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    @Override
    public String toString() {
        return (this.size() == 0 ? "" : super.toString()) + (this.parent == null ? "" : " <- " + this.parent) + (this.parentScope == null ? "" : " <- " + this.parentScope);
    }

    public String toJSON() throws MustacheException {
        StringWriter sw = new StringWriter();
        MappingJsonFactory jf = new MappingJsonFactory();
        try {
            JsonGenerator jg = jf.createJsonGenerator((Writer)sw);
            jg.writeObject((Object)this);
            jg.flush();
        }
        catch (IOException e) {
            throw new MustacheException(e);
        }
        return sw.toString();
    }

    static {
        try {
            Class.forName("java.lang.invoke.MethodHandle");
            defaultHandleObject = (ObjectHandler)Class.forName("com.sampullara.mustache.ObjectHandler7").newInstance();
            logger.info("MethodHandle object handler enabled");
        }
        catch (Exception e) {
            defaultHandleObject = new ObjectHandler6();
            logger.info("Reflection object handler enabled");
        }
        profile = Mustache.profile ? new ConcurrentHashMap() : null;
    }

    private static class Average
    implements Comparable<Average> {
        private AtomicLong total = new AtomicLong(0L);
        private AtomicLong num = new AtomicLong(0L);

        private Average() {
        }

        public void increment(long increase) {
            this.num.incrementAndGet();
            this.total.addAndGet(increase);
        }

        @Override
        public int compareTo(Average other) {
            double l = other.average() - this.average();
            return l < 0.0 ? -1 : (l > 0.0 ? 1 : 0);
        }

        public double average() {
            return this.total.doubleValue() / (double)this.num.longValue();
        }
    }
}

