/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.DefaultActionInvocation;
import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.HttpHeaderResult;
import org.apache.struts2.rest.ContentTypeHandlerManager;
import org.apache.struts2.rest.DefaultHttpHeaders;
import org.apache.struts2.rest.HttpHeaders;
import org.apache.struts2.rest.handler.ContentTypeHandler;
import org.apache.struts2.rest.handler.HtmlHandler;

public class RestActionInvocation
extends DefaultActionInvocation {
    private static final long serialVersionUID = 3485701178946428716L;
    private static final Logger LOG = LoggerFactory.getLogger(RestActionInvocation.class);
    private ContentTypeHandlerManager handlerSelector;
    private boolean logger;
    private String defaultErrorResultName;
    private boolean restrictToGet = true;
    protected HttpHeaders httpHeaders;
    protected Object target;
    protected boolean isFirstInterceptor = true;
    protected boolean hasErrors;

    protected RestActionInvocation(Map<String, Object> extraContext, boolean pushAction) {
        super(extraContext, pushAction);
    }

    @Inject(value="struts.rest.logger")
    public void setLogger(String value) {
        this.logger = Boolean.valueOf(value);
    }

    @Inject(value="struts.rest.defaultErrorResultName")
    public void setDefaultErrorResultName(String value) {
        this.defaultErrorResultName = value;
    }

    @Inject(value="struts.rest.content.restrictToGET", required=false)
    public void setRestrictToGet(String value) {
        this.restrictToGet = "true".equalsIgnoreCase(value);
    }

    @Inject
    public void setMimeTypeHandlerSelector(ContentTypeHandlerManager sel) {
        this.handlerSelector = sel;
    }

    protected String saveResult(ActionConfig actionConfig, Object methodResult) {
        if (methodResult instanceof Result) {
            this.explicitResult = (Result)methodResult;
            this.container.inject((Object)this.explicitResult);
        } else if (methodResult instanceof HttpHeaders) {
            this.httpHeaders = (HttpHeaders)methodResult;
            this.resultCode = this.httpHeaders.getResultCode();
        } else if (methodResult instanceof String) {
            this.resultCode = (String)methodResult;
        } else if (methodResult != null) {
            throw new ConfigurationException("The result type " + methodResult.getClass() + " is not allowed. Use the type String, HttpHeaders or Result.");
        }
        return this.resultCode;
    }

    public String invoke() throws Exception {
        long startTime = 0L;
        boolean executeResult = false;
        if (this.isFirstInterceptor) {
            startTime = System.currentTimeMillis();
            executeResult = true;
            this.isFirstInterceptor = false;
        }
        this.proxy.setExecuteResult(false);
        this.resultCode = super.invoke();
        if (executeResult) {
            long middleTime;
            block5: {
                middleTime = System.currentTimeMillis();
                try {
                    this.processResult();
                }
                catch (ConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error("Exception processing the result.", (Throwable)e, new String[0]);
                    if (ServletActionContext.getResponse().isCommitted()) break block5;
                    ServletActionContext.getResponse().setStatus(500);
                    this.stack.set("exception", (Object)e);
                    this.result = null;
                    this.resultCode = null;
                    this.processResult();
                }
            }
            this.logger(startTime, middleTime);
        }
        return this.resultCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResult() throws Exception {
        String timerKey = "processResult: " + this.getResultCode();
        try {
            UtilTimerStack.push((String)timerKey);
            HttpServletRequest request = ServletActionContext.getRequest();
            HttpServletResponse response = ServletActionContext.getResponse();
            this.selectTarget();
            if (this.httpHeaders == null) {
                this.httpHeaders = new DefaultHttpHeaders(this.resultCode);
            }
            if (!this.hasErrors) {
                this.httpHeaders.apply(request, response, this.target);
            } else {
                this.disableCatching(response);
            }
            if (this.httpHeaders.getStatus() != 304) {
                this.executeResult();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Result not processed because the status code is not modified.", new String[0]);
            }
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    private void executeResult() throws Exception {
        ContentTypeHandler handler = this.handlerSelector.getHandlerForResponse(ServletActionContext.getRequest(), ServletActionContext.getResponse());
        this.result = this.createResult();
        if (this.result instanceof HttpHeaderResult) {
            this.result.execute((ActionInvocation)this);
            this.updateStatusFromResult();
        }
        if (handler != null && !(handler instanceof HtmlHandler)) {
            this.resultCode = this.handlerSelector.handleResult((ActionInvocation)this, (Object)this.httpHeaders, this.target);
        } else {
            this.findResult();
            if (this.result != null) {
                this.result.execute((ActionInvocation)this);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No result returned for action " + this.getAction().getClass().getName() + " at " + this.proxy.getConfig().getLocation(), new String[0]);
            }
        }
    }

    protected void updateStatusFromResult() {
        int status;
        if (this.result instanceof HttpHeaderResult && (status = ((HttpHeaderResult)this.result).getStatus()) != -1) {
            this.httpHeaders.setStatus(status);
        }
    }

    private void findResult() throws Exception {
        ResultConfig resultConfig;
        boolean isHttpHeaderResult = false;
        if (this.result != null && this.result instanceof HttpHeaderResult) {
            this.result = null;
            isHttpHeaderResult = true;
        }
        if (this.result == null && this.resultCode != null && !"none".equals(this.resultCode) && this.unknownHandlerManager.hasUnknownHandlers()) {
            this.result = this.unknownHandlerManager.handleUnknownResult(this.invocationContext, this.proxy.getActionName(), this.proxy.getConfig(), this.resultCode);
        }
        if (this.result == null && this.hasErrors && this.defaultErrorResultName != null && (resultConfig = (ResultConfig)this.proxy.getConfig().getResults().get(this.defaultErrorResultName)) != null) {
            this.result = this.objectFactory.buildResult(resultConfig, this.invocationContext.getContextMap());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found default error result.", new String[0]);
            }
        }
        if (this.result == null && this.resultCode != null && !"none".equals(this.resultCode) && !isHttpHeaderResult) {
            throw new ConfigurationException("No result defined for action " + this.getAction().getClass().getName() + " and result " + this.getResultCode(), (Object)this.proxy.getConfig());
        }
    }

    protected void selectTarget() {
        Throwable e = (Throwable)this.stack.findValue("exception");
        if (e != null) {
            this.target = e;
            this.hasErrors = true;
        } else if (this.action instanceof ValidationAware && ((ValidationAware)this.action).hasErrors()) {
            ValidationAware validationAwareAction = (ValidationAware)this.action;
            HashMap<String, Object> errors = new HashMap<String, Object>();
            if (validationAwareAction.getActionErrors().size() > 0) {
                errors.put("actionErrors", validationAwareAction.getActionErrors());
            }
            if (validationAwareAction.getFieldErrors().size() > 0) {
                errors.put("fieldErrors", validationAwareAction.getFieldErrors());
            }
            this.target = errors;
            this.hasErrors = true;
        } else {
            this.target = this.action instanceof ModelDriven ? ((ModelDriven)this.action).getModel() : this.action;
        }
        if (this.shouldRestrictToGET()) {
            this.target = null;
        }
    }

    private boolean shouldRestrictToGET() {
        return !this.hasErrors && !"get".equalsIgnoreCase(ServletActionContext.getRequest().getMethod()) && this.restrictToGet;
    }

    private void disableCatching(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Last-Modified", 0L);
        response.setHeader("ETag", "-1");
    }

    private void logger(long startTime, long middleTime) {
        if (this.logger && LOG.isInfoEnabled()) {
            long endTime = System.currentTimeMillis();
            long executionTime = middleTime - startTime;
            long processResult = endTime - middleTime;
            long total = endTime - startTime;
            String message = "Executed action [/";
            String namespace = this.getProxy().getNamespace();
            if (namespace != null && namespace.trim().length() > 1) {
                message = message + namespace + "/";
            }
            message = message + this.getProxy().getActionName() + "!" + this.getProxy().getMethod();
            String extension = this.handlerSelector.findExtension(ServletActionContext.getRequest().getRequestURI());
            if (extension != null) {
                message = message + "!" + extension;
            }
            if (this.httpHeaders != null) {
                message = message + "!" + this.httpHeaders.getStatus();
            }
            message = message + "] took " + total + " ms (execution: " + executionTime + " ms, result: " + processResult + " ms)";
            LOG.info(message, new String[0]);
        }
    }
}

