/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.sitegraph;

import com.opensymphony.xwork2.config.ConfigurationManager;
import com.opensymphony.xwork2.config.ContainerProvider;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.struts2.config.DefaultBeanSelectionProvider;
import org.apache.struts2.config.DefaultPropertiesProvider;
import org.apache.struts2.config.PropertiesConfigurationProvider;
import org.apache.struts2.config.StrutsXmlConfigurationProvider;
import org.apache.struts2.sitegraph.entities.FreeMarkerView;
import org.apache.struts2.sitegraph.entities.JspView;
import org.apache.struts2.sitegraph.entities.VelocityView;
import org.apache.struts2.sitegraph.entities.View;

public class StrutsConfigRetriever {
    private static final Logger LOG = LoggerFactory.getLogger(StrutsConfigRetriever.class);
    private static String configDir;
    private static String[] views;
    private static boolean isXWorkStarted;
    private static Map<String, View> viewCache;
    private static ConfigurationManager cm;

    public static Map<String, Map<String, ActionConfig>> getActionConfigs() {
        if (!isXWorkStarted) {
            StrutsConfigRetriever.initXWork();
        }
        return cm.getConfiguration().getRuntimeConfiguration().getActionConfigs();
    }

    private static void initXWork() {
        String configFilePath = configDir + "/struts.xml";
        File configFile = new File(configFilePath);
        try {
            StrutsXmlConfigurationProvider configProvider = new StrutsXmlConfigurationProvider(configFile.getCanonicalPath(), true, null);
            cm = new ConfigurationManager();
            cm.addContainerProvider((ContainerProvider)new DefaultPropertiesProvider());
            cm.addContainerProvider((ContainerProvider)new StrutsXmlConfigurationProvider("struts-default.xml", false, null));
            cm.addContainerProvider((ContainerProvider)configProvider);
            cm.addContainerProvider((ContainerProvider)new PropertiesConfigurationProvider());
            cm.addContainerProvider((ContainerProvider)new DefaultBeanSelectionProvider());
            isXWorkStarted = true;
        }
        catch (IOException e) {
            LOG.error("IOException", (Throwable)e, new String[0]);
        }
    }

    public static Set<String> getNamespaces() {
        Set<String> namespaces = Collections.emptySet();
        Map<String, Map<String, ActionConfig>> allActionConfigs = StrutsConfigRetriever.getActionConfigs();
        if (allActionConfigs != null) {
            namespaces = allActionConfigs.keySet();
        }
        return namespaces;
    }

    public static Set<String> getActionNames(String namespace) {
        Map<String, ActionConfig> actionMappings;
        Set<String> actionNames = Collections.emptySet();
        Map<String, Map<String, ActionConfig>> allActionConfigs = StrutsConfigRetriever.getActionConfigs();
        if (allActionConfigs != null && (actionMappings = allActionConfigs.get(namespace)) != null) {
            actionNames = actionMappings.keySet();
        }
        return actionNames;
    }

    public static ActionConfig getActionConfig(String namespace, String actionName) {
        Map<String, ActionConfig> actionMappings;
        ActionConfig config = null;
        Map<String, Map<String, ActionConfig>> allActionConfigs = StrutsConfigRetriever.getActionConfigs();
        if (allActionConfigs != null && (actionMappings = allActionConfigs.get(namespace)) != null) {
            config = actionMappings.get(actionName);
        }
        return config;
    }

    public static ResultConfig getResultConfig(String namespace, String actionName, String resultName) {
        ResultConfig result = null;
        ActionConfig actionConfig = StrutsConfigRetriever.getActionConfig(namespace, actionName);
        if (actionConfig != null) {
            Map resultMap = actionConfig.getResults();
            result = (ResultConfig)resultMap.get(resultName);
        }
        return result;
    }

    public static File getViewFile(String namespace, String actionName, String resultName) {
        ResultConfig result = StrutsConfigRetriever.getResultConfig(namespace, actionName, resultName);
        String location = (String)result.getParams().get("location");
        for (String viewRoot : views) {
            File viewFile = StrutsConfigRetriever.getViewFileInternal(viewRoot, location, namespace);
            if (viewFile == null) continue;
            return viewFile;
        }
        return null;
    }

    private static File getViewFileInternal(String root, String location, String namespace) {
        StringBuilder filePath = new StringBuilder(root);
        if (!location.startsWith("/")) {
            filePath.append(namespace).append('/');
        }
        filePath.append(location);
        File viewFile = new File(filePath.toString());
        if (viewFile.exists()) {
            return viewFile;
        }
        return null;
    }

    public static View getView(String namespace, String actionName, String resultName, int type) {
        File viewFile;
        String viewId = namespace + "/" + actionName + "/" + resultName;
        View view = viewCache.get(viewId);
        if (view == null && (viewFile = StrutsConfigRetriever.getViewFile(namespace, actionName, resultName)) != null) {
            switch (type) {
                case 0: {
                    view = new JspView(viewFile);
                    break;
                }
                case 2: {
                    view = new FreeMarkerView(viewFile);
                    break;
                }
                case 1: {
                    view = new VelocityView(viewFile);
                    break;
                }
                default: {
                    return null;
                }
            }
            viewCache.put(viewId, view);
        }
        return view;
    }

    public static void setConfiguration(String configDir, String[] views) {
        StrutsConfigRetriever.configDir = configDir;
        StrutsConfigRetriever.views = views;
        isXWorkStarted = false;
    }

    static {
        isXWorkStarted = false;
        viewCache = new LinkedHashMap<String, View>();
    }
}

