/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.java;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.template.BaseTemplateEngine;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateEngine;
import org.apache.struts2.components.template.TemplateEngineManager;
import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.views.java.Theme;
import org.apache.struts2.views.java.simple.SimpleTheme;

public class JavaTemplateEngine
extends BaseTemplateEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JavaTemplateEngine.class);
    protected TemplateEngineManager templateEngineManager;
    private String defaultTemplateType = "ftl";
    private Themes themes = new Themes(){
        {
            this.add(new SimpleTheme());
        }
    };

    @Inject
    public void setTemplateEngineManager(TemplateEngineManager mgr) {
        this.templateEngineManager = mgr;
    }

    protected String getSuffix() {
        return "java";
    }

    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        Template t = templateContext.getTemplate();
        Theme theme = this.themes.get(t.getTheme());
        if (theme == null) {
            TemplateEngine engine;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Theme not found [#0] trying default template engine using template type [#1]", new String[]{t.getTheme(), this.defaultTemplateType});
            }
            if ((engine = this.templateEngineManager.getTemplateEngine(templateContext.getTemplate(), this.defaultTemplateType)) == null) {
                throw new ConfigurationException("Unable to find a TemplateEngine for template type '" + this.defaultTemplateType + "' whilst trying to render template " + templateContext.getTemplate());
            }
            try {
                engine.renderTemplate(templateContext);
            }
            catch (Exception e) {
                throw new StrutsException("Cannot render tag [" + t.getName() + "] because theme [" + t.getTheme() + "] was not found.", (Throwable)e);
            }
        } else {
            theme.renderTag(t.getName(), templateContext);
        }
    }

    @Inject(value="struts.javatemplates.customThemes", required=false)
    public void setThemeClasses(String themeClasses) {
        StringTokenizer customThemes = new StringTokenizer(themeClasses, ",");
        while (customThemes.hasMoreTokens()) {
            String themeClass = customThemes.nextToken().trim();
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Registering custom theme [#0] to javatemplates engine", new String[]{themeClass});
                }
                ObjectFactory factory = (ObjectFactory)ActionContext.getContext().getContainer().getInstance(ObjectFactory.class);
                Theme theme = (Theme)factory.buildBean(themeClass, new HashMap());
                this.themes.add(theme);
            }
            catch (ClassCastException cce) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Invalid java them class [#0]. Class does not implement 'org.apache.struts2.views.java.Theme' interface", (Throwable)cce, new String[]{themeClass});
            }
            catch (ClassNotFoundException cnf) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Invalid java theme class [#0]. Class not found!", (Throwable)cnf, new String[]{themeClass});
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error("Could not find messages file [#0].properties. Skipping!", (Throwable)e, new String[]{themeClass});
            }
        }
    }

    @Inject(value="struts.javatemplates.defaultTemplateType", required=false)
    public void setDefaultTemplateType(String defaultTemplateTheme) {
        if (defaultTemplateTheme != null && !defaultTemplateTheme.equalsIgnoreCase(this.getSuffix())) {
            this.defaultTemplateType = defaultTemplateTheme.toLowerCase();
        } else if (LOG.isErrorEnabled()) {
            LOG.error("Invalid struts.javatemplates.defaultTemplateType value. Cannot be [#0]!", new String[]{this.getSuffix()});
        }
    }

    private static class Themes {
        private HashMap<String, Theme> themes = new HashMap();

        private Themes() {
        }

        public void add(Theme theme) {
            this.themes.put(theme.getName(), theme);
        }

        public Theme get(String name) {
            return this.themes.get(name);
        }
    }
}

