/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.impl;

import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.DefaultActionProxyFactory;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrefixBasedActionProxyFactory
extends DefaultActionProxyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixBasedActionProxyFactory.class);
    private Map<String, ActionProxyFactory> actionProxyFactories = new HashMap<String, ActionProxyFactory>();
    private ActionProxyFactory defaultFactory;

    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="struts.actionProxyFactory")
    public void setActionProxyFactory(ActionProxyFactory factory) {
        this.defaultFactory = factory;
    }

    @Inject(value="struts.mapper.prefixMapping")
    public void setPrefixBasedActionProxyFactories(String list) {
        if (list != null) {
            String[] factories;
            for (String factory : factories = list.split(",")) {
                String[] thisFactory = factory.split(":");
                if (thisFactory == null || thisFactory.length != 2) continue;
                String factoryPrefix = thisFactory[0].trim();
                String factoryName = thisFactory[1].trim();
                ActionProxyFactory obj = (ActionProxyFactory)this.container.getInstance(ActionProxyFactory.class, factoryName);
                if (obj != null) {
                    this.actionProxyFactories.put(factoryPrefix, obj);
                    continue;
                }
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn("Invalid PrefixBasedActionProxyFactory config entry: [#0]", new String[]{factory});
            }
        }
    }

    public ActionProxy createActionProxy(String namespace, String actionName, String methodName, Map<String, Object> extraContext, boolean executeResult, boolean cleanupContext) {
        String uri = namespace + (namespace.endsWith("/") ? actionName : "/" + actionName);
        int lastIndex = uri.lastIndexOf(47);
        while (lastIndex > -1) {
            String key = uri.substring(0, lastIndex);
            ActionProxyFactory actionProxyFactory = this.actionProxyFactories.get(key);
            if (actionProxyFactory != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using ActionProxyFactory [#0] for prefix [#1]", new Object[]{actionProxyFactory, key});
                }
                return actionProxyFactory.createActionProxy(namespace, actionName, methodName, extraContext, executeResult, cleanupContext);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No ActionProxyFactory defined for [#1]", new String[]{key});
            }
            lastIndex = uri.lastIndexOf(47, lastIndex - 1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cannot find any matching ActionProxyFactory, falling back to [#0]", new Object[]{this.defaultFactory});
        }
        return this.defaultFactory.createActionProxy(namespace, actionName, methodName, extraContext, executeResult, cleanupContext);
    }
}

