/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.cache._CacheAPI;
import freemarker.core.BodyInstruction;
import freemarker.core.BreakInstruction;
import freemarker.core.Configurable;
import freemarker.core.DirectiveCallPlace;
import freemarker.core.EvalUtil;
import freemarker.core.Expression;
import freemarker.core.ISOTemplateDateFormatFactory;
import freemarker.core.Identifier;
import freemarker.core.IteratorBlock;
import freemarker.core.JavaTemplateDateFormatFactory;
import freemarker.core.LocalContext;
import freemarker.core.Macro;
import freemarker.core.MessageUtil;
import freemarker.core.RecoveryBlock;
import freemarker.core.ReturnInstruction;
import freemarker.core.StopException;
import freemarker.core.TemplateDateFormat;
import freemarker.core.TemplateDateFormatFactory;
import freemarker.core.TemplateElement;
import freemarker.core.TemplateObject;
import freemarker.core.UnformattableDateException;
import freemarker.core.UnifiedCall;
import freemarker.core.UnknownDateTypeFormattingUnsupportedException;
import freemarker.core.XSTemplateDateFormatFactory;
import freemarker.core._DelayedJQuote;
import freemarker.core._DelayedToString;
import freemarker.core._MiscTemplateException;
import freemarker.core._TemplateModelException;
import freemarker.ext.beans.BeansWrapper;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.TemplateTransformModel;
import freemarker.template.TransformControl;
import freemarker.template._TemplateAPI;
import freemarker.template.utility.DateUtil;
import freemarker.template.utility.NullWriter;
import freemarker.template.utility.UndeclaredThrowableException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public final class Environment
extends Configurable {
    private static final ThreadLocal threadEnv = new ThreadLocal();
    private static final Logger LOG = Logger.getLogger("freemarker.runtime");
    private static final Logger ATTEMPT_LOGGER = Logger.getLogger("freemarker.runtime.attempt");
    private static final Map JAVA_NUMBER_FORMATS = new HashMap();
    private static final DecimalFormat C_NUMBER_FORMAT = new DecimalFormat("0.################", new DecimalFormatSymbols(Locale.US));
    private final TemplateHashModel rootDataModel;
    private final ArrayList instructionStack = new ArrayList();
    private final ArrayList recoveredErrorStack = new ArrayList();
    private NumberFormat cachedNumberFormat;
    private Map cachedNumberFormats;
    private TemplateDateFormat[] cachedTemplateDateFormats;
    private static final int CACHED_TDFS_ZONELESS_INPUT_OFFS = 4;
    private static final int CACHED_TDFS_DEF_SYS_TZ_OFFS = 8;
    private static final int CACHED_TDFS_LENGTH = 16;
    private static final int CACHED_TDFS_SQL_D_T_TZ_OFFS = 8;
    private XSTemplateDateFormatFactory cachedXSTemplateDateFormatFactory;
    private XSTemplateDateFormatFactory cachedSQLDTXSTemplateDateFormatFactory;
    private ISOTemplateDateFormatFactory cachedISOTemplateDateFormatFactory;
    private ISOTemplateDateFormatFactory cachedSQLDTISOTemplateDateFormatFactory;
    private JavaTemplateDateFormatFactory cachedJavaTemplateDateFormatFactory;
    private JavaTemplateDateFormatFactory cachedSQLDTJavaTemplateDateFormatFactory;
    private Boolean cachedSQLDateAndTimeTimeZoneSameAsNormal;
    private NumberFormat cNumberFormat;
    private DateUtil.DateToISO8601CalendarFactory isoBuiltInCalendarFactory;
    private Collator cachedCollator;
    private Writer out;
    private Macro.Context currentMacroContext;
    private ArrayList localContextStack;
    private final Namespace mainNamespace;
    private Namespace currentNamespace;
    private Namespace globalNamespace;
    private HashMap loadedLibs;
    private boolean inAttemptBlock;
    private Throwable lastThrowable;
    private TemplateModel lastReturnValue;
    private HashMap macroToNamespaceLookup = new HashMap();
    private TemplateNodeModel currentVisitorNode;
    private TemplateSequenceModel nodeNamespaces;
    private int nodeNamespaceIndex;
    private String currentNodeName;
    private String currentNodeNS;
    private String cachedURLEscapingCharset;
    private boolean cachedURLEscapingCharsetSet;
    private boolean fastInvalidReferenceExceptions;
    private static final TemplateModel[] NO_OUT_ARGS;
    private static final int TERSE_MODE_INSTRUCTION_STACK_TRACE_LIMIT = 10;
    private static final Writer EMPTY_BODY_WRITER;

    public static Environment getCurrentEnvironment() {
        return (Environment)threadEnv.get();
    }

    public Environment(Template template, TemplateHashModel rootDataModel, Writer out) {
        super(template);
        this.globalNamespace = new Namespace(null);
        this.currentNamespace = this.mainNamespace = new Namespace(template);
        this.out = out;
        this.rootDataModel = rootDataModel;
        this.importMacros(template);
    }

    public Template getTemplate() {
        return (Template)this.getParent();
    }

    public Template getMainTemplate() {
        return this.mainNamespace.getTemplate();
    }

    Template getCurrentTemplate() {
        int ln = this.instructionStack.size();
        return ln == 0 ? this.getMainTemplate() : ((TemplateObject)this.instructionStack.get(ln - 1)).getTemplate();
    }

    public DirectiveCallPlace getCurrentDirectiveCallPlace() {
        int ln = this.instructionStack.size();
        if (ln == 0) {
            return null;
        }
        TemplateElement te = (TemplateElement)this.instructionStack.get(ln - 1);
        if (te instanceof UnifiedCall) {
            return (UnifiedCall)te;
        }
        if (te instanceof Macro && ln > 1 && this.instructionStack.get(ln - 2) instanceof UnifiedCall) {
            return (UnifiedCall)this.instructionStack.get(ln - 2);
        }
        return null;
    }

    private void clearCachedValues() {
        this.cachedNumberFormats = null;
        this.cachedNumberFormat = null;
        this.cachedTemplateDateFormats = null;
        this.cachedSQLDTXSTemplateDateFormatFactory = null;
        this.cachedXSTemplateDateFormatFactory = null;
        this.cachedSQLDTISOTemplateDateFormatFactory = null;
        this.cachedISOTemplateDateFormatFactory = null;
        this.cachedSQLDTJavaTemplateDateFormatFactory = null;
        this.cachedJavaTemplateDateFormatFactory = null;
        this.cachedCollator = null;
        this.cachedURLEscapingCharset = null;
        this.cachedURLEscapingCharsetSet = false;
    }

    public void process() throws TemplateException, IOException {
        Object savedEnv = threadEnv.get();
        threadEnv.set(this);
        try {
            this.clearCachedValues();
            try {
                this.doAutoImportsAndIncludes(this);
                this.visit(this.getTemplate().getRootTreeNode());
                if (this.getAutoFlush()) {
                    this.out.flush();
                }
            }
            finally {
                this.clearCachedValues();
            }
        }
        finally {
            threadEnv.set(savedEnv);
        }
    }

    void visit(TemplateElement element) throws TemplateException, IOException {
        this.pushElement(element);
        try {
            element.accept(this);
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.popElement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitByHiddingParent(TemplateElement element) throws TemplateException, IOException {
        TemplateElement parent = this.replaceTopElement(element);
        try {
            element.accept(this);
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.replaceTopElement(parent);
        }
    }

    private TemplateElement replaceTopElement(TemplateElement element) {
        return this.instructionStack.set(this.instructionStack.size() - 1, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(TemplateElement element, TemplateDirectiveModel directiveModel, Map args, final List bodyParameterNames) throws TemplateException, IOException {
        NestedElementTemplateDirectiveBody nested = element == null ? null : new NestedElementTemplateDirectiveBody(element);
        final TemplateModel[] outArgs = bodyParameterNames == null || bodyParameterNames.isEmpty() ? NO_OUT_ARGS : new TemplateModel[bodyParameterNames.size()];
        if (outArgs.length > 0) {
            this.pushLocalContext(new LocalContext(){

                public TemplateModel getLocalVariable(String name) {
                    int index = bodyParameterNames.indexOf(name);
                    return index != -1 ? outArgs[index] : null;
                }

                public Collection getLocalVariableNames() {
                    return bodyParameterNames;
                }
            });
        }
        try {
            directiveModel.execute(this, args, outArgs, nested);
        }
        finally {
            if (outArgs.length > 0) {
                this.popLocalContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitAndTransform(TemplateElement element, TemplateTransformModel transform, Map args) throws TemplateException, IOException {
        block17: {
            try {
                Writer tw = transform.getWriter(this.out, args);
                if (tw == null) {
                    tw = EMPTY_BODY_WRITER;
                }
                TransformControl tc = tw instanceof TransformControl ? (TransformControl)((Object)tw) : null;
                Writer prevOut = this.out;
                this.out = tw;
                try {
                    if (tc == null || tc.onStart() != 0) {
                        do {
                            if (element == null) continue;
                            this.visitByHiddingParent(element);
                        } while (tc != null && tc.afterBody() == 0);
                    }
                }
                catch (Throwable t) {
                    try {
                        if (tc != null) {
                            tc.onError(t);
                            break block17;
                        }
                        throw t;
                    }
                    catch (TemplateException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new UndeclaredThrowableException(e);
                    }
                }
                finally {
                    this.out = prevOut;
                    tw.close();
                }
            }
            catch (TemplateException te) {
                this.handleTemplateException(te);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitAttemptRecover(TemplateElement attemptBlock, RecoveryBlock recoveryBlock) throws TemplateException, IOException {
        Writer prevOut = this.out;
        StringWriter sw = new StringWriter();
        this.out = sw;
        TemplateException thrownException = null;
        boolean lastFIRE = this.setFastInvalidReferenceExceptions(false);
        boolean lastInAttemptBlock = this.inAttemptBlock;
        try {
            this.inAttemptBlock = true;
            this.visitByHiddingParent(attemptBlock);
        }
        catch (TemplateException te) {
            thrownException = te;
        }
        finally {
            this.inAttemptBlock = lastInAttemptBlock;
            this.setFastInvalidReferenceExceptions(lastFIRE);
            this.out = prevOut;
        }
        if (thrownException != null) {
            if (ATTEMPT_LOGGER.isDebugEnabled()) {
                ATTEMPT_LOGGER.debug("Error in attempt block " + attemptBlock.getStartLocationQuoted(), thrownException);
            }
            try {
                this.recoveredErrorStack.add(thrownException);
                this.visit(recoveryBlock);
            }
            finally {
                this.recoveredErrorStack.remove(this.recoveredErrorStack.size() - 1);
            }
        } else {
            this.out.write(sw.toString());
        }
    }

    String getCurrentRecoveredErrorMessage() throws TemplateException {
        if (this.recoveredErrorStack.isEmpty()) {
            throw new _MiscTemplateException(this, ".error is not available outside of a #recover block");
        }
        return ((Throwable)this.recoveredErrorStack.get(this.recoveredErrorStack.size() - 1)).getMessage();
    }

    public boolean isInAttemptBlock() {
        return this.inAttemptBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeNestedContent(BodyInstruction.Context bodyCtx) throws TemplateException, IOException {
        Macro.Context invokingMacroContext = this.getCurrentMacroContext();
        ArrayList prevLocalContextStack = this.localContextStack;
        TemplateElement nestedContent = invokingMacroContext.nestedContent;
        if (nestedContent != null) {
            Configurable prevParent;
            this.currentMacroContext = invokingMacroContext.prevMacroContext;
            this.currentNamespace = invokingMacroContext.nestedContentNamespace;
            boolean parentReplacementOn = this.isIcI2322OrLater();
            if (parentReplacementOn) {
                prevParent = this.getParent();
                this.setParent(this.currentNamespace.getTemplate());
            } else {
                prevParent = null;
            }
            this.localContextStack = invokingMacroContext.prevLocalContextStack;
            if (invokingMacroContext.nestedContentParameterNames != null) {
                this.pushLocalContext(bodyCtx);
            }
            try {
                this.visit(nestedContent);
            }
            finally {
                if (invokingMacroContext.nestedContentParameterNames != null) {
                    this.popLocalContext();
                }
                this.currentMacroContext = invokingMacroContext;
                this.currentNamespace = this.getMacroNamespace(invokingMacroContext.getMacro());
                if (parentReplacementOn) {
                    this.setParent(prevParent);
                }
                this.localContextStack = prevLocalContextStack;
            }
        }
    }

    void visitIteratorBlock(IteratorBlock.Context ictxt) throws TemplateException, IOException {
        this.pushLocalContext(ictxt);
        try {
            ictxt.runLoop(this);
        }
        catch (BreakInstruction.Break br) {
        }
        catch (TemplateException te) {
            this.handleTemplateException(te);
        }
        finally {
            this.popLocalContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeNodeHandlerFor(TemplateNodeModel node, TemplateSequenceModel namespaces) throws TemplateException, IOException {
        block13: {
            if (this.nodeNamespaces == null) {
                SimpleSequence ss = new SimpleSequence(1);
                ss.add(this.currentNamespace);
                this.nodeNamespaces = ss;
            }
            int prevNodeNamespaceIndex = this.nodeNamespaceIndex;
            String prevNodeName = this.currentNodeName;
            String prevNodeNS = this.currentNodeNS;
            TemplateSequenceModel prevNodeNamespaces = this.nodeNamespaces;
            TemplateNodeModel prevVisitorNode = this.currentVisitorNode;
            this.currentVisitorNode = node;
            if (namespaces != null) {
                this.nodeNamespaces = namespaces;
            }
            try {
                TemplateModel macroOrTransform = this.getNodeProcessor(node);
                if (macroOrTransform instanceof Macro) {
                    this.invoke((Macro)macroOrTransform, null, null, null, null);
                    break block13;
                }
                if (macroOrTransform instanceof TemplateTransformModel) {
                    this.visitAndTransform(null, (TemplateTransformModel)macroOrTransform, null);
                    break block13;
                }
                String nodeType = node.getNodeType();
                if (nodeType != null) {
                    if (nodeType.equals("text") && node instanceof TemplateScalarModel) {
                        this.out.write(((TemplateScalarModel)((Object)node)).getAsString());
                    } else if (nodeType.equals("document")) {
                        this.recurse(node, namespaces);
                    } else if (!(nodeType.equals("pi") || nodeType.equals("comment") || nodeType.equals("document_type"))) {
                        throw new _MiscTemplateException(this, this.noNodeHandlerDefinedDescription(node, node.getNodeNamespace(), nodeType));
                    }
                    break block13;
                }
                throw new _MiscTemplateException(this, this.noNodeHandlerDefinedDescription(node, node.getNodeNamespace(), "default"));
            }
            finally {
                this.currentVisitorNode = prevVisitorNode;
                this.nodeNamespaceIndex = prevNodeNamespaceIndex;
                this.currentNodeName = prevNodeName;
                this.currentNodeNS = prevNodeNS;
                this.nodeNamespaces = prevNodeNamespaces;
            }
        }
    }

    private Object[] noNodeHandlerDefinedDescription(TemplateNodeModel node, String ns, String nodeType) throws TemplateModelException {
        String nsPrefix;
        if (ns != null) {
            nsPrefix = ns.length() > 0 ? " and namespace " : " and no namespace";
        } else {
            nsPrefix = "";
            ns = "";
        }
        return new Object[]{"No macro or directive is defined for node named ", new _DelayedJQuote(node.getNodeName()), nsPrefix, ns, ", and there is no fallback handler called @", nodeType, " either."};
    }

    void fallback() throws TemplateException, IOException {
        TemplateModel macroOrTransform = this.getNodeProcessor(this.currentNodeName, this.currentNodeNS, this.nodeNamespaceIndex);
        if (macroOrTransform instanceof Macro) {
            this.invoke((Macro)macroOrTransform, null, null, null, null);
        } else if (macroOrTransform instanceof TemplateTransformModel) {
            this.visitAndTransform(null, (TemplateTransformModel)macroOrTransform, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void invoke(Macro macro, Map namedArgs, List positionalArgs, List bodyParameterNames, TemplateElement nestedBlock) throws TemplateException, IOException {
        block13: {
            if (macro == Macro.DO_NOTHING_MACRO) {
                return;
            }
            this.pushElement(macro);
            try {
                Macro macro2 = macro;
                macro2.getClass();
                Macro.Context macroCtx = new Macro.Context(macro2, this, nestedBlock, bodyParameterNames);
                this.setMacroContextLocalsFromArguments(macroCtx, macro, namedArgs, positionalArgs);
                Macro.Context prevMacroCtx = this.currentMacroContext;
                this.currentMacroContext = macroCtx;
                ArrayList prevLocalContextStack = this.localContextStack;
                this.localContextStack = null;
                Namespace prevNamespace = this.currentNamespace;
                this.currentNamespace = (Namespace)this.macroToNamespaceLookup.get(macro);
                boolean parentReplacementOn = this.isIcI2322OrLater();
                Configurable prevParent = parentReplacementOn ? this.getParent() : null;
                try {
                    macroCtx.runMacro(this);
                }
                catch (ReturnInstruction.Return re) {
                    this.currentMacroContext = prevMacroCtx;
                    this.localContextStack = prevLocalContextStack;
                    this.currentNamespace = prevNamespace;
                    if (parentReplacementOn) {
                        this.setParent(prevParent);
                    }
                }
                catch (TemplateException te) {
                    this.handleTemplateException(te);
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.currentMacroContext = prevMacroCtx;
                    this.localContextStack = prevLocalContextStack;
                    this.currentNamespace = prevNamespace;
                    if (parentReplacementOn) {
                        this.setParent(prevParent);
                    }
                }
            }
            finally {
                this.popElement();
            }
        }
    }

    private void setMacroContextLocalsFromArguments(Macro.Context macroCtx, Macro macro, Map namedArgs, List positionalArgs) throws TemplateException, _MiscTemplateException {
        block13: {
            SimpleSequence catchAllParamValue;
            String catchAllParamName;
            block12: {
                SimpleHash catchAllParamValue2;
                catchAllParamName = macro.getCatchAll();
                if (namedArgs == null) break block12;
                if (catchAllParamName != null) {
                    catchAllParamValue2 = new SimpleHash((ObjectWrapper)null);
                    macroCtx.setLocalVar(catchAllParamName, catchAllParamValue2);
                } else {
                    catchAllParamValue2 = null;
                }
                Iterator it = namedArgs.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry argNameAndValExp = it.next();
                    String argName = (String)argNameAndValExp.getKey();
                    boolean isArgNameDeclared = macro.hasArgNamed(argName);
                    if (isArgNameDeclared || catchAllParamName != null) {
                        Expression argValueExp = (Expression)argNameAndValExp.getValue();
                        TemplateModel argValue = argValueExp.eval(this);
                        if (isArgNameDeclared) {
                            macroCtx.setLocalVar(argName, argValue);
                            continue;
                        }
                        catchAllParamValue2.put(argName, argValue);
                        continue;
                    }
                    throw new _MiscTemplateException(this, new Object[]{macro.isFunction() ? "Function " : "Macro ", new _DelayedJQuote(macro.getName()), " has no parameter with name ", new _DelayedJQuote(argName), "."});
                }
                break block13;
            }
            if (positionalArgs == null) break block13;
            if (catchAllParamName != null) {
                catchAllParamValue = new SimpleSequence((ObjectWrapper)null);
                macroCtx.setLocalVar(catchAllParamName, catchAllParamValue);
            } else {
                catchAllParamValue = null;
            }
            String[] argNames = macro.getArgumentNamesInternal();
            int argsCnt = positionalArgs.size();
            if (argNames.length < argsCnt && catchAllParamName == null) {
                throw new _MiscTemplateException(this, new Object[]{macro.isFunction() ? "Function " : "Macro ", new _DelayedJQuote(macro.getName()), " only accepts ", new _DelayedToString(argNames.length), " parameters, but got ", new _DelayedToString(argsCnt), "."});
            }
            for (int i = 0; i < argsCnt; ++i) {
                Expression argValueExp = (Expression)positionalArgs.get(i);
                TemplateModel argValue = argValueExp.eval(this);
                try {
                    if (i < argNames.length) {
                        String argName = argNames[i];
                        macroCtx.setLocalVar(argName, argValue);
                        continue;
                    }
                    catchAllParamValue.add(argValue);
                    continue;
                }
                catch (RuntimeException re) {
                    throw new _MiscTemplateException((Throwable)re, this);
                }
            }
        }
    }

    void visitMacroDef(Macro macro) {
        this.macroToNamespaceLookup.put(macro, this.currentNamespace);
        this.currentNamespace.put(macro.getName(), macro);
    }

    Namespace getMacroNamespace(Macro macro) {
        return (Namespace)this.macroToNamespaceLookup.get(macro);
    }

    void recurse(TemplateNodeModel node, TemplateSequenceModel namespaces) throws TemplateException, IOException {
        if (node == null && (node = this.getCurrentVisitorNode()) == null) {
            throw new _TemplateModelException("The target node of recursion is missing or null.");
        }
        TemplateSequenceModel children = node.getChildNodes();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            TemplateNodeModel child = (TemplateNodeModel)children.get(i);
            if (child == null) continue;
            this.invokeNodeHandlerFor(child, namespaces);
        }
    }

    Macro.Context getCurrentMacroContext() {
        return this.currentMacroContext;
    }

    private void handleTemplateException(TemplateException templateException) throws TemplateException {
        if (this.lastThrowable == templateException) {
            throw templateException;
        }
        this.lastThrowable = templateException;
        if (LOG.isErrorEnabled() && (this.isInAttemptBlock() || this.getLogTemplateExceptions())) {
            LOG.error("Error executing FreeMarker template", templateException);
        }
        if (templateException instanceof StopException) {
            throw templateException;
        }
        this.getTemplateExceptionHandler().handleTemplateException(templateException, this, this.out);
    }

    public void setTemplateExceptionHandler(TemplateExceptionHandler templateExceptionHandler) {
        super.setTemplateExceptionHandler(templateExceptionHandler);
        this.lastThrowable = null;
    }

    public void setLocale(Locale locale) {
        Locale prevLocale = this.getLocale();
        super.setLocale(locale);
        if (!locale.equals(prevLocale)) {
            this.cachedNumberFormats = null;
            this.cachedNumberFormat = null;
            if (this.cachedTemplateDateFormats != null) {
                for (int i = 0; i < 16; ++i) {
                    TemplateDateFormat f = this.cachedTemplateDateFormats[i];
                    if (f == null || !f.isLocaleBound()) continue;
                    this.cachedTemplateDateFormats[i] = null;
                }
            }
            if (this.cachedXSTemplateDateFormatFactory != null && this.cachedXSTemplateDateFormatFactory.isLocaleBound()) {
                this.cachedXSTemplateDateFormatFactory = null;
            }
            if (this.cachedSQLDTXSTemplateDateFormatFactory != null && this.cachedSQLDTXSTemplateDateFormatFactory.isLocaleBound()) {
                this.cachedSQLDTXSTemplateDateFormatFactory = null;
            }
            if (this.cachedISOTemplateDateFormatFactory != null && this.cachedISOTemplateDateFormatFactory.isLocaleBound()) {
                this.cachedISOTemplateDateFormatFactory = null;
            }
            if (this.cachedSQLDTISOTemplateDateFormatFactory != null && this.cachedSQLDTISOTemplateDateFormatFactory.isLocaleBound()) {
                this.cachedSQLDTISOTemplateDateFormatFactory = null;
            }
            if (this.cachedJavaTemplateDateFormatFactory != null && this.cachedJavaTemplateDateFormatFactory.isLocaleBound()) {
                this.cachedJavaTemplateDateFormatFactory = null;
            }
            if (this.cachedSQLDTJavaTemplateDateFormatFactory != null && this.cachedSQLDTJavaTemplateDateFormatFactory.isLocaleBound()) {
                this.cachedSQLDTJavaTemplateDateFormatFactory = null;
            }
            this.cachedCollator = null;
        }
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeZone prevTimeZone = this.getTimeZone();
        super.setTimeZone(timeZone);
        if (!timeZone.equals(prevTimeZone)) {
            if (this.cachedTemplateDateFormats != null) {
                for (int i = 0; i < 8; ++i) {
                    this.cachedTemplateDateFormats[i] = null;
                }
            }
            this.cachedXSTemplateDateFormatFactory = null;
            this.cachedISOTemplateDateFormatFactory = null;
            this.cachedJavaTemplateDateFormatFactory = null;
            this.cachedSQLDateAndTimeTimeZoneSameAsNormal = null;
        }
    }

    public void setSQLDateAndTimeTimeZone(TimeZone timeZone) {
        TimeZone prevTimeZone = this.getSQLDateAndTimeTimeZone();
        super.setSQLDateAndTimeTimeZone(timeZone);
        if (!Environment.nullSafeEquals(timeZone, prevTimeZone)) {
            if (this.cachedTemplateDateFormats != null) {
                for (int i = 8; i < 16; ++i) {
                    this.cachedTemplateDateFormats[i] = null;
                }
            }
            this.cachedSQLDTXSTemplateDateFormatFactory = null;
            this.cachedSQLDTISOTemplateDateFormatFactory = null;
            this.cachedSQLDTJavaTemplateDateFormatFactory = null;
            this.cachedSQLDateAndTimeTimeZoneSameAsNormal = null;
        }
    }

    private static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    boolean isSQLDateAndTimeTimeZoneSameAsNormal() {
        if (this.cachedSQLDateAndTimeTimeZoneSameAsNormal == null) {
            this.cachedSQLDateAndTimeTimeZoneSameAsNormal = this.getSQLDateAndTimeTimeZone() == null || this.getSQLDateAndTimeTimeZone().equals(this.getTimeZone());
        }
        return this.cachedSQLDateAndTimeTimeZoneSameAsNormal;
    }

    public void setURLEscapingCharset(String urlEscapingCharset) {
        this.cachedURLEscapingCharsetSet = false;
        super.setURLEscapingCharset(urlEscapingCharset);
    }

    public void setOutputEncoding(String outputEncoding) {
        this.cachedURLEscapingCharsetSet = false;
        super.setOutputEncoding(outputEncoding);
    }

    String getEffectiveURLEscapingCharset() {
        if (!this.cachedURLEscapingCharsetSet) {
            this.cachedURLEscapingCharset = this.getURLEscapingCharset();
            if (this.cachedURLEscapingCharset == null) {
                this.cachedURLEscapingCharset = this.getOutputEncoding();
            }
            this.cachedURLEscapingCharsetSet = true;
        }
        return this.cachedURLEscapingCharset;
    }

    Collator getCollator() {
        if (this.cachedCollator == null) {
            this.cachedCollator = Collator.getInstance(this.getLocale());
        }
        return this.cachedCollator;
    }

    public boolean applyEqualsOperator(TemplateModel leftValue, TemplateModel rightValue) throws TemplateException {
        return EvalUtil.compare(leftValue, 1, rightValue, this);
    }

    public boolean applyEqualsOperatorLenient(TemplateModel leftValue, TemplateModel rightValue) throws TemplateException {
        return EvalUtil.compareLenient(leftValue, 1, rightValue, this);
    }

    public boolean applyLessThanOperator(TemplateModel leftValue, TemplateModel rightValue) throws TemplateException {
        return EvalUtil.compare(leftValue, 3, rightValue, this);
    }

    public boolean applyLessThanOrEqualsOperator(TemplateModel leftValue, TemplateModel rightValue) throws TemplateException {
        return EvalUtil.compare(leftValue, 5, rightValue, this);
    }

    public boolean applyGreaterThanOperator(TemplateModel leftValue, TemplateModel rightValue) throws TemplateException {
        return EvalUtil.compare(leftValue, 4, rightValue, this);
    }

    public boolean applyWithGreaterThanOrEqualsOperator(TemplateModel leftValue, TemplateModel rightValue) throws TemplateException {
        return EvalUtil.compare(leftValue, 6, rightValue, this);
    }

    public void setOut(Writer out) {
        this.out = out;
    }

    public Writer getOut() {
        return this.out;
    }

    String formatNumber(Number number) {
        if (this.cachedNumberFormat == null) {
            this.cachedNumberFormat = this.getNumberFormatObject(this.getNumberFormat());
        }
        return this.cachedNumberFormat.format(number);
    }

    public void setNumberFormat(String formatName) {
        super.setNumberFormat(formatName);
        this.cachedNumberFormat = null;
    }

    public void setTimeFormat(String timeFormat) {
        String prevTimeFormat = this.getTimeFormat();
        super.setTimeFormat(timeFormat);
        if (!timeFormat.equals(prevTimeFormat) && this.cachedTemplateDateFormats != null) {
            for (int i = 0; i < 16; i += 4) {
                this.cachedTemplateDateFormats[i + 1] = null;
            }
        }
    }

    public void setDateFormat(String dateFormat) {
        String prevDateFormat = this.getDateFormat();
        super.setDateFormat(dateFormat);
        if (!dateFormat.equals(prevDateFormat) && this.cachedTemplateDateFormats != null) {
            for (int i = 0; i < 16; i += 4) {
                this.cachedTemplateDateFormats[i + 2] = null;
            }
        }
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        String prevDateTimeFormat = this.getDateTimeFormat();
        super.setDateTimeFormat(dateTimeFormat);
        if (!dateTimeFormat.equals(prevDateTimeFormat) && this.cachedTemplateDateFormats != null) {
            for (int i = 0; i < 16; i += 4) {
                this.cachedTemplateDateFormats[i + 3] = null;
            }
        }
    }

    public Configuration getConfiguration() {
        return this.getTemplate().getConfiguration();
    }

    TemplateModel getLastReturnValue() {
        return this.lastReturnValue;
    }

    void setLastReturnValue(TemplateModel lastReturnValue) {
        this.lastReturnValue = lastReturnValue;
    }

    void clearLastReturnValue() {
        this.lastReturnValue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NumberFormat getNumberFormatObject(String pattern) {
        NumberFormat format;
        if (this.cachedNumberFormats == null) {
            this.cachedNumberFormats = new HashMap();
        }
        if ((format = (NumberFormat)this.cachedNumberFormats.get(pattern)) != null) {
            return format;
        }
        Map map = JAVA_NUMBER_FORMATS;
        synchronized (map) {
            Locale locale = this.getLocale();
            NumberFormatKey fk = new NumberFormatKey(pattern, locale);
            format = (NumberFormat)JAVA_NUMBER_FORMATS.get(fk);
            if (format == null) {
                format = "number".equals(pattern) ? NumberFormat.getNumberInstance(locale) : ("currency".equals(pattern) ? NumberFormat.getCurrencyInstance(locale) : ("percent".equals(pattern) ? NumberFormat.getPercentInstance(locale) : ("computer".equals(pattern) ? this.getCNumberFormat() : new DecimalFormat(pattern, new DecimalFormatSymbols(this.getLocale())))));
                JAVA_NUMBER_FORMATS.put(fk, format);
            }
        }
        format = (NumberFormat)format.clone();
        this.cachedNumberFormats.put(pattern, format);
        return format;
    }

    String formatDate(TemplateDateModel tdm, Expression tdmSourceExpr) throws TemplateModelException {
        Date date = EvalUtil.modelToDate(tdm, tdmSourceExpr);
        try {
            boolean isSQLDateOrTime = Environment.isSQLDateOrTimeClass(date.getClass());
            return this.getTemplateDateFormat(tdm.getDateType(), isSQLDateOrTime, this.shouldUseSQLDTTimeZone(isSQLDateOrTime), tdmSourceExpr).format(tdm);
        }
        catch (UnknownDateTypeFormattingUnsupportedException e) {
            throw MessageUtil.newCantFormatUnknownTypeDateException(tdmSourceExpr, e);
        }
        catch (UnformattableDateException e) {
            throw MessageUtil.newCantFormatDateException(tdmSourceExpr, e);
        }
    }

    String formatDate(TemplateDateModel tdm, String formatDescriptor, Expression tdmSourceExpr) throws TemplateModelException {
        Date date = EvalUtil.modelToDate(tdm, tdmSourceExpr);
        boolean isSQLDateOrTime = Environment.isSQLDateOrTimeClass(date.getClass());
        try {
            return this.getTemplateDateFormat(tdm.getDateType(), isSQLDateOrTime, this.shouldUseSQLDTTimeZone(isSQLDateOrTime), formatDescriptor, null).format(tdm);
        }
        catch (UnknownDateTypeFormattingUnsupportedException e) {
            throw MessageUtil.newCantFormatUnknownTypeDateException(tdmSourceExpr, e);
        }
        catch (UnformattableDateException e) {
            throw MessageUtil.newCantFormatDateException(tdmSourceExpr, e);
        }
    }

    TemplateDateFormat getTemplateDateFormat(int dateType, Class dateClass, Expression dateSourceExpr) throws TemplateModelException {
        try {
            boolean isSQLDateOrTime = Environment.isSQLDateOrTimeClass(dateClass);
            return this.getTemplateDateFormat(dateType, isSQLDateOrTime, this.shouldUseSQLDTTimeZone(isSQLDateOrTime), dateSourceExpr);
        }
        catch (UnknownDateTypeFormattingUnsupportedException e) {
            throw MessageUtil.newCantFormatUnknownTypeDateException(dateSourceExpr, e);
        }
    }

    private TemplateDateFormat getTemplateDateFormat(int dateType, boolean isSQLDateOrTime, boolean useSQLDTTZ, Expression dateSourceExpr) throws TemplateModelException, UnknownDateTypeFormattingUnsupportedException {
        TemplateDateFormat f;
        if (dateType == 0) {
            throw MessageUtil.newCantFormatUnknownTypeDateException(dateSourceExpr, null);
        }
        int cacheIdx = this.getCachedTemplateDateFormatIndex(dateType, isSQLDateOrTime, useSQLDTTZ);
        TemplateDateFormat[] cachedTemplateDateFormats = this.cachedTemplateDateFormats;
        if (cachedTemplateDateFormats == null) {
            this.cachedTemplateDateFormats = cachedTemplateDateFormats = new TemplateDateFormat[16];
        }
        if ((f = cachedTemplateDateFormats[cacheIdx]) == null) {
            String settingValue;
            String settingName;
            switch (dateType) {
                case 1: {
                    settingName = "time_format";
                    settingValue = this.getTimeFormat();
                    break;
                }
                case 2: {
                    settingName = "date_format";
                    settingValue = this.getDateFormat();
                    break;
                }
                case 3: {
                    settingName = "datetime_format";
                    settingValue = this.getDateTimeFormat();
                    break;
                }
                default: {
                    throw new _TemplateModelException(new Object[]{"Invalid date type enum: ", new Integer(dateType)});
                }
            }
            cachedTemplateDateFormats[cacheIdx] = f = this.getTemplateDateFormat(dateType, isSQLDateOrTime, useSQLDTTZ, settingValue, settingName);
        }
        return f;
    }

    TemplateDateFormat getTemplateDateFormat(int dateType, Class dateClass, String formatDescriptor, Expression dateSourceExpr) throws TemplateModelException {
        try {
            boolean isSQLDateOrTime = Environment.isSQLDateOrTimeClass(dateClass);
            return this.getTemplateDateFormat(dateType, isSQLDateOrTime, this.shouldUseSQLDTTimeZone(isSQLDateOrTime), formatDescriptor, null);
        }
        catch (UnknownDateTypeFormattingUnsupportedException e) {
            throw MessageUtil.newCantFormatUnknownTypeDateException(dateSourceExpr, e);
        }
    }

    private TemplateDateFormat getTemplateDateFormat(int dateType, boolean zonelessInput, boolean useSQLDTTZ, String formatDescriptor, String sourceCfgSetting) throws TemplateModelException, UnknownDateTypeFormattingUnsupportedException {
        TemplateDateFormatFactory templateDateFormatFactory;
        TimeZone timeZone;
        int formatDescriptionLen = formatDescriptor.length();
        TimeZone timeZone2 = timeZone = useSQLDTTZ ? this.getSQLDateAndTimeTimeZone() : this.getTimeZone();
        if (formatDescriptionLen > 1 && formatDescriptor.charAt(0) == 'x' && formatDescriptor.charAt(1) == 's') {
            TemplateDateFormatFactory templateDateFormatFactory2 = templateDateFormatFactory = useSQLDTTZ ? this.cachedSQLDTXSTemplateDateFormatFactory : this.cachedXSTemplateDateFormatFactory;
            if (templateDateFormatFactory == null) {
                templateDateFormatFactory = new XSTemplateDateFormatFactory(timeZone);
                if (useSQLDTTZ) {
                    this.cachedSQLDTXSTemplateDateFormatFactory = (XSTemplateDateFormatFactory)templateDateFormatFactory;
                } else {
                    this.cachedXSTemplateDateFormatFactory = (XSTemplateDateFormatFactory)templateDateFormatFactory;
                }
            }
        } else if (formatDescriptionLen > 2 && formatDescriptor.charAt(0) == 'i' && formatDescriptor.charAt(1) == 's' && formatDescriptor.charAt(2) == 'o') {
            TemplateDateFormatFactory templateDateFormatFactory3 = templateDateFormatFactory = useSQLDTTZ ? this.cachedSQLDTISOTemplateDateFormatFactory : this.cachedISOTemplateDateFormatFactory;
            if (templateDateFormatFactory == null) {
                templateDateFormatFactory = new ISOTemplateDateFormatFactory(timeZone);
                if (useSQLDTTZ) {
                    this.cachedSQLDTISOTemplateDateFormatFactory = (ISOTemplateDateFormatFactory)templateDateFormatFactory;
                } else {
                    this.cachedISOTemplateDateFormatFactory = (ISOTemplateDateFormatFactory)templateDateFormatFactory;
                }
            }
        } else {
            JavaTemplateDateFormatFactory javaTemplateDateFormatFactory = templateDateFormatFactory = useSQLDTTZ ? this.cachedSQLDTJavaTemplateDateFormatFactory : this.cachedJavaTemplateDateFormatFactory;
            if (templateDateFormatFactory == null) {
                templateDateFormatFactory = new JavaTemplateDateFormatFactory(timeZone, this.getLocale());
                if (useSQLDTTZ) {
                    this.cachedSQLDTJavaTemplateDateFormatFactory = templateDateFormatFactory;
                } else {
                    this.cachedJavaTemplateDateFormatFactory = templateDateFormatFactory;
                }
            }
        }
        try {
            return ((TemplateDateFormatFactory)templateDateFormatFactory).get(dateType, zonelessInput, formatDescriptor);
        }
        catch (ParseException e) {
            Object[] objectArray;
            Throwable throwable = e.getCause();
            Object[] objectArray2 = new Object[4];
            if (sourceCfgSetting == null) {
                objectArray = "Malformed date/time format descriptor: ";
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = "The value of the \"";
                objectArray3[1] = sourceCfgSetting;
                objectArray = objectArray3;
                objectArray3[2] = "\" FreeMarker configuration setting is a malformed date/time format descriptor: ";
            }
            objectArray2[0] = objectArray;
            objectArray2[1] = new _DelayedJQuote(formatDescriptor);
            objectArray2[2] = ". Reason given: ";
            objectArray2[3] = e.getMessage();
            throw new _TemplateModelException(throwable, objectArray2);
        }
    }

    boolean shouldUseSQLDTTZ(Class dateClass) {
        return dateClass != Date.class && !this.isSQLDateAndTimeTimeZoneSameAsNormal() && Environment.isSQLDateOrTimeClass(dateClass);
    }

    private boolean shouldUseSQLDTTimeZone(boolean sqlDateOrTime) {
        return sqlDateOrTime && !this.isSQLDateAndTimeTimeZoneSameAsNormal();
    }

    private static boolean isSQLDateOrTimeClass(Class dateClass) {
        return dateClass != Date.class && (dateClass == java.sql.Date.class || dateClass == Time.class || dateClass != Timestamp.class && (java.sql.Date.class.isAssignableFrom(dateClass) || Time.class.isAssignableFrom(dateClass)));
    }

    private int getCachedTemplateDateFormatIndex(int dateType, boolean zonelessInput, boolean sqlDTTZ) {
        return dateType + (zonelessInput ? 4 : 0) + (sqlDTTZ ? 8 : 0);
    }

    DateUtil.DateToISO8601CalendarFactory getISOBuiltInCalendarFactory() {
        if (this.isoBuiltInCalendarFactory == null) {
            this.isoBuiltInCalendarFactory = new DateUtil.TrivialDateToISO8601CalendarFactory();
        }
        return this.isoBuiltInCalendarFactory;
    }

    public NumberFormat getCNumberFormat() {
        if (this.cNumberFormat == null) {
            this.cNumberFormat = (DecimalFormat)C_NUMBER_FORMAT.clone();
        }
        return this.cNumberFormat;
    }

    TemplateTransformModel getTransform(Expression exp) throws TemplateException {
        TemplateTransformModel ttm = null;
        TemplateModel tm = exp.eval(this);
        if (tm instanceof TemplateTransformModel) {
            ttm = (TemplateTransformModel)tm;
        } else if (exp instanceof Identifier && (tm = this.getConfiguration().getSharedVariable(exp.toString())) instanceof TemplateTransformModel) {
            ttm = (TemplateTransformModel)tm;
        }
        return ttm;
    }

    public TemplateModel getLocalVariable(String name) throws TemplateModelException {
        if (this.localContextStack != null) {
            for (int i = this.localContextStack.size() - 1; i >= 0; --i) {
                LocalContext lc = (LocalContext)this.localContextStack.get(i);
                TemplateModel tm = lc.getLocalVariable(name);
                if (tm == null) continue;
                return tm;
            }
        }
        return this.currentMacroContext == null ? null : this.currentMacroContext.getLocalVariable(name);
    }

    public TemplateModel getVariable(String name) throws TemplateModelException {
        TemplateModel result = this.getLocalVariable(name);
        if (result == null) {
            result = this.currentNamespace.get(name);
        }
        if (result == null) {
            result = this.getGlobalVariable(name);
        }
        return result;
    }

    public TemplateModel getGlobalVariable(String name) throws TemplateModelException {
        TemplateModel result = this.globalNamespace.get(name);
        if (result == null) {
            result = this.rootDataModel.get(name);
        }
        if (result == null) {
            result = this.getConfiguration().getSharedVariable(name);
        }
        return result;
    }

    public void setGlobalVariable(String name, TemplateModel model) {
        this.globalNamespace.put(name, model);
    }

    public void setVariable(String name, TemplateModel model) {
        this.currentNamespace.put(name, model);
    }

    public void setLocalVariable(String name, TemplateModel model) {
        if (this.currentMacroContext == null) {
            throw new IllegalStateException("Not executing macro body");
        }
        this.currentMacroContext.setLocalVar(name, model);
    }

    public Set getKnownVariableNames() throws TemplateModelException {
        Set set = this.getConfiguration().getSharedVariableNames();
        if (this.rootDataModel instanceof TemplateHashModelEx) {
            TemplateModelIterator rootNames = ((TemplateHashModelEx)this.rootDataModel).keys().iterator();
            while (rootNames.hasNext()) {
                set.add(((TemplateScalarModel)rootNames.next()).getAsString());
            }
        }
        TemplateModelIterator tmi = this.globalNamespace.keys().iterator();
        while (tmi.hasNext()) {
            set.add(((TemplateScalarModel)tmi.next()).getAsString());
        }
        tmi = this.currentNamespace.keys().iterator();
        while (tmi.hasNext()) {
            set.add(((TemplateScalarModel)tmi.next()).getAsString());
        }
        if (this.currentMacroContext != null) {
            set.addAll(this.currentMacroContext.getLocalVariableNames());
        }
        if (this.localContextStack != null) {
            for (int i = this.localContextStack.size() - 1; i >= 0; --i) {
                LocalContext lc = (LocalContext)this.localContextStack.get(i);
                set.addAll(lc.getLocalVariableNames());
            }
        }
        return set;
    }

    public void outputInstructionStack(PrintWriter pw) {
        Environment.outputInstructionStack(this.getInstructionStackSnapshot(), false, pw);
        pw.flush();
    }

    static void outputInstructionStack(TemplateElement[] instructionStackSnapshot, boolean terseMode, Writer w) {
        PrintWriter pw = (PrintWriter)(w instanceof PrintWriter ? w : null);
        try {
            if (instructionStackSnapshot != null) {
                int totalFrames = instructionStackSnapshot.length;
                int framesToPrint = terseMode ? (totalFrames <= 10 ? totalFrames : 9) : totalFrames;
                boolean hideNestringRelatedFrames = terseMode && framesToPrint < totalFrames;
                int nestingRelatedFramesHidden = 0;
                int trailingFramesHidden = 0;
                int framesPrinted = 0;
                for (int frameIdx = 0; frameIdx < totalFrames; ++frameIdx) {
                    boolean nestingRelatedElement;
                    TemplateElement stackEl = instructionStackSnapshot[frameIdx];
                    boolean bl = nestingRelatedElement = frameIdx > 0 && stackEl instanceof BodyInstruction || frameIdx > 1 && instructionStackSnapshot[frameIdx - 1] instanceof BodyInstruction;
                    if (framesPrinted < framesToPrint) {
                        if (!nestingRelatedElement || !hideNestringRelatedFrames) {
                            w.write(frameIdx == 0 ? "\t- Failed at: " : (nestingRelatedElement ? "\t~ Reached through: " : "\t- Reached through: "));
                            w.write(Environment.instructionStackItemToString(stackEl));
                            if (pw != null) {
                                pw.println();
                            } else {
                                w.write(10);
                            }
                            ++framesPrinted;
                            continue;
                        }
                        ++nestingRelatedFramesHidden;
                        continue;
                    }
                    ++trailingFramesHidden;
                }
                boolean hadClosingNotes = false;
                if (trailingFramesHidden > 0) {
                    w.write("\t... (Had ");
                    w.write(String.valueOf(trailingFramesHidden + nestingRelatedFramesHidden));
                    w.write(" more, hidden for tersenes)");
                    hadClosingNotes = true;
                }
                if (nestingRelatedFramesHidden > 0) {
                    if (hadClosingNotes) {
                        w.write(32);
                    } else {
                        w.write(9);
                    }
                    w.write("(Hidden " + nestingRelatedFramesHidden + " \"~\" lines for terseness)");
                    if (pw != null) {
                        pw.println();
                    } else {
                        w.write(10);
                    }
                    hadClosingNotes = true;
                }
                if (hadClosingNotes) {
                    if (pw != null) {
                        pw.println();
                    } else {
                        w.write(10);
                    }
                }
            } else {
                w.write("(The stack was empty)");
                if (pw != null) {
                    pw.println();
                } else {
                    w.write(10);
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed to print FTL stack trace", e);
        }
    }

    TemplateElement[] getInstructionStackSnapshot() {
        int requiredLength = 0;
        int ln = this.instructionStack.size();
        for (int i = 0; i < ln; ++i) {
            TemplateElement stackEl = (TemplateElement)this.instructionStack.get(i);
            if (i != ln && !stackEl.isShownInStackTrace()) continue;
            ++requiredLength;
        }
        if (requiredLength == 0) {
            return null;
        }
        TemplateElement[] result = new TemplateElement[requiredLength];
        int dstIdx = requiredLength - 1;
        for (int i = 0; i < ln; ++i) {
            TemplateElement stackEl = (TemplateElement)this.instructionStack.get(i);
            if (i != ln && !stackEl.isShownInStackTrace()) continue;
            result[dstIdx--] = stackEl;
        }
        return result;
    }

    static String instructionStackItemToString(TemplateElement stackEl) {
        StringBuffer sb = new StringBuffer();
        Environment.appendInstructionStackItem(stackEl, sb);
        return sb.toString();
    }

    static void appendInstructionStackItem(TemplateElement stackEl, StringBuffer sb) {
        sb.append(MessageUtil.shorten(stackEl.getDescription(), 40));
        sb.append("  [");
        Macro enclosingMacro = Environment.getEnclosingMacro(stackEl);
        if (enclosingMacro != null) {
            sb.append(MessageUtil.formatLocationForEvaluationError(enclosingMacro, stackEl.beginLine, stackEl.beginColumn));
        } else {
            sb.append(MessageUtil.formatLocationForEvaluationError(stackEl.getTemplate(), stackEl.beginLine, stackEl.beginColumn));
        }
        sb.append("]");
    }

    private static Macro getEnclosingMacro(TemplateElement stackEl) {
        while (stackEl != null) {
            if (stackEl instanceof Macro) {
                return (Macro)stackEl;
            }
            stackEl = (TemplateElement)stackEl.getParent();
        }
        return null;
    }

    private void pushLocalContext(LocalContext localContext) {
        if (this.localContextStack == null) {
            this.localContextStack = new ArrayList();
        }
        this.localContextStack.add(localContext);
    }

    private void popLocalContext() {
        this.localContextStack.remove(this.localContextStack.size() - 1);
    }

    ArrayList getLocalContextStack() {
        return this.localContextStack;
    }

    public Namespace getNamespace(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.loadedLibs != null) {
            return (Namespace)this.loadedLibs.get(name);
        }
        return null;
    }

    public Namespace getMainNamespace() {
        return this.mainNamespace;
    }

    public Namespace getCurrentNamespace() {
        return this.currentNamespace;
    }

    public Namespace getGlobalNamespace() {
        return this.globalNamespace;
    }

    public TemplateHashModel getDataModel() {
        final TemplateHashModel result = new TemplateHashModel(){

            public boolean isEmpty() {
                return false;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                TemplateModel value = Environment.this.rootDataModel.get(key);
                if (value == null) {
                    value = Environment.this.getConfiguration().getSharedVariable(key);
                }
                return value;
            }
        };
        if (this.rootDataModel instanceof TemplateHashModelEx) {
            return new TemplateHashModelEx(){

                public boolean isEmpty() throws TemplateModelException {
                    return result.isEmpty();
                }

                public TemplateModel get(String key) throws TemplateModelException {
                    return result.get(key);
                }

                public TemplateCollectionModel values() throws TemplateModelException {
                    return ((TemplateHashModelEx)Environment.this.rootDataModel).values();
                }

                public TemplateCollectionModel keys() throws TemplateModelException {
                    return ((TemplateHashModelEx)Environment.this.rootDataModel).keys();
                }

                public int size() throws TemplateModelException {
                    return ((TemplateHashModelEx)Environment.this.rootDataModel).size();
                }
            };
        }
        return result;
    }

    public TemplateHashModel getGlobalVariables() {
        return new TemplateHashModel(){

            public boolean isEmpty() {
                return false;
            }

            public TemplateModel get(String key) throws TemplateModelException {
                TemplateModel result = Environment.this.globalNamespace.get(key);
                if (result == null) {
                    result = Environment.this.rootDataModel.get(key);
                }
                if (result == null) {
                    result = Environment.this.getConfiguration().getSharedVariable(key);
                }
                return result;
            }
        };
    }

    private void pushElement(TemplateElement element) {
        this.instructionStack.add(element);
    }

    private void popElement() {
        this.instructionStack.remove(this.instructionStack.size() - 1);
    }

    void replaceElementStackTop(TemplateElement instr) {
        this.instructionStack.set(this.instructionStack.size() - 1, instr);
    }

    public TemplateNodeModel getCurrentVisitorNode() {
        return this.currentVisitorNode;
    }

    public void setCurrentVisitorNode(TemplateNodeModel node) {
        this.currentVisitorNode = node;
    }

    TemplateModel getNodeProcessor(TemplateNodeModel node) throws TemplateException {
        String nodeName = node.getNodeName();
        if (nodeName == null) {
            throw new _MiscTemplateException(this, "Node name is null.");
        }
        TemplateModel result = this.getNodeProcessor(nodeName, node.getNodeNamespace(), 0);
        if (result == null) {
            String type = node.getNodeType();
            if (type == null) {
                type = "default";
            }
            result = this.getNodeProcessor("@" + type, null, 0);
        }
        return result;
    }

    private TemplateModel getNodeProcessor(String nodeName, String nsURI, int startIndex) throws TemplateException {
        int i;
        TemplateModel result = null;
        for (i = startIndex; i < this.nodeNamespaces.size(); ++i) {
            Namespace ns = null;
            try {
                ns = (Namespace)this.nodeNamespaces.get(i);
            }
            catch (ClassCastException cce) {
                throw new _MiscTemplateException(this, "A \"using\" clause should contain a sequence of namespaces or strings that indicate the location of importable macro libraries.");
            }
            result = this.getNodeProcessor(ns, nodeName, nsURI);
            if (result != null) break;
        }
        if (result != null) {
            this.nodeNamespaceIndex = i + 1;
            this.currentNodeName = nodeName;
            this.currentNodeNS = nsURI;
        }
        return result;
    }

    private TemplateModel getNodeProcessor(Namespace ns, String localName, String nsURI) throws TemplateException {
        TemplateModel result = null;
        if (nsURI == null) {
            result = ns.get(localName);
            if (!(result instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                result = null;
            }
        } else {
            Template template = ns.getTemplate();
            String prefix = template.getPrefixForNamespace(nsURI);
            if (prefix == null) {
                return null;
            }
            if (prefix.length() > 0) {
                result = ns.get(prefix + ":" + localName);
                if (!(result instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
            } else {
                if (nsURI.length() == 0 && !((result = ns.get("N:" + localName)) instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
                if (nsURI.equals(template.getDefaultNS()) && !((result = ns.get("D:" + localName)) instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
                if (result == null && !((result = ns.get(localName)) instanceof Macro) && !(result instanceof TemplateTransformModel)) {
                    result = null;
                }
            }
        }
        return result;
    }

    public void include(String name, String encoding, boolean parse) throws IOException, TemplateException {
        this.include(this.getTemplateForInclusion(name, encoding, parse));
    }

    public Template getTemplateForInclusion(String name, String encoding, boolean parse) throws IOException {
        return this.getTemplateForInclusion(name, encoding, parse, false);
    }

    public Template getTemplateForInclusion(String name, String encoding, boolean parseAsFTL, boolean ignoreMissing) throws IOException {
        Template inheritedTemplate = this.getTemplate();
        if (encoding == null && (encoding = inheritedTemplate.getEncoding()) == null) {
            encoding = this.getConfiguration().getEncoding(this.getLocale());
        }
        Object customLookupCondition = inheritedTemplate.getCustomLookupCondition();
        return this.getConfiguration().getTemplate(name, this.getLocale(), customLookupCondition, encoding, parseAsFTL, ignoreMissing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(Template includedTemplate) throws TemplateException, IOException {
        Template prevTemplate;
        boolean parentReplacementOn = this.isIcI2322OrLater();
        if (parentReplacementOn) {
            prevTemplate = this.getTemplate();
            this.setParent(includedTemplate);
        } else {
            prevTemplate = null;
        }
        this.importMacros(includedTemplate);
        try {
            this.visit(includedTemplate.getRootTreeNode());
        }
        finally {
            if (parentReplacementOn) {
                this.setParent(prevTemplate);
            }
        }
    }

    public Namespace importLib(String name, String namespace) throws IOException, TemplateException {
        return this.importLib(this.getTemplateForImporting(name), namespace);
    }

    public Template getTemplateForImporting(String name) throws IOException {
        return this.getTemplateForInclusion(name, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Namespace importLib(Template loadedTemplate, String namespace) throws IOException, TemplateException {
        String templateName;
        Namespace existingNamespace;
        if (this.loadedLibs == null) {
            this.loadedLibs = new HashMap();
        }
        if ((existingNamespace = (Namespace)this.loadedLibs.get(templateName = loadedTemplate.getName())) != null) {
            if (namespace != null) {
                this.setVariable(namespace, existingNamespace);
            }
        } else {
            Namespace newNamespace = new Namespace(loadedTemplate);
            if (namespace != null) {
                this.currentNamespace.put(namespace, newNamespace);
                if (this.currentNamespace == this.mainNamespace) {
                    this.globalNamespace.put(namespace, newNamespace);
                }
            }
            Namespace prevNamespace = this.currentNamespace;
            this.currentNamespace = newNamespace;
            this.loadedLibs.put(templateName, this.currentNamespace);
            Writer prevOut = this.out;
            this.out = NullWriter.INSTANCE;
            try {
                this.include(loadedTemplate);
            }
            finally {
                this.out = prevOut;
                this.currentNamespace = prevNamespace;
            }
        }
        return (Namespace)this.loadedLibs.get(templateName);
    }

    public String toFullTemplateName(String baseName, String targetName) throws MalformedTemplateNameException {
        if (this.isClassicCompatible()) {
            return targetName;
        }
        return _CacheAPI.toAbsoluteName(this.getConfiguration().getTemplateNameFormat(), baseName, targetName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String renderElementToString(TemplateElement te) throws IOException, TemplateException {
        Writer prevOut = this.out;
        try {
            StringWriter sw = new StringWriter();
            this.out = sw;
            this.visit(te);
            String string = sw.toString();
            return string;
        }
        finally {
            this.out = prevOut;
        }
    }

    void importMacros(Template template) {
        Iterator it = template.getMacros().values().iterator();
        while (it.hasNext()) {
            this.visitMacroDef((Macro)it.next());
        }
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.currentNamespace.getTemplate().getNamespaceForPrefix(prefix);
    }

    public String getPrefixForNamespace(String nsURI) {
        return this.currentNamespace.getTemplate().getPrefixForNamespace(nsURI);
    }

    public String getDefaultNS() {
        return this.currentNamespace.getTemplate().getDefaultNS();
    }

    public Object __getitem__(String key) throws TemplateModelException {
        return BeansWrapper.getDefaultInstance().unwrap(this.getVariable(key));
    }

    public void __setitem__(String key, Object o) throws TemplateException {
        this.setGlobalVariable(key, this.getObjectWrapper().wrap(o));
    }

    private boolean isIcI2322OrLater() {
        return this.getConfiguration().getIncompatibleImprovements().intValue() < _TemplateAPI.VERSION_INT_2_3_22;
    }

    boolean getFastInvalidReferenceExceptions() {
        return this.fastInvalidReferenceExceptions;
    }

    boolean setFastInvalidReferenceExceptions(boolean b) {
        boolean res = this.fastInvalidReferenceExceptions;
        this.fastInvalidReferenceExceptions = b;
        return res;
    }

    static {
        C_NUMBER_FORMAT.setGroupingUsed(false);
        C_NUMBER_FORMAT.setDecimalSeparatorAlwaysShown(false);
        NO_OUT_ARGS = new TemplateModel[0];
        EMPTY_BODY_WRITER = new Writer(){

            public void write(char[] cbuf, int off, int len) throws IOException {
                if (len > 0) {
                    throw new IOException("This transform does not allow nested content.");
                }
            }

            public void flush() {
            }

            public void close() {
            }
        };
    }

    public class Namespace
    extends SimpleHash {
        private final Template template;

        Namespace() {
            this.template = Environment.this.getTemplate();
        }

        Namespace(Template template) {
            this.template = template;
        }

        public Template getTemplate() {
            return this.template == null ? Environment.this.getTemplate() : this.template;
        }
    }

    private static final class NumberFormatKey {
        private final String pattern;
        private final Locale locale;

        NumberFormatKey(String pattern, Locale locale) {
            this.pattern = pattern;
            this.locale = locale;
        }

        public boolean equals(Object o) {
            if (o instanceof NumberFormatKey) {
                NumberFormatKey fk = (NumberFormatKey)o;
                return fk.pattern.equals(this.pattern) && fk.locale.equals(this.locale);
            }
            return false;
        }

        public int hashCode() {
            return this.pattern.hashCode() ^ this.locale.hashCode();
        }
    }

    final class NestedElementTemplateDirectiveBody
    implements TemplateDirectiveBody {
        private final TemplateElement element;

        private NestedElementTemplateDirectiveBody(TemplateElement element) {
            this.element = element;
        }

        public void render(Writer newOut) throws TemplateException, IOException {
            Writer prevOut = Environment.this.out;
            Environment.this.out = newOut;
            try {
                Environment.this.visit(this.element);
            }
            finally {
                Environment.this.out = prevOut;
            }
        }

        public TemplateElement getElement() {
            return this.element;
        }
    }
}

